package com.planet_ink.coffee_mud.Libraries.interfaces;
import com.planet_ink.coffee_mud.core.interfaces.*;
import com.planet_ink.coffee_mud.core.*;
import com.planet_ink.coffee_mud.Abilities.interfaces.*;
import com.planet_ink.coffee_mud.Areas.interfaces.*;
import com.planet_ink.coffee_mud.Behaviors.interfaces.*;
import com.planet_ink.coffee_mud.CharClasses.interfaces.*;
import com.planet_ink.coffee_mud.Commands.interfaces.*;
import com.planet_ink.coffee_mud.Common.interfaces.*;
import com.planet_ink.coffee_mud.Exits.interfaces.*;
import com.planet_ink.coffee_mud.Items.interfaces.*;
import com.planet_ink.coffee_mud.Locales.interfaces.*;
import com.planet_ink.coffee_mud.MOBS.interfaces.*;
import com.planet_ink.coffee_mud.Races.interfaces.*;
import java.util.*;
/* 
   Copyright 2000-2006 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public interface TrackingLibrary extends CMObject
{
    public Vector findBastardTheBestWay(Room location,
                                        Room destRoom,
                                        boolean openOnly,
                                        boolean areaOnly,
                                        boolean noEmptyGrids,
                                        boolean noAir,
                                        boolean noWater,
                                        int maxRadius);
    public Vector findBastardTheBestWay(Room location,
                                        Vector destRooms,
                                        boolean openOnly,
                                        boolean areaOnly,
                                        boolean noEmptyGrids,
                                        boolean noAir,
                                        boolean noWater,
                                        int maxRadius);
    public int trackNextDirectionFromHere(Vector theTrail, Room location, boolean openOnly);
    public void stopTracking(MOB mob);
    public int radiatesFromDir(Room room, Vector rooms);
    public void getRadiantRooms(Room room,
                                Vector rooms,
                                boolean openOnly,
                                boolean areaOnly,
                                boolean noEmptyGrids,
                                boolean noAir,
                                boolean noWater,
                                Room radiateTo,
                                int maxDepth,
                                HashSet ignoreRooms);
	public Vector getRadiantRooms(Room room,
								  boolean openOnly,
								  boolean areaOnly,
								  boolean noEmptyGrids,
								  boolean noAir,
								  boolean noWater,
								  int maxDepth);
    public boolean beMobile(MOB mob,
                            boolean dooropen,
                            boolean wander,
                            boolean roomprefer, 
                            boolean roomobject,
                            long[] status,
                            Vector rooms);
    public void wanderAway(MOB M, boolean mindPCs, boolean andGoHome);
    public void wanderFromTo(MOB M, Room toHere, boolean mindPCs);
    public void wanderIn(MOB M, Room toHere);
    public boolean move(MOB mob, int directionCode, boolean flee, boolean nolook, boolean noriders);
    public boolean move(MOB mob, int directionCode, boolean flee, boolean nolook);
    public int findExitDir(MOB mob, Room R, String desc);
    public int findRoomDir(MOB mob, Room R);
	public Vector findAllTrails(Room from, Room to, Vector radiantTrail);
	public Vector findAllTrails(Room from, Vector tos, Vector radiantTrail);
}
