package com.planet_ink.coffee_mud.Libraries.interfaces;
import com.planet_ink.coffee_mud.core.interfaces.*;
import com.planet_ink.coffee_mud.core.*;
import com.planet_ink.coffee_mud.Abilities.interfaces.*;
import com.planet_ink.coffee_mud.Areas.interfaces.*;
import com.planet_ink.coffee_mud.Behaviors.interfaces.*;
import com.planet_ink.coffee_mud.CharClasses.interfaces.*;
import com.planet_ink.coffee_mud.Commands.interfaces.*;
import com.planet_ink.coffee_mud.Common.interfaces.*;
import com.planet_ink.coffee_mud.Exits.interfaces.*;
import com.planet_ink.coffee_mud.Items.interfaces.*;
import com.planet_ink.coffee_mud.Locales.interfaces.*;
import com.planet_ink.coffee_mud.MOBS.interfaces.*;
import com.planet_ink.coffee_mud.Races.interfaces.*;
import java.util.*;
/* 
   Copyright 2000-2006 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public interface ExpLevelLibrary extends CMObject
{
    /**
     * Returns how much experience a player must have to be the given level.
     * @param level the level to base the exp on
     * @return the amount of experiene required to be the given level
     */
	public int getLevelExperience(int level);
	
    public void handleExperienceChange(CMMsg msg);
    
    public boolean postExperience(MOB mob, MOB victim, String homage, int amount, boolean quiet);
    
	public StringBuffer baseLevelAdjuster(MOB mob, int adjuster);
	
	public void level(MOB mob);
	
	public void unLevel(MOB mob);
	
	/**
	 * Called whenever a player actually gains any experience.  It actually does
	 * the experience gain for the player as well as determining how much, if any
	 * should be distributed to leiges or clans.  Will automatically cause a call
	 * to level if necessary.
	 * @see ExpLevelLibrary#level(MOB)
	 * @param mob the mob to distribute experience to
	 * @param victim the mob killed, if any, to cause the experience gain
	 * @param homage the name, if any, of another mob whose gain experience is causing this gain
	 * @param amount the amount of experience to gain
	 * @param quiet true if no messages should be given
	 */
	public void gainExperience(MOB mob, MOB victim, String homage, int amount, boolean quiet);

	/**
	 * Called whenever a member of this class loses any experience.  It actually does
	 * the experience loss for the player as well as determining how much, if any
	 * should be taken awa from leiges or clans.  Will automatically cause an unleveling
	 * if necessary.
	 * @see ExpLevelLibrary#unLevel(MOB)
	 * @param mob the mob to take experience away from
	 * @param amount the amount of experience to take away
	 */
	public void loseExperience(MOB mob, int amount);
}
