/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.planet_ink.siplet.support.MSPplayer;
import com.planet_ink.siplet.support.Util;
import java.applet.Applet;
import java.util.Hashtable;
import java.util.Vector;

public class MSP {
    private static Hashtable cache = new Hashtable();
    private String defMusicPath = null;
    private String defSoundPath = null;
    private String defPath = null;
    private MSPplayer musicClip = null;
    private MSPplayer soundClip = null;

    public String trimQuotes(String s) {
        if ((s = s.trim()).startsWith("\"") && (s = s.substring(1)).endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.trim();
    }

    public int process(StringBuffer buf, int i, Applet applet) {
        MSPplayer currentClip;
        int oldI = i;
        if (i + 12 >= buf.length()) {
            return -2;
        }
        String tag = buf.substring(i + 2, i + 7).toUpperCase();
        if (!tag.equals("SOUND") && !tag.equals("MUSIC")) {
            return -2;
        }
        if (buf.charAt(i + 7) != '(') {
            return -2;
        }
        i += 7;
        Vector<String> parts = new Vector<String>();
        StringBuffer part = new StringBuffer("");
        boolean done = false;
        while (++i < buf.length() && !done) {
            switch (buf.charAt(i)) {
                case ')': {
                    if (part.length() > 0) {
                        parts.addElement(part.toString());
                    }
                    done = true;
                    break;
                }
                case ' ': {
                    if (part.length() > 0) {
                        parts.addElement(part.toString());
                    }
                    part.setLength(0);
                    break;
                }
                case '\n': {
                    if (part.length() > 0) {
                        parts.addElement(part.toString());
                    }
                    done = true;
                }
                default: {
                    part.append(buf.charAt(i));
                }
            }
        }
        if (!done) {
            return oldI;
        }
        buf.delete(oldI, i + 1);
        if (parts.size() == 0) {
            return -1;
        }
        MSPplayer mSPplayer = currentClip = tag.equals("MUSIC") ? this.musicClip : this.soundClip;
        if (currentClip != null && !currentClip.playing) {
            if (tag.equals("MUSIC")) {
                this.musicClip = null;
            } else if (tag.equals("SOUND")) {
                this.soundClip = null;
            }
            currentClip = null;
        }
        if (((String)parts.firstElement()).equalsIgnoreCase("off")) {
            if (tag.equals("MUSIC") && this.musicClip != null) {
                this.musicClip.stopPlaying();
            }
            if (tag.equals("SOUND") && this.soundClip != null) {
                this.soundClip.stopPlaying();
            }
            int v = 1;
            while (v < parts.size()) {
                String s = ((String)parts.elementAt(v)).toUpperCase();
                if (s.startsWith("V=")) {
                    if (!(s = this.trimQuotes(s.substring(2))).endsWith("/")) {
                        s = String.valueOf(s) + "/";
                    }
                    if (tag.equals("MUSIC")) {
                        this.defMusicPath = s;
                    } else if (tag.equals("SOUND")) {
                        this.defSoundPath = s;
                    }
                    if (this.defPath != null) break;
                    this.defPath = s;
                    break;
                }
                ++v;
            }
            return -1;
        }
        MSPplayer newOne = new MSPplayer(applet);
        newOne.key = (String)parts.firstElement();
        String string = newOne.url = tag.equals("MUSIC") ? this.defMusicPath : this.defSoundPath;
        if (newOne.url == null) {
            newOne.url = this.defPath;
        }
        String defaultUrl = newOne.url;
        int v = 1;
        while (v < parts.size()) {
            String s = (String)parts.elementAt(v);
            if (s.startsWith("V=") || s.startsWith("v=")) {
                newOne.volume = Util.s_int(this.trimQuotes(s.substring(2)).trim());
            }
            if (s.startsWith("L=") || s.startsWith("l=")) {
                newOne.repeats = Util.s_int(this.trimQuotes(s.substring(2)).trim());
            }
            if (s.startsWith("P=") || s.startsWith("p=")) {
                newOne.priority = Util.s_int(this.trimQuotes(s.substring(2)).trim());
            }
            if (s.startsWith("C=") || s.startsWith("c=")) {
                newOne.continueValue = Util.s_int(this.trimQuotes(s.substring(2)).trim());
            }
            if (s.startsWith("U=") || s.startsWith("u=")) {
                newOne.url = this.trimQuotes(s.substring(2)).trim();
            }
            ++v;
        }
        if (newOne.url != null && !newOne.url.trim().endsWith("/")) {
            newOne.url = String.valueOf(newOne.url.trim()) + "/";
        }
        if (currentClip != null && currentClip.priority >= newOne.priority) {
            return -1;
        }
        if (currentClip != null && currentClip.key.equals(newOne.key)) {
            currentClip.repeats = newOne.repeats;
            if (currentClip.continueValue == 0) {
                currentClip.iterations = 0;
            }
            return -1;
        }
        if (currentClip != null) {
            currentClip.stopPlaying();
            if (tag.equals("MUSIC")) {
                this.musicClip = null;
            } else if (tag.equals("SOUND")) {
                this.soundClip = null;
            }
            currentClip = null;
        }
        if ((currentClip = (MSPplayer)cache.get(newOne.key.toUpperCase())) == null) {
            currentClip = newOne;
            cache.put(newOne.key, currentClip);
        } else {
            if (newOne.volume != 100) {
                currentClip.volume = newOne.volume;
            }
            if (newOne.repeats != 1) {
                currentClip.repeats = newOne.repeats;
            }
            if (newOne.priority != 50) {
                currentClip.priority = newOne.priority;
            }
            if (newOne.continueValue != 1) {
                currentClip.continueValue = newOne.continueValue;
            }
            if (newOne.url != defaultUrl) {
                currentClip.url = newOne.url;
            }
        }
        currentClip.startPlaying();
        if (tag.equals("MUSIC")) {
            this.musicClip = currentClip;
        } else if (tag.equals("SOUND")) {
            this.soundClip = currentClip;
        }
        return -1;
    }
}

