/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.applet;

import com.planet_ink.siplet.support.TelnetFilter;
import java.applet.Applet;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class Siplet
extends Applet {
    public static final boolean debugDataOut = false;
    public static final long serialVersionUID = 6L;
    public static final float VERSION_MAJOR = 2.0f;
    public static final long VERSION_MINOR = 3L;
    protected StringBuffer buf = new StringBuffer("");
    protected Socket sock = null;
    protected InputStream rawin = null;
    protected BufferedReader[] in;
    protected DataOutputStream out;
    protected boolean connected = false;
    protected TelnetFilter Telnet = new TelnetFilter(this);
    protected StringBuffer buffer;
    protected int sillyCounter = 0;

    public void init() {
        this.buffer = new StringBuffer();
    }

    public String info() {
        return "Siplet V2.0.3 (C)2005-2006 Bo Zimmerman";
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public void addItem(String newWord) {
        System.out.println(newWord);
        this.buffer.append(newWord);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        g.drawString(this.buffer.toString(), 5, 15);
    }

    public boolean connectToURL() {
        return this.connectToURL("coffeemud.homeip.net", 23);
    }

    public boolean connectToURL(String url, int port) {
        this.connected = false;
        try {
            this.sock = new Socket(InetAddress.getByName(url), port);
            this.rawin = this.sock.getInputStream();
            this.in = new BufferedReader[1];
            this.in[0] = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.Telnet = new TelnetFilter(this);
            this.connected = true;
        }
        catch (Exception e) {
            ByteArrayOutputStream bw = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bw));
            e.printStackTrace(pw);
            pw.flush();
            return false;
        }
        return true;
    }

    public void disconnectFromURL() {
        this.connected = false;
        try {
            if (this.in != null && this.in[0] != null) {
                this.in[0].close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.sock = null;
    }

    public void sendData(String data) {
        if (this.connected) {
            try {
                if (this.sock.isClosed()) {
                    this.disconnectFromURL();
                } else if (!this.sock.isConnected()) {
                    this.disconnectFromURL();
                } else {
                    this.out.writeBytes(String.valueOf(data) + "\n\r");
                    this.out.flush();
                }
            }
            catch (IOException e) {
                this.disconnectFromURL();
            }
        }
    }

    public String getJScriptCommands() {
        return this.Telnet.getEnquedJScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLData() {
        StringBuffer stringBuffer = this.buf;
        synchronized (stringBuffer) {
            String data;
            int endAt;
            block12: {
                block11: {
                    block10: {
                        String s = this.Telnet.getEnquedResponses();
                        if (s.length() > 0) {
                            this.sendData(s);
                        }
                        endAt = this.Telnet.HTMLFilter(this.buf);
                        data = null;
                        if (this.buf.length() != 0) break block10;
                        return "";
                    }
                    if (endAt < 0) {
                        endAt = this.buf.length();
                    }
                    if (endAt != 0) break block11;
                    return "";
                }
                if (!this.Telnet.isUIonHold()) break block12;
                return "";
            }
            if (endAt < this.buf.length()) {
                data = this.buf.substring(0, endAt).toString();
                this.buf.delete(0, endAt);
            } else {
                data = this.buf.toString();
                this.buf.setLength(0);
            }
            return data;
        }
    }

    public boolean isConnectedToURL() {
        return this.connected;
    }

    public void readURLData() {
        try {
            while (this.connected && this.in[0].ready() && !this.sock.isClosed() && this.sock.isConnected()) {
                try {
                    this.Telnet.TelnetRead(this.buf, this.rawin, this.in);
                }
                catch (InterruptedIOException e) {
                    this.disconnectFromURL();
                    return;
                }
                catch (Exception e) {
                    this.disconnectFromURL();
                    return;
                }
            }
            if (this.sock.isClosed()) {
                this.disconnectFromURL();
            } else if (!this.sock.isConnected()) {
                this.disconnectFromURL();
            } else if (this.buf.length() > 0) {
                this.Telnet.TelenetFilter(this.buf, this.out, this.rawin, this.in);
            }
        }
        catch (Exception e) {
            this.disconnectFromURL();
            return;
        }
    }
}

