/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.planet_ink.siplet.support.Util;
import java.util.Hashtable;
import java.util.Vector;

public class MXPElement
implements Cloneable {
    public static final int BIT_OPEN = 1;
    public static final int BIT_COMMAND = 2;
    public static final int BIT_NEEDTEXT = 4;
    public static final int BIT_SPECIAL = 8;
    public static final int BIT_HTML = 16;
    public static final int BIT_NOTSUPPORTED = 32;
    public static final int BIT_EATTEXT = 64;
    public static final int BIT_DISABLED = 128;
    private String name = "";
    private String definition = "";
    private String attributes = "";
    private String flag = "";
    private String unsupportedParms = "";
    private int bitmap = 0;
    private Vector parsedAttributes = null;
    private Hashtable attributeValues = null;
    private Hashtable alternativeAttributes = null;
    private Vector userParms = new Vector();
    private boolean basicElement = true;
    private int bufInsert = -1;

    public MXPElement(String newName, String theDefinition, String theAttributes, String theFlag, int theBitmap) {
        this.name = newName;
        this.definition = theDefinition;
        this.attributes = theAttributes;
        this.flag = theFlag;
        this.bitmap = theBitmap;
        if (!this.isCommand() && theDefinition.toUpperCase().indexOf("&TEXT;") >= 0) {
            this.bitmap |= 4;
        }
    }

    public MXPElement(String newName, String theDefinition, String theAttributes, String theFlag, int theBitmap, String unsupported) {
        this.name = newName;
        this.definition = theDefinition;
        this.attributes = theAttributes;
        this.flag = theFlag;
        this.bitmap = theBitmap;
        if (!this.isCommand() && theDefinition.toUpperCase().indexOf("&TEXT;") >= 0) {
            this.bitmap |= 4;
        }
        this.unsupportedParms = unsupported;
    }

    public MXPElement copyOf() {
        try {
            MXPElement E = (MXPElement)this.clone();
            if (E.parsedAttributes != null) {
                E.parsedAttributes = (Vector)E.parsedAttributes.clone();
            }
            if (E.attributeValues != null) {
                E.attributeValues = (Hashtable)E.attributeValues.clone();
            }
            if (E.alternativeAttributes != null) {
                E.alternativeAttributes = (Hashtable)E.alternativeAttributes.clone();
            }
            if (E.userParms != null) {
                E.userParms = (Vector)E.userParms.clone();
            }
            return E;
        }
        catch (Exception exception) {
            return this;
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean isCommand() {
        return Util.bset(this.bitmap, 2);
    }

    public boolean isOpen() {
        return Util.bset(this.bitmap, 1);
    }

    public boolean isHTML() {
        return Util.bset(this.bitmap, 16);
    }

    public boolean isSpecialProcessor() {
        return Util.bset(this.bitmap, 8);
    }

    public boolean isDisabled() {
        return Util.bset(this.bitmap, 128);
    }

    public boolean isTextEater() {
        return Util.bset(this.bitmap, 64);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String defi) {
        this.definition = defi;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public boolean needsText() {
        return Util.bset(this.bitmap, 4);
    }

    public void setNotBasicElement() {
        this.basicElement = false;
    }

    public boolean isBasicElement() {
        return this.basicElement;
    }

    public boolean isGenerallySupported() {
        return !Util.bset(this.bitmap, 32);
    }

    public void setBitmap(int newBitmap) {
        this.bitmap = newBitmap;
    }

    public int getBitmap() {
        return this.bitmap;
    }

    public Vector getUnsupportedParms() {
        if (this.unsupportedParms == null || this.unsupportedParms.trim().length() == 0) {
            return new Vector();
        }
        return Util.parseSpaces(this.unsupportedParms, true);
    }

    public void setAttributes(String newAttributes) {
        this.attributes = newAttributes;
        this.parsedAttributes = null;
        this.attributeValues = null;
        this.alternativeAttributes = null;
    }

    public String getAttributeValue(String tag) {
        this.getParsedAttributes();
        return (String)this.attributeValues.get(tag.toUpperCase().trim());
    }

    public void setAttributeValue(String tag, String value) {
        this.getParsedAttributes();
        this.attributeValues.remove(tag);
        if (value != null) {
            this.attributeValues.put(tag, value);
        }
    }

    public synchronized Vector getParsedAttributes() {
        if (this.parsedAttributes != null) {
            return this.parsedAttributes;
        }
        this.parsedAttributes = new Vector();
        this.attributeValues = new Hashtable();
        this.alternativeAttributes = new Hashtable();
        StringBuffer buf = new StringBuffer(this.attributes.trim());
        StringBuffer bit = new StringBuffer("");
        char quotes = '\u0000';
        int i = -1;
        int lastC = 32;
        boolean firstEqual = false;
        while (bit != null && ++i < buf.length()) {
            switch (buf.charAt(i)) {
                case '=': {
                    if (!firstEqual && bit.length() > 0) {
                        String tag = bit.toString().toUpperCase().trim();
                        bit = new StringBuffer("");
                        this.parsedAttributes.addElement(tag);
                        this.attributeValues.put(tag, bit);
                    } else {
                        bit.append(buf.charAt(i));
                    }
                    firstEqual = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (quotes == '\u0000') {
                        if (!firstEqual && bit.length() > 0) {
                            this.parsedAttributes.addElement(bit.toString().toUpperCase().trim());
                        }
                        bit = new StringBuffer("");
                        firstEqual = false;
                        break;
                    }
                    bit.append(buf.charAt(i));
                    break;
                }
                case '\"': 
                case '\'': {
                    if (lastC == 92) {
                        bit.append(buf.charAt(i));
                        break;
                    }
                    if (lastC == 61 || quotes != '\u0000' || quotes == '\u0000' && (lastC == 32 || lastC == 9)) {
                        if (quotes != '\u0000' && quotes == buf.charAt(i)) {
                            quotes = '\u0000';
                            if (!firstEqual && bit.length() > 0) {
                                this.parsedAttributes.addElement(bit.toString().toUpperCase().trim());
                            }
                            bit = new StringBuffer("");
                            firstEqual = false;
                            break;
                        }
                        if (quotes != '\u0000') {
                            bit.append(buf.charAt(i));
                            break;
                        }
                        quotes = buf.charAt(i);
                        break;
                    }
                    bit.append(buf.charAt(i));
                    break;
                }
                default: {
                    bit.append(buf.charAt(i));
                }
            }
            lastC = buf.charAt(i);
        }
        if (!firstEqual && bit.length() > 0) {
            this.parsedAttributes.addElement(bit.toString().toUpperCase().trim());
        }
        int p = this.parsedAttributes.size() - 1;
        while (p >= 0) {
            String PA = (String)this.parsedAttributes.elementAt(p);
            StringBuffer VAL = (StringBuffer)this.attributeValues.get(PA);
            if (VAL != null && this.parsedAttributes.contains(VAL.toString())) {
                this.parsedAttributes.removeElementAt(p);
                this.attributeValues.remove(PA);
                this.alternativeAttributes.put(PA, VAL.toString());
            }
            --p;
        }
        return this.parsedAttributes;
    }

    public String getFlag() {
        return this.flag;
    }

    public Vector getUserParms() {
        return this.userParms;
    }

    public void saveSettings(int insertPoint, Vector theUserParms) {
        this.bufInsert = insertPoint;
        this.userParms = theUserParms;
    }

    public int getBufInsert() {
        return this.bufInsert;
    }

    public void deleteAttribute(String name) {
        this.getParsedAttributes();
        this.attributeValues.remove(name.toUpperCase().trim());
    }

    public Vector getCloseTags(String desc) {
        StringBuffer buf = new StringBuffer(desc);
        Vector<String> tags = new Vector<String>();
        StringBuffer bit = null;
        char quotes = '\u0000';
        int i = -1;
        int lastC = 32;
        while (++i < buf.length()) {
            switch (buf.charAt(i)) {
                case '<': {
                    if (quotes != '\u0000') {
                        bit = null;
                        break;
                    }
                    if (bit != null) {
                        return tags;
                    }
                    bit = new StringBuffer("");
                    break;
                }
                case '>': {
                    if (quotes == '\u0000' && bit != null && bit.toString().trim().length() > 0) {
                        tags.add(bit.toString().toUpperCase().trim());
                    }
                    bit = null;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (quotes == '\u0000' && bit != null && bit.toString().trim().length() > 0) {
                        tags.add(bit.toString().toUpperCase().trim());
                    }
                    bit = null;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (lastC == 92) {
                        bit = null;
                    } else if (quotes != '\u0000' && quotes == buf.charAt(i)) {
                        quotes = '\u0000';
                    } else if (quotes == '\u0000') {
                        quotes = buf.charAt(i);
                    }
                    bit = null;
                    break;
                }
                default: {
                    if (bit != null && Character.isLetterOrDigit(buf.charAt(i))) {
                        bit.append(buf.charAt(i));
                        break;
                    }
                    bit = null;
                }
            }
            lastC = buf.charAt(i);
        }
        return tags;
    }

    public String getFoldedDefinition(String text) {
        Vector aV = this.getParsedAttributes();
        this.attributeValues.remove("TEXT");
        this.attributeValues.put("TEXT", text);
        if (this.userParms != null && this.userParms.size() > 0) {
            int position = -1;
            String avParm = null;
            String userParm = null;
            int u = 0;
            while (u < this.userParms.size()) {
                userParm = ((String)this.userParms.elementAt(u)).toUpperCase().trim();
                int xx = userParm.indexOf("=");
                if (xx > 0 && this.alternativeAttributes.containsKey(userParm.substring(0, xx).trim())) {
                    String newKey = (String)this.alternativeAttributes.get(userParm.substring(0, xx).trim());
                    String uu = (String)this.userParms.elementAt(u);
                    xx = uu.indexOf("=");
                    this.userParms.setElementAt(String.valueOf(newKey) + uu.substring(xx), u);
                    userParm = ((String)this.userParms.elementAt(u)).toUpperCase().trim();
                }
                boolean found = false;
                int a = 0;
                while (a < aV.size()) {
                    avParm = (String)aV.elementAt(a);
                    if (userParm.startsWith(String.valueOf(avParm) + "=") || avParm.equals(userParm)) {
                        found = true;
                        if (a > position) {
                            position = a;
                        }
                        this.attributeValues.remove(avParm);
                        String val = avParm.equals(userParm) ? "" : ((String)this.userParms.elementAt(u)).trim().substring(avParm.length() + 1);
                        this.attributeValues.put(avParm, val);
                        break;
                    }
                    ++a;
                }
                if (!found && position < aV.size() - 1) {
                    avParm = (String)aV.elementAt(++position);
                    this.attributeValues.remove(avParm);
                    this.attributeValues.put(avParm, ((String)this.userParms.elementAt(u)).trim());
                }
                ++u;
            }
        }
        return this.definition;
    }
}

