/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.planet_ink.siplet.support.MXPElement;
import com.planet_ink.siplet.support.MXPEntity;
import com.planet_ink.siplet.support.TelnetFilter;
import com.planet_ink.siplet.support.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MXP {
    public static final boolean tagDebug = false;
    public static final boolean tagDebugLong = false;
    public static final boolean entityDebug = false;
    private int defaultMode = 0;
    public static final int MODE_LINE_OPEN = 0;
    public static final int MODE_LINE_SECURE = 1;
    public static final int MODE_LINE_LOCKED = 2;
    public static final int MODE_RESET = 3;
    public static final int MODE_TEMP_SECURE = 4;
    public static final int MODE_LOCK_OPEN = 5;
    public static final int MODE_LOCK_SECURE = 6;
    public static final int MODE_LOCK_LOCKED = 7;
    public static final int MODE_LINE_ROOMNAME = 10;
    public static final int MODE_LINE_ROOMDESC = 11;
    public static final int MODE_LINE_ROOMEXITS = 12;
    public static final int MODE_LINE_WELCOME = 19;
    private Hashtable elements = new Hashtable();
    private Hashtable tags = new Hashtable();
    private Hashtable entities = new Hashtable();
    private Vector openElements = new Vector();
    public String lastForeground = "WH";
    public String lastBackground = "WH";
    private boolean eatTextUntilEOLN = false;
    private boolean eatNextEOLN = false;
    private boolean eatAllEOLN = false;
    private StringBuffer responses = new StringBuffer("");
    private StringBuffer jscriptBuffer = new StringBuffer("");
    private Vector gauges = new Vector();
    private int mode = 0;

    public MXP() {
        this.initMXP();
    }

    public void initMXP() {
        this.elements.clear();
        this.addElement(new MXPElement("B", "<B>", "", "", 16));
        this.addElement(new MXPElement("BOLD", "<B>", "", "", 16));
        this.addElement(new MXPElement("STRONG", "<B>", "", "", 16));
        this.addElement(new MXPElement("U", "<U>", "", "", 16));
        this.addElement(new MXPElement("UNDERLINE", "<U>", "", "", 16));
        this.addElement(new MXPElement("I", "<I>", "", "", 16));
        this.addElement(new MXPElement("ITALIC", "<I>", "", "", 16));
        this.addElement(new MXPElement("S", "<S>", "", "", 16));
        this.addElement(new MXPElement("STRIKEOUT", "<S>", "", "", 16));
        this.addElement(new MXPElement("EM", "<I>", "", "", 16));
        this.addElement(new MXPElement("H1", "<H1>", "", "", 16));
        this.addElement(new MXPElement("H2", "<H2>", "", "", 16));
        this.addElement(new MXPElement("H3", "<H3>", "", "", 16));
        this.addElement(new MXPElement("H4", "<H4>", "", "", 16));
        this.addElement(new MXPElement("H5", "<H5>", "", "", 16));
        this.addElement(new MXPElement("H6", "<H6>", "", "", 16));
        this.addElement(new MXPElement("HR", "<HR>", "", "", 18));
        this.addElement(new MXPElement("SMALL", "<SMALL>", "", "", 16));
        this.addElement(new MXPElement("TT", "<PRE>", "", "", 16));
        this.addElement(new MXPElement("BR", "<BR>", "", "", 18));
        this.addElement(new MXPElement("SBR", "&nbsp;", "", "", 50));
        this.addElement(new MXPElement("P", "", "", "", 24));
        this.addElement(new MXPElement("C", "<FONT COLOR=&fore; BACK=&back;>", "FORE BACK", "", 0));
        this.addElement(new MXPElement("COLOR", "<FONT COLOR=&fore; BACK=&back;>", "FORE BACK", "", 0));
        this.addElement(new MXPElement("HIGH", "", "", "", 32));
        this.addElement(new MXPElement("H", "", "", "", 32));
        this.addElement(new MXPElement("FONT", "<FONT STYLE=\"color: &color;;background-color: &back;;font-family: &face;;font-size: &size;;\">", "FACE SIZE COLOR BACK STYLE", "", 8));
        this.addElement(new MXPElement("NOBR", "", "", "", 10));
        this.addElement(new MXPElement("A", "<A STYLE=\"&lcc;\" ONMOUSEOVER=\"&onmouseover;\" ONCLICK=\"&onclick;\" HREF=\"&href;\" TITLE=\"&hint;\">", "HREF HINT EXPIRE TITLE=HINT STYLE ONMOUSEOUT ONMOUSEOVER ONCLICK", "", 0, "EXPIRE"));
        this.addElement(new MXPElement("SEND", "<A STYLE=\"&lcc;\" HREF=\"&href;\" ONMOUSEOUT=\"delayhidemenu();\" ONCLICK=\"&onclick;\" TITLE=\"&hint;\">", "HREF HINT PROMPT EXPIRE STYLE", "", 8, "EXPIRE"));
        this.addElement(new MXPElement("EXPIRE", "", "NAME", "", 32));
        this.addElement(new MXPElement("VERSION", "", "", "", 10));
        this.addElement(new MXPElement("SUPPORT", "", "", "", 10));
        this.addElement(new MXPElement("GAUGE", "", "ENTITY MAX CAPTION COLOR", "", 10));
        this.addElement(new MXPElement("STAT", "", "ENTITY MAX CAPTION", "", 42));
        this.addElement(new MXPElement("FRAME", "", "NAME ACTION TITLE INTERNAL ALIGN LEFT TOP WIDTH HEIGHT SCROLLING FLOATING", "", 42));
        this.addElement(new MXPElement("DEST", "", "NAME", "", 40));
        this.addElement(new MXPElement("DESTINATION", "", "NAME", "", 40));
        this.addElement(new MXPElement("RELOCATE", "", "URL PORT", "", 42));
        this.addElement(new MXPElement("USER", "", "", "", 34));
        this.addElement(new MXPElement("PASSWORD", "", "", "", 34));
        this.addElement(new MXPElement("IMAGE", "<IMG SRC=&url;&fname; HEIGHT=&h; WIDTH=&w; ALIGN=&align;>", "FNAME URL T H W HSPACE VSPACE ALIGN ISMAP", "", 2, "HSPACE VSPACE ISMAP"));
        this.addElement(new MXPElement("IMG", "<IMG SRC=&src; HEIGHT=&height; WIDTH=&width; ALIGN=&align;>", "SRC HEIGHT=70 WIDTH=70 ALIGN", "", 2));
        this.addElement(new MXPElement("FILTER", "", "SRC DEST NAME", "", 34));
        this.addElement(new MXPElement("SCRIPT", "", "", "", 34));
        this.addElement(new MXPElement("ENTITY", "", "NAME VALUE DESC PRIVATE PUBLISH DELETE ADD", "", 10, "PRIVATE PUBLISH ADD"));
        this.addElement(new MXPElement("EN", "", "NAME VALUE DESC PRIVATE PUBLISH DELETE ADD", "", 10, "PRIVATE PUBLISH ADD"));
        this.addElement(new MXPElement("TAG", "", "INDEX WINDOWNAME FORE BACK GAG ENABLE DISABLE", "", 10, "WINDOWNAME"));
        this.addElement(new MXPElement("VAR", "", "NAME DESC PRIVATE PUBLISH DELETE ADD REMOVE", "", 8, "PRIVATE PUBLISH ADD REMOVE"));
        this.addElement(new MXPElement("V", "", "NAME DESC PRIVATE PUBLISH DELETE ADD REMOVE", "", 8, "PRIVATE PUBLISH ADD REMOVE"));
        this.addElement(new MXPElement("ELEMENT", "", "NAME DEFINITION ATT TAG FLAG OPEN DELETE EMPTY", "", 10));
        this.addElement(new MXPElement("EL", "", "NAME DEFINITION ATT TAG FLAG OPEN DELETE EMPTY", "", 10));
        this.addElement(new MXPElement("ATTLIST", "", "NAME ATT", "", 10));
        this.addElement(new MXPElement("AT", "", "NAME ATT", "", 10));
        this.addElement(new MXPElement("SOUND", "!!SOUND(&fname; V=&v; L=&l; P=&p; T=&t; U=&u;)", "FNAME V=100 L=1 P=50 T U", "", 2));
        this.addElement(new MXPElement("MUSIC", "!!MUSIC(&fname; V=&v; L=&l; P=&p; T=&t; U=&u;)", "FNAME V=100 L=1 P=50 T U", "", 2));
        this.entities.clear();
        this.entities.put("nbsp", new MXPEntity("nbsp", "&nbsp;"));
        this.entities.put("lt", new MXPEntity("lt", "&lt;"));
        this.entities.put("gt", new MXPEntity("gt", "&gt;"));
        this.entities.put("quot", new MXPEntity("quot", "&quot;"));
        this.entities.put("amp", new MXPEntity("amp", "&amp;"));
    }

    public void addElement(MXPElement E) {
        this.elements.put(E.name(), E);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnyResponses() {
        StringBuffer stringBuffer = this.responses;
        synchronized (stringBuffer) {
            block4: {
                if (this.responses.length() != 0) break block4;
                return "";
            }
            String s = this.responses.toString();
            this.responses.setLength(0);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnyJScript() {
        StringBuffer stringBuffer = this.jscriptBuffer;
        synchronized (stringBuffer) {
            block4: {
                if (this.jscriptBuffer.length() != 0) break block4;
                return "";
            }
            String s = this.jscriptBuffer.toString();
            this.jscriptBuffer.setLength(0);
            return s;
        }
    }

    private int mode() {
        return this.mode;
    }

    private void setMode(int newMode) {
        this.mode = newMode;
    }

    private int setModeAndExecute(int newMode, StringBuffer buf, int i) {
        this.setMode(newMode);
        return this.executeMode(buf, i);
    }

    private int executeMode(StringBuffer buf, int i) {
        switch (this.mode()) {
            case 3: {
                this.mode = this.defaultMode = 0;
                return this.closeAllTags(buf, i);
            }
            case 5: 
            case 6: 
            case 7: {
                this.defaultMode = this.mode;
            }
        }
        return 0;
    }

    public int newlineDetected(StringBuffer buf, int i, boolean[] eatEOL) {
        if (this.mode() == 2 || this.mode() == 7) {
            eatEOL[0] = false;
            return 0;
        }
        eatEOL[0] = this.eatNextEOLN;
        this.eatNextEOLN = this.eatAllEOLN;
        if (this.eatTextUntilEOLN) {
            this.eatTextUntilEOLN = false;
            eatEOL[0] = true;
        }
        switch (this.mode()) {
            case 0: {
                int ret = this.closeAllTags(buf, i);
                this.setModeAndExecute(this.defaultMode, buf, i);
                return ret;
            }
            case 1: 
            case 2: 
            case 4: {
                int ret = this.closeAllTags(buf, i);
                this.setModeAndExecute(this.defaultMode, buf, i);
                return ret;
            }
        }
        return 0;
    }

    private int closeAllTags(StringBuffer buf, int i) {
        MXPElement E = null;
        int x = this.openElements.size() - 1;
        while (x >= 0) {
            E = (MXPElement)this.openElements.elementAt(x);
            if (E.isOpen()) {
                String close = this.closeTag(E);
                if (close.length() > 0) {
                    buf.insert(i, String.valueOf(close) + ">");
                }
                this.openElements.removeElementAt(x);
            }
            --x;
        }
        return 0;
    }

    public boolean isUIonHold() {
        if (this.mode() == 2 || this.mode() == 7) {
            return false;
        }
        MXPElement E = null;
        int i = 0;
        while (i < this.openElements.size()) {
            E = (MXPElement)this.openElements.elementAt(i);
            if (E.needsText()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String closeTag(MXPElement E) {
        Vector endTags = E.getCloseTags(E.getDefinition());
        StringBuffer newEnd = new StringBuffer("");
        int e = endTags.size() - 1;
        while (e >= 0) {
            if (this.elements.containsKey(((String)endTags.elementAt(e)).toUpperCase().trim())) {
                newEnd.append("</" + ((String)endTags.elementAt(e)).toUpperCase().trim());
            }
            --e;
        }
        return newEnd.toString();
    }

    public int escapeTranslate(String escapeString, StringBuffer buf, int i) {
        if (escapeString.endsWith("z")) {
            MXPElement replace;
            buf.delete(i, i + escapeString.length() + 2);
            int code = Util.s0_int(escapeString.substring(0, escapeString.length() - 1));
            if (code < 20) {
                return this.setModeAndExecute(code, buf, i);
            }
            if (code < 100 && (replace = (MXPElement)this.tags.get(new Integer(code))) != null && !replace.isDisabled()) {
                buf.insert(i, replace.getFoldedDefinition(""));
                if (replace.isTextEater()) {
                    this.eatTextUntilEOLN = true;
                }
            }
            return -1;
        }
        return escapeString.length();
    }

    public boolean eatTextUntilNextEOLN() {
        return this.eatTextUntilEOLN;
    }

    private void processAnyEntities(StringBuffer buf, MXPElement currentElement) {
        int i = 0;
        while (i < buf.length()) {
            switch (buf.charAt(i)) {
                case '&': {
                    int x = this.processEntity(buf, i, currentElement, false);
                    if (x == Integer.MAX_VALUE) {
                        return;
                    }
                    i += x;
                }
            }
            ++i;
        }
    }

    private String substr(String buf, int start, int end) {
        return this.substr(new StringBuffer(buf), start, end);
    }

    private String substr(StringBuffer buf, int start, int end) {
        if (start < 0) {
            return "?";
        }
        if (end < start) {
            end = start + 80;
        }
        if (end > buf.length()) {
            end = buf.length();
        }
        String s = buf.substring(start, end);
        s = Util.replaceAll(s, "\n", "\\n");
        s = Util.replaceAll(s, "\r", "\\r");
        return s;
    }

    /*
     * Unable to fully structure code
     */
    public int processTag(StringBuffer buf, int i) {
        if (this.mode() == 2 || this.mode() == 7) {
            buf.setCharAt(i, '&');
            buf.insert(i + 1, "lt;");
            return 3;
        }
        parts = new Vector<String>();
        oldI = i;
        oldOldI = i;
        lastC = 32;
        quotes = '\u0000';
        bit = new StringBuffer("");
        if (i + 1 < buf.length() && (buf.charAt(i + 1) == '!' || buf.charAt(i + 1) == '/')) {
            bit.append(buf.charAt(++i));
        }
        while (bit != null && ++i < buf.length()) {
            switch (buf.charAt(i)) {
                case '\n': 
                case '\r': {
                    buf.setCharAt(oldI, '&');
                    buf.insert(oldI + 1, "lt;");
                    return 3;
                }
                case '\t': 
                case ' ': {
                    if (quotes == '\u0000') {
                        if (bit.length() > 0) {
                            parts.addElement(bit.toString());
                        }
                        bit.setLength(0);
                        break;
                    }
                    bit.append(buf.charAt(i));
                    break;
                }
                case '\"': 
                case '\'': {
                    if (lastC == 92) {
                        if (quotes != '\u0000' || bit.length() > 0) {
                            bit.append(buf.charAt(i));
                            break;
                        }
                        buf.setCharAt(oldI, '&');
                        buf.insert(oldI + 1, "lt;");
                        return 3;
                    }
                    if (lastC == 61 || quotes != '\u0000' || quotes == '\u0000' && (lastC == 32 || lastC == 9)) {
                        if (quotes != '\u0000' && quotes == buf.charAt(i)) {
                            quotes = '\u0000';
                            parts.addElement(bit.toString());
                            bit.setLength(0);
                            break;
                        }
                        if (quotes != '\u0000') {
                            bit.append(buf.charAt(i));
                            break;
                        }
                        quotes = buf.charAt(i);
                        break;
                    }
                    bit.append(buf.charAt(i));
                    break;
                }
                case '<': {
                    if (quotes != '\u0000') {
                        bit.append(buf.charAt(i));
                        break;
                    }
                    buf.setCharAt(oldI, '&');
                    buf.insert(oldI + 1, "lt;");
                    return 3;
                }
                case '>': {
                    if (quotes != '\u0000') {
                        bit.append(buf.charAt(i));
                        break;
                    }
                    if (bit.length() > 0) {
                        parts.add(bit.toString());
                    }
                    bit = null;
                    break;
                }
                default: {
                    if (quotes != '\u0000' || Character.isLetter(buf.charAt(i)) || bit.length() > 0) {
                        bit.append(buf.charAt(i));
                        break;
                    }
                    buf.setCharAt(oldI, '&');
                    buf.insert(oldI + 1, "lt;");
                    return 3;
                }
            }
            lastC = buf.charAt(i);
        }
        if (i >= buf.length() || buf.charAt(i) != '>') {
            return 0x7FFFFFFF;
        }
        endI = i + 1;
        tag = parts.size() > 0 ? ((String)parts.firstElement()).toUpperCase().trim() : "";
        oldString = buf.substring(oldI, endI);
        if (tag.startsWith("!")) {
            tag = tag.substring(1);
        }
        if (endTag = tag.startsWith("/")) {
            tag = tag.substring(1);
        }
        if ((tag = tag.toUpperCase().trim()).length() == 0 || !this.elements.containsKey(tag)) {
            buf.setCharAt(oldI, '&');
            buf.insert(oldI + 1, "lt;");
            return 3;
        }
        E = (MXPElement)this.elements.get(tag);
        text = "";
        if (!endTag) ** GOTO lbl140
        troubleE = null;
        foundAt = -1;
        x = this.openElements.size() - 1;
        while (x >= 0) {
            E = (MXPElement)this.openElements.elementAt(x);
            if (E.name().equals(tag)) {
                foundAt = x;
                this.openElements.removeElementAt(x);
                break;
            }
            if (E.needsText()) {
                troubleE = E;
            }
            --x;
        }
        buf.delete(oldI, endI);
        if (foundAt < 0) {
            return -1;
        }
        if (troubleE != null) {
            this.openElements.removeElement(troubleE);
        }
        if ((close = this.closeTag(E)).length() > 0) {
            buf.insert(oldI, String.valueOf(close.toString()) + ">");
        }
        if (E.needsText()) {
            text = buf.substring(E.getBufInsert(), oldI);
            text = Util.stripBadHTMLTags(Util.replaceAll(text, "&nbsp;", " "));
            oldI = E.getBufInsert();
        } else {
            if (E.isHTML()) {
                if (E.isSpecialProcessor()) {
                    this.specialProcessorElements(E, true);
                }
                return close.length();
            }
            if (close.equals("</" + E.name())) {
                return close.length();
            }
            if (E.getBufInsert() < oldI) {
                return -(oldI - E.getBufInsert() + 1);
            }
            return close.length();
lbl140:
            // 1 sources

            E = E.copyOf();
            parts.removeElementAt(0);
            E.saveSettings(oldI, parts);
            if (!E.isCommand()) {
                this.openElements.addElement(E);
            }
            buf.delete(oldI, endI);
            if (E.needsText()) {
                return -1;
            }
        }
        totalDefinition = E.getFoldedDefinition(text);
        if (endTag && !E.isCommand() && E.getFlag() != null && E.getFlag().length() > 0) {
            f = E.getFlag().trim();
            if (f.toUpperCase().startsWith("SET ")) {
                f = f.substring(4).trim();
            }
            this.modifyEntity(f, text);
        }
        if (E.isSpecialProcessor()) {
            this.specialProcessorElements(E, endTag);
        }
        if (E.isHTML() || totalDefinition.equalsIgnoreCase(oldString)) {
            buf.insert(oldI, totalDefinition);
            if (endTag && oldI < oldOldI) {
                return -(oldOldI - oldI + 1);
            }
            return totalDefinition.length() - 1;
        }
        def = new StringBuffer(totalDefinition);
        this.processAnyEntities(def, E);
        buf.insert(oldI, def.toString());
        if (endTag && oldI < oldOldI) {
            return -(oldOldI - oldI + 1);
        }
        if (def.toString().equalsIgnoreCase(oldString) || E.name().toUpperCase().trim().equals(this.getFirstTag(def.toString().trim()))) {
            return def.toString().length() - 1;
        }
        return -1;
    }

    public String getFirstTag(String s) {
        if (!s.startsWith("<")) {
            return "";
        }
        int x = s.indexOf(" ");
        if (x < 0) {
            x = s.indexOf(">");
        }
        if (x < 0) {
            return "";
        }
        return s.substring(1, x).toUpperCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void specialProcessorElements(MXPElement E, boolean endTag) {
        if (E.name().equals("FONT")) {
            String style = E.getAttributeValue("STYLE");
            String color = E.getAttributeValue("COLOR");
            String back = E.getAttributeValue("BACK");
            String face = E.getAttributeValue("FACE");
            String size = E.getAttributeValue("SIZE");
            if (style != null && color == null && back == null && face == null && size == null) {
                String s = null;
                String v = null;
                while (style.length() > 0) {
                    int x = style.indexOf(";");
                    if (x >= 0) {
                        s = style.substring(0, x).trim();
                        style = style.substring(x + 1).trim();
                    } else {
                        s = style.trim();
                        style = "";
                    }
                    int y = s.indexOf(":");
                    if (y < 0) continue;
                    v = s.substring(y + 1);
                    if ((s = s.substring(0, y)).equalsIgnoreCase("color")) {
                        E.setAttributeValue("COLOR", v);
                        continue;
                    }
                    if (s.equalsIgnoreCase("background-color")) {
                        E.setAttributeValue("BACK", v);
                        continue;
                    }
                    if (s.equalsIgnoreCase("font-size")) {
                        E.setAttributeValue("SIZE", v);
                        continue;
                    }
                    if (!s.equalsIgnoreCase("font-family")) continue;
                    E.setAttributeValue("FACE", v);
                }
                E.setAttributeValue("STYLE", null);
            }
        } else if (E.name().equals("NOBR")) {
            this.eatNextEOLN = true;
        } else if (E.name().equals("P")) {
            if (endTag) {
                this.eatAllEOLN = false;
                this.eatNextEOLN = false;
            } else {
                this.eatAllEOLN = true;
                this.eatNextEOLN = true;
            }
        } else if (E.name().equals("SEND")) {
            String prompt = E.getAttributeValue("PROMPT");
            if (prompt != null && prompt.length() > 0) {
                return;
            }
            prompt = prompt == null ? "false" : "true";
            E.setAttributeValue("PROMPT", prompt);
            String href = E.getAttributeValue("HREF");
            String hint = E.getAttributeValue("HINT");
            if (href == null || href.trim().length() == 0) {
                href = "alert('Nothing done.');";
            }
            if (hint == null || hint.trim().length() == 0) {
                hint = "Click here!";
            }
            hint = Util.replaceAllIgnoreCase(hint, "RIGHT-CLICK", "click");
            hint = Util.replaceAllIgnoreCase(hint, "RIGHT-MOUSE", "click mouse");
            E.setAttributeValue("ONCLICK", "");
            E.setAttributeValue("HREF", "");
            E.setAttributeValue("HINT", "");
            Vector hrefV = Util.parsePipes(href, true);
            Vector hintV = Util.parsePipes(hint, true);
            if (hrefV.size() == 1) {
                href = Util.replaceAll((String)hrefV.firstElement(), "'", "\\'");
                E.setAttributeValue("HREF", "javascript:addToPrompt('" + href + "'," + prompt + ")");
                if (hintV.size() > 1) {
                    hint = (String)hintV.firstElement();
                }
                E.setAttributeValue("HINT", hint);
            } else if (hintV.size() > hrefV.size()) {
                E.setAttributeValue("HINT", (String)hintV.firstElement());
                hintV.removeElementAt(0);
                E.setAttributeValue("HREF", "javascript:goDefault(0);");
                StringBuffer newHint = new StringBuffer("");
                int i = 0;
                while (i < hintV.size()) {
                    newHint.append((String)hintV.elementAt(i));
                    if (i < hintV.size() - 1) {
                        newHint.append("|");
                    }
                    ++i;
                }
                href = Util.replaceAll(href, "'", "\\'");
                hint = Util.replaceAll(newHint.toString(), "'", "\\'");
                E.setAttributeValue("ONCLICK", "return dropdownmenu(this, event, getSendMenu(this,'" + href + "','" + hint + "','" + prompt + "'), '200px');");
            } else {
                E.setAttributeValue("HINT", "Click to open menu");
                E.setAttributeValue("HREF", "javascript:goDefault(0);");
                href = Util.replaceAll(href, "'", "\\'");
                hint = Util.replaceAll(hint, "'", "\\'");
                E.setAttributeValue("ONCLICK", "return dropdownmenu(this, event, getSendMenu(this,'" + href + "','" + hint + "','" + prompt + "'), '200px');");
            }
        } else {
            if (E.name().equals("ELEMENT") || E.name().equals("EL")) {
                String name = E.getAttributeValue("NAME");
                String definition = E.getAttributeValue("DEFINITION");
                String attributes = E.getAttributeValue("ATT");
                String tag = E.getAttributeValue("TAG");
                String flags = E.getAttributeValue("FLAG");
                String OPEN = E.getAttributeValue("OPEN");
                String DELETE = E.getAttributeValue("DELETE");
                String EMPTY = E.getAttributeValue("EMPTY");
                if (name == null) {
                    return;
                }
                if (DELETE != null && this.elements.containsKey(name)) {
                    E = (MXPElement)this.elements.get(name);
                    if (E.isOpen()) {
                        this.elements.remove(name);
                    }
                    return;
                }
                if (definition == null) {
                    definition = "";
                }
                if (attributes == null) {
                    attributes = "";
                }
                int bitmap = 0;
                if (OPEN != null) {
                    bitmap |= 1;
                }
                if (EMPTY != null) {
                    bitmap |= 2;
                }
                MXPElement L = new MXPElement(name.toUpperCase().trim(), definition, attributes, flags, bitmap);
                L.setNotBasicElement();
                this.elements.remove(L.name());
                this.elements.put(L.name(), L);
                if (tag != null && Util.isInteger(tag) && Util.s_int(tag) > 19 && Util.s_int(tag) < 100) {
                    int tagNum = Util.s_int(tag);
                    if (this.tags.containsKey(new Integer(tagNum))) {
                        this.tags.remove(new Integer(tagNum));
                    }
                    this.tags.put(new Integer(tagNum), L);
                }
                return;
            }
            if (E.name().equals("ENTITY") || E.name().equals("EN")) {
                String name = E.getAttributeValue("NAME");
                String value = E.getAttributeValue("VALUE");
                String DELETE = E.getAttributeValue("DELETE");
                String REMOVE = E.getAttributeValue("REMOVE");
                String ADD = E.getAttributeValue("ADD");
                if (name == null || name.length() == 0) {
                    return;
                }
                if (DELETE != null) {
                    this.entities.remove(name);
                    return;
                }
                if (REMOVE == null && ADD == null) {
                    this.modifyEntity(name, value);
                }
                return;
            }
            if ((E.name().equals("VAR") || E.name().equals("V")) && endTag) {
                String name = E.getAttributeValue("NAME");
                String DELETE = E.getAttributeValue("DELETE");
                String REMOVE = E.getAttributeValue("REMOVE");
                String VALUE = E.getAttributeValue("TEXT");
                if (VALUE == null) {
                    VALUE = "";
                }
                String ADD = E.getAttributeValue("ADD");
                if (name == null || name.length() == 0) {
                    return;
                }
                if (DELETE != null) {
                    this.entities.remove(name);
                    return;
                }
                if (REMOVE == null && ADD == null) {
                    this.modifyEntity(name, VALUE);
                }
                return;
            }
            if (E.name().equalsIgnoreCase("VERSION")) {
                this.responses.append("\u001b[1z<VERSION MXP=1.0 STYLE=1.0 CLIENT=Siplet VERSION=" + TelnetFilter.getSipletVersion() + " REGISTERED=NO>\n");
            } else {
                if (E.name().equalsIgnoreCase("GAUGE")) {
                    String COLOR;
                    String ENTITY = E.getAttributeValue("ENTITY");
                    String MAX = E.getAttributeValue("MAX");
                    if (ENTITY == null || MAX == null) {
                        return;
                    }
                    ENTITY = ENTITY.toLowerCase();
                    MAX = MAX.toLowerCase();
                    String CAPTION = E.getAttributeValue("CAPTION");
                    if (CAPTION == null) {
                        CAPTION = "";
                    }
                    if ((COLOR = E.getAttributeValue("COLOR")) == null) {
                        COLOR = "WHITE";
                    }
                    String initEntity = this.getEntityValue(ENTITY, null);
                    int initValue = 0;
                    if (initEntity != null && Util.isInteger(initEntity)) {
                        initValue = Util.s_int(initEntity);
                    }
                    String maxEntity = this.getEntityValue(MAX, null);
                    int maxValue = 100;
                    if (maxEntity != null && Util.isInteger(maxEntity)) {
                        maxValue = Util.s_int(maxEntity);
                    }
                    if (maxValue < initValue) {
                        int n = maxValue = initValue <= 0 ? 100 : initValue;
                    }
                    if (initValue > 0) {
                        initValue = (int)Math.round(Util.mul(100.0, initValue / maxValue));
                    }
                    StringBuffer bitmap = this.jscriptBuffer;
                    synchronized (bitmap) {
                        this.jscriptBuffer.append("createGauge('" + ENTITY + "','" + CAPTION + "','" + COLOR + "'," + initValue + "," + maxValue + ");");
                        String[] gauge = new String[]{ENTITY, MAX};
                        this.gauges.addElement(gauge);
                    }
                }
                if (E.name().equalsIgnoreCase("ATTLIST") || E.name().equalsIgnoreCase("ATT")) {
                    String name = E.getAttributeValue("NAME");
                    String value = E.getAttributeValue("ATT");
                    if (name == null || value == null) {
                        return;
                    }
                    MXPElement E2 = (MXPElement)this.elements.get(name.toUpperCase().trim());
                    if (E2 == null) {
                        return;
                    }
                    E2.setAttributes(value);
                } else if (E.name().equalsIgnoreCase("SUPPORT")) {
                    StringBuffer supportResponse = new StringBuffer("");
                    Vector V = E.getUserParms();
                    if (V == null || V.size() == 0) {
                        Enumeration e = this.elements.elements();
                        while (e.hasMoreElements()) {
                            MXPElement E2 = (MXPElement)e.nextElement();
                            if (!E2.isBasicElement()) continue;
                            Vector unsupportedParms = E2.getUnsupportedParms();
                            if (!E2.isGenerallySupported()) {
                                supportResponse.append(" -" + E2.name());
                                continue;
                            }
                            supportResponse.append(" +" + E2.name());
                            if (unsupportedParms.size() <= 0) continue;
                            int x = 0;
                            while (x < unsupportedParms.size()) {
                                supportResponse.append(" -" + E2.name() + "." + (String)unsupportedParms.elementAt(x));
                                ++x;
                            }
                        }
                    } else {
                        int v = 0;
                        while (v < V.size()) {
                            MXPElement RE;
                            String request = ((String)V.elementAt(v)).trim().toUpperCase();
                            if (request.startsWith("\"")) {
                                request = request.substring(1).trim();
                            }
                            if (request.endsWith("\"")) {
                                request = request.substring(0, request.length() - 1).trim();
                            }
                            if (request.startsWith("'")) {
                                request = request.substring(1).trim();
                            }
                            if (request.endsWith("'")) {
                                request = request.substring(0, request.length() - 1).trim();
                            }
                            int x = request.indexOf(".");
                            String tag = request;
                            String parm = "";
                            if (x > 0) {
                                tag = request.substring(0, x).trim();
                                parm = request.substring(x + 1).trim();
                            }
                            if ((RE = (MXPElement)this.elements.get(tag)) == null || !RE.isGenerallySupported()) {
                                if (parm.length() > 0 && !parm.equals("*")) {
                                    supportResponse.append(" -" + tag + "." + parm);
                                } else {
                                    supportResponse.append(" -" + tag);
                                }
                            } else if (parm.length() == 0) {
                                supportResponse.append(" +" + tag);
                            } else {
                                Vector unsupportedParms = RE.getUnsupportedParms();
                                Vector allAttributes = RE.getParsedAttributes();
                                if (parm.equals("*")) {
                                    int a = 0;
                                    while (a < allAttributes.size()) {
                                        String att = (String)allAttributes.elementAt(a);
                                        if (!unsupportedParms.contains(att)) {
                                            supportResponse.append(" +" + tag + "." + att);
                                        }
                                        ++a;
                                    }
                                } else if (unsupportedParms.contains(parm) || !allAttributes.contains(parm)) {
                                    supportResponse.append(" -" + tag + "." + parm);
                                } else {
                                    supportResponse.append(" +" + tag + "." + parm);
                                }
                            }
                            ++v;
                        }
                    }
                    this.responses.append("\u001b[1z<SUPPORTS" + supportResponse.toString() + ">\n");
                } else if (E.name().equals("TAG")) {
                    MXPElement L;
                    String backColor;
                    this.addElement(new MXPElement("TAG", "", "INDEX WINDOWNAME FORE BACK GAG ENABLE DISABLE", "", 10));
                    String index = E.getAttributeValue("INDEX");
                    if (!Util.isNumber(index)) {
                        return;
                    }
                    int number = Util.s_int(index);
                    if (number < 20 || number > 99) {
                        return;
                    }
                    String foreColor = E.getAttributeValue("FORE");
                    if (foreColor == null) {
                        foreColor = "";
                    }
                    if ((backColor = E.getAttributeValue("BACK")) == null) {
                        backColor = "";
                    }
                    String gag = E.getAttributeValue("GAG");
                    String enable = E.getAttributeValue("ENABLE");
                    String disable = E.getAttributeValue("DISABLE");
                    StringBuffer parms = new StringBuffer("");
                    if (foreColor.length() > 0 || backColor.length() > 0) {
                        parms.append("<FONT ");
                        if (foreColor.length() > 0) {
                            parms.append(" COLOR=" + foreColor);
                        }
                        if (backColor.length() > 0) {
                            parms.append(" BACK=" + backColor);
                        }
                        parms.append(">");
                    }
                    if ((L = (MXPElement)this.tags.get(new Integer(number))) == null) {
                        return;
                    }
                    int newBitmap = L.getBitmap();
                    if (gag != null) {
                        newBitmap |= 0x40;
                    } else if (disable != null) {
                        newBitmap |= 0x80;
                    } else if (L.isDisabled() && enable != null) {
                        newBitmap -= 128;
                    }
                    L.setBitmap(newBitmap);
                    if (parms.length() > 0) {
                        String definition = Util.stripBadHTMLTags(L.getDefinition());
                        L.setDefinition(String.valueOf(definition) + parms.toString());
                    }
                    return;
                }
            }
        }
    }

    public String getEntityValue(String tag, MXPElement currentE) {
        String val = null;
        if (tag.equalsIgnoreCase("lcc")) {
            val = "color: " + this.lastForeground + "; background-color: " + this.lastBackground;
        }
        if (val == null) {
            String string = val = currentE != null ? currentE.getAttributeValue(tag) : null;
        }
        if (val == null && currentE != null) {
            val = currentE.getAttributeValue(tag.toLowerCase());
        }
        if (val == null && currentE != null) {
            val = currentE.getAttributeValue(tag.toUpperCase());
        }
        if (val == null && currentE == null) {
            MXPElement E;
            int x;
            if (val == null) {
                x = this.openElements.size() - 1;
                while (x >= 0) {
                    E = (MXPElement)this.openElements.elementAt(x);
                    val = E.getAttributeValue(tag);
                    if (val != null) break;
                    --x;
                }
            }
            if (val == null) {
                x = this.openElements.size() - 1;
                while (x >= 0) {
                    E = (MXPElement)this.openElements.elementAt(x);
                    val = E.getAttributeValue(tag.toLowerCase());
                    if (val != null) break;
                    --x;
                }
            }
            if (val == null) {
                x = this.openElements.size() - 1;
                while (x >= 0) {
                    E = (MXPElement)this.openElements.elementAt(x);
                    val = E.getAttributeValue(tag.toUpperCase());
                    if (val != null) break;
                    --x;
                }
            }
        }
        if (val == null) {
            MXPEntity N = (MXPEntity)this.entities.get(tag);
            if (N == null) {
                N = (MXPEntity)this.entities.get(tag.toLowerCase());
            }
            if (N == null) {
                N = (MXPEntity)this.entities.get(tag.toUpperCase());
            }
            if (N != null) {
                val = N.getDefinition();
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyEntity(String name, String value) {
        MXPEntity X = (MXPEntity)this.entities.get(name = name.toLowerCase());
        if (X == null) {
            X = new MXPEntity(name, value);
            this.entities.put(name, X);
        } else {
            if (X.getDefinition().equalsIgnoreCase(value)) {
                return;
            }
            X.setDefinition(value);
        }
        String[] gauge = null;
        int g = 0;
        while (g < this.gauges.size()) {
            gauge = (String[])this.gauges.elementAt(g);
            if (gauge[0].equalsIgnoreCase(name) || gauge[1].equalsIgnoreCase(name)) {
                String initEntity = this.getEntityValue(gauge[0], null);
                int initValue = 0;
                if (initEntity != null && Util.isInteger(initEntity)) {
                    initValue = Util.s_int(initEntity);
                }
                String maxEntity = this.getEntityValue(gauge[1], null);
                int maxValue = 100;
                if (maxEntity != null && Util.isInteger(maxEntity)) {
                    maxValue = Util.s_int(maxEntity);
                }
                if (maxValue < initValue) {
                    int n = maxValue = initValue <= 0 ? 100 : initValue;
                }
                if (initValue > 0) {
                    initValue = (int)Math.round(Util.mul(100.0, Util.div(initValue, maxValue)));
                }
                StringBuffer stringBuffer = this.jscriptBuffer;
                synchronized (stringBuffer) {
                    this.jscriptBuffer.append("modifyGauge('" + gauge[0] + "'," + initValue + "," + maxValue + ");");
                }
            }
            ++g;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownMXP() {
        this.openElements.clear();
        this.eatAllEOLN = false;
        this.eatNextEOLN = false;
        this.eatTextUntilEOLN = false;
        this.initMXP();
        this.jscriptBuffer.setLength(0);
        this.responses.setLength(0);
        while (this.gauges.size() > 0) {
            StringBuffer stringBuffer = this.jscriptBuffer;
            synchronized (stringBuffer) {
                this.jscriptBuffer.append("removeGauge('" + ((String[])this.gauges.elementAt(0))[0] + "');");
            }
            this.gauges.removeElementAt(0);
        }
        this.mode = 0;
        this.defaultMode = 0;
        this.tags.clear();
    }

    /*
     * Unable to fully structure code
     */
    public int processEntity(StringBuffer buf, int i, MXPElement currentE, boolean convertIfNecessary) {
        block17: {
            if (this.mode() == 2 || this.mode() == 7) {
                return 0;
            }
            convertIt = false;
            oldI = i;
            content = new StringBuffer("");
            if (buf.charAt(i + 1) != '#' || !Character.isDigit(buf.charAt(i + 2))) ** GOTO lbl28
            ++i;
            while (++i < buf.length()) {
                if (buf.charAt(i) == ';') {
                    convertIt = false;
                } else {
                    if (Character.isDigit(buf.charAt(i))) continue;
                    convertIt = true;
                }
                break block17;
            }
            break block17;
lbl-1000:
            // 1 sources

            {
                if (buf.charAt(i) == ';') {
                    convertIt = false;
                    break;
                }
                if (!Character.isLetterOrDigit(buf.charAt(i))) {
                    convertIt = true;
                    break;
                }
                if (!Character.isLetter(buf.charAt(i)) && content.length() == 0) {
                    convertIt = true;
                    break;
                }
                content.append(buf.charAt(i));
                if (content.length() > 20) break;
lbl28:
                // 2 sources

                ** while (++i < buf.length())
            }
        }
        if (i >= buf.length() && content.length() > 0 && buf.length() - i < 10) {
            return 0x7FFFFFFF;
        }
        if (convertIt || content.length() == 0 || buf.charAt(i) != ';') {
            if (convertIfNecessary) {
                buf.insert(oldI + 1, "amp;");
                return 4;
            }
            return 0;
        }
        tag = content.toString().trim();
        val = this.getEntityValue(tag, currentE);
        oldValue = buf.substring(oldI, i + 1);
        buf.delete(oldI, i + 1);
        if (val != null) {
            if (currentE != null && currentE.name().equalsIgnoreCase("FONT")) {
                if (tag.equalsIgnoreCase("COLOR")) {
                    this.lastForeground = val;
                } else if (tag.equalsIgnoreCase("BACK")) {
                    this.lastBackground = val;
                }
            }
            buf.insert(oldI, val);
            if (val.equalsIgnoreCase(oldValue) || currentE != null) {
                return val.length() - 1;
            }
            return -1;
        }
        return -1;
    }
}

