/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.jcraft.jzlib.ZInputStream;
import com.planet_ink.siplet.applet.Siplet;
import com.planet_ink.siplet.support.MSP;
import com.planet_ink.siplet.support.MXP;
import com.planet_ink.siplet.support.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Vector;

public class TelnetFilter {
    public static final boolean debugChars = false;
    public static final boolean debugTelnetCodes = false;
    protected static final char IAC_SE = '\u00f0';
    protected static final char IAC_ = '\u00ff';
    protected static final char IAC_SB = '\u00fa';
    protected static final char IAC_DO = '\u00fd';
    protected static final char IAC_WILL = '\u00fb';
    protected static final char IAC_WONT = '\u00fc';
    protected static final char IAC_DONT = '\u00fe';
    protected static final char IAC_MSP = 'Z';
    protected static final char IAC_MXP = '[';
    protected static final char TELOPT_BINARY = '\u0000';
    protected static final char TELOPT_EOR = '\u0019';
    protected static final char TELOPT_ECHO = '\u0001';
    protected static final char TELOPT_NAWS = '\u001f';
    protected static final char TELOPT_TTYPE = '\u0018';
    protected static final char TELOPT_TSPEED = ' ';
    protected static final char MCCP_COMPRESS = 'U';
    protected static final char MCCP_COMPRESS2 = 'V';
    protected static final char TELOPT_NEWENVIRONMENT = '\'';
    private static String defaultBackground = "black";
    private static String defaultForeground = "white";
    private static String[] colorCodes1 = new String[]{"black", "#993300", "green", "#999966", "#000099", "purple", "darkcyan", "lightgrey"};
    private static String[] colorCodes2 = new String[]{"gray", "red", "lightgreen", "yellow", "blue", "violet", "cyan", "white"};
    protected String lastBackground = null;
    protected String lastForeground = null;
    protected boolean blinkOn = false;
    protected boolean fontOn = false;
    protected boolean boldOn = false;
    protected boolean underlineOn = false;
    protected boolean italicsOn = false;
    private Siplet codeBase = null;
    protected boolean comment = false;
    protected boolean neverSupportMSP = false;
    protected boolean neverSupportMXP = false;
    protected boolean neverSupportMCCP = false;
    protected boolean MSPsupport = false;
    protected boolean MXPsupport = false;
    protected boolean MCCPsupport = false;
    private MSP mspModule = new MSP();
    private MXP mxpModule = new MXP();
    public static final char[] mccppattern = new char[]{'\u00ff', '\u00fa', 'V', '\u00ff', '\u00f0'};
    public int patDex = 0;

    private TelnetFilter() {
    }

    public TelnetFilter(Siplet codebase) {
        this.codeBase = codebase;
    }

    public static String getSipletVersion() {
        return "2.0.3";
    }

    public String getEnquedResponses() {
        return this.MXPsupport() ? this.mxpModule.getAnyResponses() : "";
    }

    public String getEnquedJScript() {
        return this.mxpModule != null ? this.mxpModule.getAnyJScript() : "";
    }

    public boolean MSPsupport() {
        return this.MSPsupport;
    }

    public void setMSPSupport(boolean truefalse) {
        this.MSPsupport = truefalse;
    }

    public boolean MXPsupport() {
        return this.MXPsupport;
    }

    public void setMXPSupport(boolean truefalse) {
        this.MXPsupport = truefalse;
    }

    public boolean MCCPsupport() {
        return this.MCCPsupport;
    }

    public void setMCCPSupport(boolean truefalse) {
        this.MCCPsupport = truefalse;
    }

    public boolean isUIonHold() {
        return this.MXPsupport() && this.mxpModule.isUIonHold();
    }

    private String blinkOff() {
        if (this.blinkOn) {
            this.blinkOn = false;
            return "</BLINK>";
        }
        return "";
    }

    private String underlineOff() {
        if (this.underlineOn) {
            this.underlineOn = false;
            return "</U>";
        }
        return "";
    }

    private String fontOff() {
        if (this.fontOn) {
            this.setLastBackground(defaultBackground);
            this.setLastForeground(defaultForeground);
            this.fontOn = false;
            return "</FONT>";
        }
        return "";
    }

    private String italicsOff() {
        if (this.italicsOn) {
            this.italicsOn = false;
            return "</I>";
        }
        return "";
    }

    private String allOff() {
        StringBuffer off = new StringBuffer("");
        off.append(this.blinkOff());
        off.append(this.underlineOff());
        off.append(this.fontOff());
        off.append(this.italicsOff());
        return off.toString();
    }

    public static int getColorCodeIndex(String word) {
        if (word == null) {
            word = defaultForeground;
        }
        int i = 0;
        while (i < colorCodes1.length) {
            if (word.equalsIgnoreCase(colorCodes1[i])) {
                return 40 + i;
            }
            ++i;
        }
        i = 0;
        while (i < colorCodes2.length) {
            if (word.equalsIgnoreCase(colorCodes2[i])) {
                return 30 + i;
            }
            ++i;
        }
        return 30;
    }

    public static int getRelativeColorCodeIndex(String word) {
        int x = TelnetFilter.getColorCodeIndex(word);
        if (x < 40) {
            return x - 30;
        }
        if (x > 50) {
            return x % 10;
        }
        return x - 40;
    }

    private void setLastBackground(String val) {
        if (this.MXPsupport()) {
            this.mxpModule.lastBackground = val;
        } else {
            this.lastBackground = val;
        }
    }

    private void setLastForeground(String val) {
        if (this.MXPsupport()) {
            this.mxpModule.lastForeground = val;
        } else {
            this.lastForeground = val;
        }
    }

    private String lastBackground() {
        return this.MXPsupport() ? this.mxpModule.lastBackground : this.lastBackground;
    }

    private String lastForeground() {
        return this.MXPsupport() ? this.mxpModule.lastForeground : this.lastForeground;
    }

    private String escapeTranslate(String escapeString) {
        if (escapeString.endsWith("m")) {
            Vector V = Util.parseSemicolons(escapeString.substring(0, escapeString.length() - 1), true);
            StringBuffer str = new StringBuffer("");
            String s = null;
            int code = 0;
            String background = null;
            String foreground = null;
            int i = 0;
            while (i < V.size()) {
                s = (String)V.elementAt(i);
                code = Util.s0_int(s);
                switch (code) {
                    case 0: {
                        if (i == V.size() - 1) {
                            str.append(this.allOff());
                        }
                        this.boldOn = false;
                        break;
                    }
                    case 1: {
                        this.boldOn = true;
                        if (V.size() != 1 || this.lastForeground() == null) break;
                        foreground = colorCodes2[TelnetFilter.getRelativeColorCodeIndex(this.lastForeground())];
                        break;
                    }
                    case 4: {
                        if (this.underlineOn) break;
                        this.underlineOn = true;
                        str.append("<U>");
                        break;
                    }
                    case 5: {
                        if (this.blinkOn) break;
                        this.blinkOn = true;
                        str.append("<BLINK>");
                        break;
                    }
                    case 6: {
                        if (this.italicsOn) break;
                        this.italicsOn = true;
                        str.append("<I>");
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        background = defaultBackground;
                        foreground = defaultBackground;
                        break;
                    }
                    case 22: {
                        str.append(this.allOff());
                        break;
                    }
                    case 24: {
                        str.append(this.underlineOff());
                        break;
                    }
                    case 25: {
                        str.append(this.blinkOff());
                        break;
                    }
                    case 26: {
                        str.append(this.italicsOff());
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        foreground = this.boldOn ? colorCodes2[code - 30] : colorCodes1[code - 30];
                        break;
                    }
                    case 39: {
                        foreground = defaultForeground;
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        background = colorCodes1[code - 40];
                        break;
                    }
                    case 49: {
                        background = defaultForeground;
                    }
                }
                if (background != null || foreground != null) {
                    if (this.lastBackground() == null) {
                        this.setLastBackground(defaultBackground);
                    }
                    if (this.lastForeground() == null) {
                        this.setLastForeground(defaultForeground);
                    }
                    if (background == null) {
                        background = this.lastBackground();
                    }
                    if (foreground == null) {
                        foreground = this.lastForeground();
                    }
                    if (!background.equals(this.lastBackground()) || !foreground.equals(this.lastForeground())) {
                        str.append(this.fontOff());
                        this.setLastBackground(background);
                        this.setLastForeground(foreground);
                        this.fontOn = true;
                        if (this.MXPsupport()) {
                            str.append("<FONT COLOR=" + foreground + " BACK=" + background + ">");
                        } else {
                            str.append("<FONT STYLE=\"color: " + foreground + ";background-color: " + background + "\">");
                        }
                    }
                }
                ++i;
            }
            return str.toString();
        }
        return escapeString;
    }

    public void TelnetRead(StringBuffer buf, InputStream rawin, BufferedReader[] in) throws InterruptedIOException, IOException {
        char c = (char)in[0].read();
        if (mccppattern[this.patDex] == c) {
            ++this.patDex;
            if (this.patDex >= mccppattern.length && !this.neverSupportMCCP) {
                while (rawin.available() > 0) {
                    rawin.read();
                }
                ZInputStream zIn = new ZInputStream(rawin);
                in[0] = new BufferedReader(new InputStreamReader((InputStream)zIn));
                this.patDex = 0;
            }
            return;
        }
        if (this.patDex > 0) {
            int i = 0;
            while (i < this.patDex) {
                buf.append(mccppattern[i]);
                ++i;
            }
            this.patDex = 0;
        }
        buf.append(c);
        if (c == '\uffff') {
            throw new InterruptedIOException("ARGH!");
        }
    }

    public int TelenetFilter(StringBuffer buf, DataOutputStream response, InputStream rawin, BufferedReader[] in) throws IOException {
        int i = 0;
        while (i < buf.length()) {
            switch (buf.charAt(i)) {
                case '\u00ff': {
                    if (i >= buf.length() - 2) {
                        return i;
                    }
                    int oldI = i++;
                    int end = oldI + 3;
                    switch (buf.charAt(i)) {
                        case '\u00fa': {
                            byte[] data;
                            char[] subOptionData = new char[1024];
                            char subOptionCode = buf.charAt(++i);
                            int numBytes = 0;
                            char last = '\u0000';
                            while (i < buf.length() - 1 && (last = buf.charAt(++i)) != '\uffffffff' && numBytes < subOptionData.length) {
                                if (last == '\u00ff' && i < buf.length() - 1) {
                                    if ((last = buf.charAt(++i)) == '\u00ff') {
                                        subOptionData[numBytes++] = 255;
                                        continue;
                                    }
                                    if (last != '\u00f0') continue;
                                    break;
                                }
                                subOptionData[numBytes++] = last;
                            }
                            end = i + 1;
                            if (subOptionCode == '\u0018') {
                                data = new byte[]{115, 105, 112, 108, 101, 116};
                                response.writeBytes("\u00ff\u00fa\u0018\u0000");
                                response.write(data);
                                response.writeBytes("\u00ff\u00f0");
                                response.flush();
                                break;
                            }
                            if (subOptionCode != '\u001f') break;
                            data = new byte[4];
                            data[1] = 80;
                            data[3] = 25;
                            response.writeBytes("\u00ff\u00fa\u001f");
                            response.write(data);
                            response.writeBytes("\u00ff\u00f0");
                            response.flush();
                            break;
                        }
                        case '\u00fb': {
                            if (buf.charAt(++i) == '\u001f') {
                                byte[] data = new byte[4];
                                data[1] = 80;
                                data[3] = 25;
                                response.writeBytes("\u00ff\u00fa\u001f");
                                response.write(data);
                                response.writeBytes("\u00ff\u00f0");
                                break;
                            }
                            if (buf.charAt(i) == 'Z') {
                                if (this.neverSupportMSP) {
                                    if (!this.MSPsupport()) break;
                                    response.writeBytes("\u00ff\u00feZ");
                                    response.flush();
                                    this.setMSPSupport(false);
                                    break;
                                }
                                if (this.MSPsupport()) break;
                                response.writeBytes("\u00ff\u00fdZ");
                                response.flush();
                                this.setMSPSupport(true);
                                break;
                            }
                            if (buf.charAt(i) == '[') {
                                if (this.neverSupportMXP) {
                                    if (!this.MXPsupport()) break;
                                    response.writeBytes("\u00ff\u00fe[");
                                    response.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MXPsupport()) break;
                                response.writeBytes("\u00ff\u00fd[");
                                response.flush();
                                this.setMXPSupport(true);
                                break;
                            }
                            if (buf.charAt(i) == 'V') {
                                if (this.neverSupportMCCP) {
                                    if (!this.MCCPsupport()) break;
                                    response.writeBytes("\u00ff\u00feV");
                                    response.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MCCPsupport()) break;
                                response.writeBytes("\u00ff\u00fdV");
                                response.flush();
                                this.setMCCPSupport(true);
                                break;
                            }
                            if (buf.charAt(i) == '\u0000') break;
                            response.writeBytes("\u00ff\u00fe" + buf.charAt(i));
                            response.flush();
                            break;
                        }
                        case '\u00fc': {
                            if (buf.charAt(++i) == 'Z') {
                                if (!this.MSPsupport()) break;
                                response.writeBytes("\u00ff\u00feZ");
                                response.flush();
                                this.setMSPSupport(false);
                                break;
                            }
                            if (buf.charAt(i) != '[' || !this.MXPsupport()) break;
                            response.writeBytes("\u00ff\u00fe[");
                            response.flush();
                            this.setMXPSupport(false);
                            if (this.mxpModule == null) break;
                            this.mxpModule.shutdownMXP();
                            break;
                        }
                        case '\u00fd': {
                            if (buf.charAt(++i) == 'Z') {
                                if (this.neverSupportMSP) {
                                    if (!this.MSPsupport()) break;
                                    response.writeBytes("\u00ff\u00fcZ");
                                    response.flush();
                                    this.setMSPSupport(false);
                                    break;
                                }
                                if (this.MSPsupport()) break;
                                response.writeBytes("\u00ff\u00fbZ");
                                response.flush();
                                this.setMSPSupport(true);
                                break;
                            }
                            if (buf.charAt(i) == '[') {
                                if (this.neverSupportMXP) {
                                    if (!this.MXPsupport()) break;
                                    response.writeBytes("\u00ff\u00fc[");
                                    response.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MXPsupport()) break;
                                response.writeBytes("\u00ff\u00fb[");
                                response.flush();
                                this.setMXPSupport(true);
                                break;
                            }
                            if (buf.charAt(i) == '\u0000') break;
                            response.writeBytes("\u00ff\u00fc" + buf.charAt(i));
                            response.flush();
                            break;
                        }
                        case '\u00fe': {
                            if (buf.charAt(++i) == 'Z') {
                                if (!this.MSPsupport()) break;
                                response.writeBytes("\u00ff\u00fcZ");
                                response.flush();
                                this.setMSPSupport(false);
                                break;
                            }
                            if (buf.charAt(i) != '[' || !this.MXPsupport()) break;
                            response.writeBytes("\u00ff\u00fc[");
                            response.flush();
                            this.setMXPSupport(false);
                            if (this.mxpModule == null) break;
                            this.mxpModule.shutdownMXP();
                        }
                    }
                    buf.delete(oldI, end);
                    i = oldI - 1;
                }
            }
            ++i;
        }
        return buf.length();
    }

    public int HTMLFilter(StringBuffer buf) {
        int i = 0;
        boolean[] eolEater = new boolean[1];
        while (i < buf.length()) {
            if (this.comment) {
                if (buf.substring(i, i + 3).equals("-->")) {
                    this.comment = false;
                    i += 3;
                }
            } else if (this.MXPsupport() && this.mxpModule.eatTextUntilNextEOLN() && buf.charAt(i) != '\n' && buf.charAt(i) != '\r') {
                buf.deleteCharAt(i);
                --i;
            } else {
                switch (buf.charAt(i)) {
                    case '!': {
                        if (i >= buf.length() - 3 || buf.charAt(i + 1) != '!' || !this.MSPsupport()) break;
                        int endl = this.mspModule.process(buf, i, this.codeBase);
                        if (endl == -1) {
                            --i;
                            break;
                        }
                        if (endl <= 0) break;
                        return endl;
                    }
                    case '&': {
                        if (!this.MXPsupport()) {
                            buf.insert(i + 1, "amp;");
                            i += 4;
                            break;
                        }
                        int x = this.mxpModule.processEntity(buf, i, null, true);
                        if (x == Integer.MAX_VALUE) {
                            return i;
                        }
                        i += x;
                        break;
                    }
                    case ' ': {
                        buf.setCharAt(i, '&');
                        buf.insert(i + 1, "nbsp;");
                        i += 5;
                        break;
                    }
                    case '>': {
                        buf.setCharAt(i, '&');
                        buf.insert(i + 1, "gt;");
                        i += 3;
                        break;
                    }
                    case '<': {
                        if (!this.MXPsupport()) {
                            buf.setCharAt(i, '&');
                            buf.insert(i + 1, "lt;");
                            i += 3;
                            break;
                        }
                        if (i + 4 < buf.length() && buf.substring(i + 1, i + 4).equals("!--")) {
                            this.comment = true;
                            break;
                        }
                        int x = this.mxpModule.processTag(buf, i);
                        if (x == Integer.MAX_VALUE) {
                            return i;
                        }
                        i += x;
                        break;
                    }
                    case '\n': {
                        int x;
                        if (this.MXPsupport()) {
                            x = this.mxpModule.newlineDetected(buf, i + 1, eolEater);
                            if (eolEater[0]) {
                                buf.deleteCharAt(i);
                            } else {
                                buf.setCharAt(i, '<');
                                buf.insert(i + 1, "BR>");
                                i += 3;
                            }
                            i += x;
                            break;
                        }
                        buf.setCharAt(i, '<');
                        buf.insert(i + 1, "BR>");
                        i += 3;
                        break;
                    }
                    case '\r': {
                        buf.deleteCharAt(i);
                        --i;
                        break;
                    }
                    case '\u00ff': {
                        if (i < buf.length() - 3) break;
                        return i;
                    }
                    case '\u001b': {
                        int savedI = i;
                        if (i == buf.length() - 1) {
                            return i;
                        }
                        if (buf.charAt(++i) != '[') {
                            buf.setCharAt(i, ' ');
                            break;
                        }
                        boolean quote = false;
                        while (++i < buf.length() && (quote || !Character.isLetter(buf.charAt(i)))) {
                            if (buf.charAt(i) != '\"') continue;
                            boolean bl = quote = !quote;
                        }
                        if (i == buf.length()) {
                            return savedI;
                        }
                        String oldStr = buf.substring(savedI + 2, i + 1);
                        String translate = this.escapeTranslate(oldStr);
                        if (translate.equals(oldStr)) {
                            int x = this.mxpModule.escapeTranslate(oldStr, buf, savedI);
                            if (x == Integer.MAX_VALUE) {
                                return i;
                            }
                            i = savedI + x;
                            break;
                        }
                        if (translate.equals(oldStr)) break;
                        buf.replace(savedI, i + 1, translate);
                        i = savedI + translate.length() - 1;
                    }
                }
            }
            ++i;
        }
        return buf.length();
    }
}

