/*
 * Decompiled with CFR 0.152.
 */
package gebhard.uielements;

import de.jave.util.Toolbox;
import gebhard.uielements.NumberTextField;
import java.awt.TextComponent;
import java.awt.event.KeyListener;
import java.awt.event.TextListener;

public class DoubleTextField
extends NumberTextField
implements KeyListener,
TextListener {
    protected static final double DEFAULT_MAX = 10000.0;
    protected static final double DEFAULT_MIN = 0.0;
    protected static final double DEFAULT_STEP = 0.1;
    protected static final int DEFAULT_ROUND = 2;
    protected double min;
    protected double max;
    protected double dflt;
    protected double step;
    protected int round;

    public DoubleTextField() {
        this(0.0, 0.0, 10000.0, 0.1, 2);
    }

    public DoubleTextField(double d) {
        this(d, 0.0, 10000.0, 0.1, 2);
    }

    public DoubleTextField(double d, double d2, double d3) {
        this(d, d2, d3, 0.1, 2);
    }

    public DoubleTextField(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, 2);
    }

    public DoubleTextField(double d, double d2, double d3, double d4, int n) {
        super(String.valueOf(d));
        this.min = d2;
        this.max = d3;
        this.dflt = d;
        if (this.dflt < d2) {
            this.dflt = d2;
        } else if (this.dflt > d3) {
            this.dflt = d3;
        }
        this.step = d4;
        this.round = n;
    }

    public void setRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.ensureRange();
    }

    public double getValue() {
        this.ensureRange();
        double d = 0.0;
        try {
            d = Double.valueOf(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.dflt;
        }
        d = Toolbox.round(d, this.round);
        return d;
    }

    public void setValue(double d) {
        if ((d = Toolbox.round(d, this.round)) == this.getValue()) {
            return;
        }
        ((TextComponent)this).setText(String.valueOf(d));
        this.ensureRange();
    }

    public void setMinimum(double d) {
        this.min = d;
        this.ensureRange();
    }

    public void setMaximum(double d) {
        this.max = d;
        this.ensureRange();
    }

    protected void ensureRange() {
        double d = 0.0;
        try {
            d = Double.valueOf(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            ((TextComponent)this).setText(String.valueOf(this.dflt));
            return;
        }
        if (d > this.max) {
            ((TextComponent)this).setText(String.valueOf(this.max));
            return;
        }
        if (d < this.min) {
            ((TextComponent)this).setText(String.valueOf(this.min));
        }
    }

    protected void incValue() {
        double d = this.getValue() + this.step;
        if (d > this.max) {
            return;
        }
        this.setValue(d);
    }

    protected void decValue() {
        double d = this.getValue() - this.step;
        if (d < this.min) {
            return;
        }
        this.setValue(d);
    }

    protected char mapInputChar(char c) {
        if (c == ',') {
            return '.';
        }
        return c;
    }

    protected boolean isTextValid() {
        double d = 0.0;
        try {
            d = Double.valueOf(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (d > this.max) {
            return false;
        }
        return !(d < this.min);
    }

    protected boolean isValidInput(char c) {
        return c >= '0' && c <= '9' || c == '-' || c == '.' || c == ',';
    }
}

