/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Document;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class Tool
implements ItemListener,
ActionListener {
    protected Plate plate;
    protected Document document;
    protected Jave jave;
    protected Component optionsComponent;
    protected Label toolLabel;
    protected static boolean altDown = false;
    protected static boolean shiftDown = false;
    protected static boolean controlDown = false;
    protected static boolean metaDown = false;
    protected boolean debug = false;
    protected static boolean insert = false;
    protected static final double CORRECT_FACTOR = 1.98;
    protected PixelPlate markPlate;
    protected Cursor cursor;

    public void plateScrolled() {
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public Point getCursorLocation() {
        if (this.document != null) {
            return this.document.getCursorLocation();
        }
        return null;
    }

    public void cursorUp(int n) {
    }

    public void cursorDown(int n) {
    }

    public static boolean isInsert() {
        return insert;
    }

    public void setInsert(boolean bl) {
        insert = bl;
    }

    public boolean containsScreenPoint(Point point) {
        return false;
    }

    public boolean containsLocation(Point point) {
        return false;
    }

    public Tool(Plate plate, Jave jave) {
        this.plate = plate;
        this.jave = jave;
        this.toolLabel = new Label("- no options available -");
        this.toolLabel.setFont(JaveGlobalRessources.FONT_ITALIC);
    }

    public void prepareForSave() {
    }

    public boolean isActiveTool() {
        return this.plate.getCurrentTool() == this;
    }

    public static final void setMetaDown(boolean bl) {
        metaDown = bl;
    }

    protected Rectangle getAutoSelectRegion(int n, int n2) {
        boolean[][] blArray = new boolean[this.plate.getDocumentWidth()][this.plate.getDocumentHeight()];
        blArray[n][n2] = true;
        Rectangle rectangle = new Rectangle(n, n2, 0, 0);
        this.crawl(n + 1, n2, blArray, rectangle);
        this.crawl(n - 1, n2, blArray, rectangle);
        this.crawl(n, n2 + 1, blArray, rectangle);
        this.crawl(n, n2 - 1, blArray, rectangle);
        ++rectangle.width;
        ++rectangle.height;
        return rectangle;
    }

    protected void crawl(int n, int n2, boolean[][] blArray, Rectangle rectangle) {
        if (n < 0 || n2 < 0 || n >= this.plate.getDocumentWidth() || n2 >= this.plate.getDocumentHeight() || blArray[n][n2]) {
            return;
        }
        blArray[n][n2] = true;
        if (this.plate.getChar(n, n2) == ' ') {
            return;
        }
        if (n < rectangle.x) {
            --rectangle.x;
            ++rectangle.width;
        } else if (n2 < rectangle.y) {
            --rectangle.y;
            ++rectangle.height;
        } else if (n > rectangle.x + rectangle.width) {
            ++rectangle.width;
        } else if (n2 > rectangle.y + rectangle.height) {
            ++rectangle.height;
        }
        this.crawl(n + 1, n2, blArray, rectangle);
        this.crawl(n - 1, n2, blArray, rectangle);
        this.crawl(n, n2 + 1, blArray, rectangle);
        this.crawl(n, n2 - 1, blArray, rectangle);
    }

    public void shiftReleased() {
        if (!shiftDown) {
            return;
        }
        shiftDown = false;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public void shiftPressed() {
        if (shiftDown) {
            return;
        }
        shiftDown = true;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public void altReleased() {
        altDown = false;
    }

    public void altPressed() {
        altDown = true;
    }

    public void controlReleased() {
        this.debug = false;
        controlDown = false;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public void controlPressed() {
        this.debug = true;
        controlDown = true;
        if (this.markPlate != null) {
            this.repaintCursor();
        }
    }

    public static Point getQuadraticLocation(Point point, Point point2, boolean bl) {
        Point point3 = new Point(point2.x, point2.y);
        if (bl) {
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            if (Tool.abs(n) > Tool.abs((int)Math.round((double)n2 * 1.98))) {
                point3.y = point.y + Tool.abs((int)Math.round((double)n / 1.98)) * Tool.sgn(n2);
            } else {
                point3.x = point.x + Tool.abs((int)Math.round((double)n2 * 1.98)) * Tool.sgn(n);
            }
        }
        return point3;
    }

    public static Point getQuadraticPointFor(Point point, Point point2, boolean bl) {
        if (!bl) {
            return point2;
        }
        Point point3 = new Point(point2.x, point2.y);
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        if (Tool.abs(n) > Tool.abs(n2)) {
            point3.y = point.y + Tool.abs(n) * Tool.sgn(n2);
        } else {
            point3.x = point.x + Tool.abs(n2) * Tool.sgn(n);
        }
        return point3;
    }

    public void checkSize() {
    }

    public static final int sgn(int n) {
        return n < 0 ? -1 : 1;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.plate.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.plate.requestFocus();
    }

    public void beep() {
        this.plate.beep();
    }

    public void packOptionsDialog() {
        this.jave.packOptionsDialog();
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    public static final int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public static final int max(int n, int n2, int n3) {
        return Tool.max(n, Tool.max(n2, n3));
    }

    public static final int max(int n, int n2, int n3, int n4) {
        return Tool.max(Tool.max(n, n2), Tool.max(n3, n4));
    }

    public abstract String getIconName();

    public abstract String getName();

    protected void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.plate.setCursor(this.cursor);
    }

    public final Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return JaveGlobalRessources.cursorSelection;
    }

    public void showCoordinates(Point point) {
        this.plate.showCoordinates(point);
    }

    public void mouseEntered(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mouseExited(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mouseClicked(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void setMixMode(boolean bl) {
        this.plate.setMix(bl);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
    }

    public void keyTyped(char c, KeyEvent keyEvent) {
    }

    public void paintCursorFeature(Graphics graphics) {
    }

    public void repaintCursor() {
        this.plate.repaintCursor();
    }

    public void repaintAll() {
        this.plate.repaint();
    }

    public void saveCurrentState(String string) {
        this.plate.saveCurrentState(string);
    }

    public char getMouseChar() {
        return this.plate.getMouseChar();
    }

    public boolean isMouseRightButton() {
        return this.plate.isMouseRightButton();
    }

    public abstract void putAside(boolean var1);

    public abstract void takeToHand();

    public void reset() {
        this.putAside(false);
        this.takeToHand();
    }

    public Component createOptionsComponent() {
        return this.toolLabel;
    }

    public Component getOptionsComponent() {
        if (this.optionsComponent == null) {
            this.optionsComponent = this.createOptionsComponent();
        }
        return this.optionsComponent;
    }

    protected void showStatus(String string) {
        this.plate.showStatus(string);
    }

    protected Point getScreenPointFor(Point point) {
        return this.plate.getScreenPointFor(point);
    }

    protected Point getScreenPointFor(int n, int n2) {
        return this.plate.getScreenPointFor(n, n2);
    }

    protected Point getLocationForScreenPoint(Point point) {
        return this.plate.getLocationForScreenPoint(point);
    }

    public static Rectangle getRectangleFor(Point point, Point point2) {
        return new Rectangle(point.x < point2.x ? point.x : point2.x, point.y < point2.y ? point.y : point2.y, 1 + (point.x < point2.x ? point2.x - point.x : point.x - point2.x), 1 + (point.y < point2.y ? point2.y - point.y : point.y - point2.y));
    }
}

