/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.FillAlgorithm;
import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import de.jave.jave.Tool;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class RectangleToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;
    protected Checkbox cbFill;

    public RectangleToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Rectangle Generic";
    }

    public String getIconName() {
        return "rectangle_generic";
    }

    public Component getAdditionalOptionsComponent() {
        if (this.cbFill != null) {
            return this.cbFill;
        }
        this.cbFill = new Checkbox("Fill", false);
        return this.cbFill;
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null || this.markPlate == null) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null) {
            return;
        }
        this.point1 = null;
        this.point2 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.getMixMode());
            this.markPlate.pasteResultInto(this.plate.getContent());
            this.saveCurrentState("rectangle");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.markPlate == null) {
            return;
        }
        if (n == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.point1 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        graphics.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        Point point = Tool.getQuadraticPointFor(this.point1, this.point2, Tool.shiftDown);
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(point);
        this.markPlate.clear();
        boolean bl = this.cbFill.getState();
        if (bl && !this.isLineMode()) {
            this.markPlate.fillRectangle(point2d, point2d2);
        } else {
            this.markPlate.drawRectangle(point2d, point2d2);
        }
        this.markPlate.convert();
        if (bl && this.isLineMode() && Math.abs(point2d2.x - point2d.x) >= 1.0 && Math.abs(point2d2.y - point2d.y) >= 1.0) {
            FillAlgorithm.fillSolid(this.markPlate.plate, (int)((point2d.x + point2d2.x) / 2.0) - this.markPlate.getOriginX(), (int)((point2d.y + point2d2.y) / 2.0) - this.markPlate.getOriginY(), '\u00a0', 0);
        }
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.point1 = null;
        this.point2 = null;
    }

    public void putAside(boolean bl) {
        this.point1 = null;
        this.point2 = null;
    }
}

