/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterDrawable;
import de.jave.jave.PixelPlate;
import de.jave.jave.Point2d;
import java.awt.Point;

public class LineAlgorithm {
    protected static final int DOWN = 0;
    protected static final int UP = 1;
    protected static final int HORIZONTAL = 0;
    protected static final int VERTICAL = 1;
    public static final String[] STR_STYLE = new String[]{"Veronica (-|/\\.,'_)", "Normal (-|/\\.,\"_)", "Glory (:;'~-)", "Segerman JFL", "CeeJay (normal)", "CeeJay (alternative)", "bug", "Characters"};
    public static final int STYLE_VERONICA = 0;
    public static final int STYLE_NORMAL = 1;
    public static final int STYLE_GLORY = 2;
    public static final int STYLE_SEGERMAN = 3;
    public static final int STYLE_CEEJAY1 = 4;
    public static final int STYLE_CEEJAY2 = 5;
    public static final int STYLE_BUG = 6;
    public static final int STYLE_CHARACTERS = 7;
    protected static final char N_DOT = '+';
    protected static final char N_VERTICAL = '|';
    protected static final char N_HORIZONTAL = '-';
    protected static final String[] N_HORIZONTAL_UP = new String[]{"/", ".'", ".-'", "_.-'", "_.--'", "__.--'", "__..--'", "__..--''"};
    protected static final String[] N_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "`-._", "`--._", "`--.__", "`--..__", "``--..__"};
    protected static final String[] N_VERTICAL_UP = new String[]{"/", "/|", "/||", "/|||", "/||||", "/|||||", "/||||||", "/|||||||"};
    protected static final String[] N_VERTICAL_DOWN = new String[]{"\\", "\\|", "\\||", "\\|||", "\\||||", "\\|||||", "\\||||||", "\\|||||||"};
    protected static final String N_HORIZONTAL_LEVELS_UP = "_.-'";
    protected static final String N_HORIZONTAL_LEVELS_DOWN = "`-._";
    protected static final String N_HORIZONTAL_LEVELS = "_.-'";
    protected static final char M_DOT = '+';
    protected static final char M_VERTICAL = '|';
    protected static final char M_HORIZONTAL = '-';
    protected static final String[] M_HORIZONTAL_UP = new String[]{"/", ",'", ",-\"", "_,-\"", "_,--\"", "__,--\"", "__,,--\"", "__,,,--\"\""};
    protected static final String[] M_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "`-._", "\"--._", "\"--.__", "\"--..__", "\"\"--..__"};
    protected static final String[] M_VERTICAL_UP = new String[]{"/", "/|", "/||", "/|||", "/||||", "/|||||", "/||||||", "/|||||||"};
    protected static final String[] M_VERTICAL_DOWN = new String[]{"\\", "\\|", "\\||", "\\|||", "\\||||", "\\|||||", "\\||||||", "\\|||||||"};
    protected static final String M_HORIZONTAL_LEVELS_UP = "_,-\"";
    protected static final String M_HORIZONTAL_LEVELS_DOWN = "\"-._";
    protected static final String M_HORIZONTAL_LEVELS = "_.-\"";
    protected static final char G_DOT = '+';
    protected static final char G_VERTICAL = ':';
    protected static final char G_HORIZONTAL = '-';
    protected static final String[] G_HORIZONTAL_UP = new String[]{";", ",'", ",-'", ",-~'", ",--~'", ",,--~'"};
    protected static final String[] G_HORIZONTAL_DOWN = new String[]{":", "'.", "'-.", "'~-.", "'~--.", "'~--.."};
    protected static final String[] G_VERTICAL_UP = new String[]{";", ";:", ";::", ";:::", ";::::", ";:::::"};
    protected static final String[] G_VERTICAL_DOWN = new String[]{":", "::", ":::", "::::", ":::::", "::::::"};
    protected static final String G_HORIZONTAL_LEVELS_UP = ",-~'";
    protected static final String G_HORIZONTAL_LEVELS_DOWN = "'~-.";
    protected static final String G_HORIZONTAL_LEVELS = ".-~'";
    protected static final char S_DOT = '+';
    protected static final char S_VERTICAL = '|';
    protected static final char S_HORIZONTAL = '-';
    protected static final String[] S_HORIZONTAL_UP = new String[]{"/", ".'", ".-'", "_.-'", "_.--'", "__.--'", "__..--'", "__..--''"};
    protected static final String[] S_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "`-._", "`--._", "`--.__", "`--..__", "\"\"--..__"};
    protected static final String[] S_VERTICAL_UP = new String[]{"/", "FJ", "F|J", "F||J", "FF|JJ", "FF||JJ"};
    protected static final String[] S_VERTICAL_DOWN = new String[]{"\\", "JL", "J|L", "J||L", "JJ|LL", "JJ||LL"};
    protected static final String S_HORIZONTAL_LEVELS_UP = "_.-\"";
    protected static final String S_HORIZONTAL_LEVELS_DOWN = "\"-._";
    protected static final String S_HORIZONTAL_LEVELS = "_.-\"";
    protected static final char C1_DOT = '+';
    protected static final char C1_VERTICAL = '|';
    protected static final char C1_HORIZONTAL = '-';
    protected static final String[] C1_HORIZONTAL_UP = new String[]{"/", ",\"", ",-\"", "_.-\"", "_.--\"", "__.--\"", "__..--\"", "__..--'\""};
    protected static final String[] C1_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "`-._", "`--._", "`--.__", "`--..__", "``--..__"};
    protected static final String[] C1_VERTICAL_UP = new String[]{"',", "'|,", "'||,", "'|||,", "'||||,", "'|||||,", "'||||||,", "'|||||||,"};
    protected static final String[] C1_VERTICAL_DOWN = new String[]{"`.", "`|.", "`||.", "`|||.", "`||||.", "`|||||.", "`||||||.", "`|||||||."};
    protected static final String C1_HORIZONTAL_LEVELS_UP = "__..--'\"";
    protected static final String C1_HORIZONTAL_LEVELS_DOWN = "`-._";
    protected static final String C1_HORIZONTAL_LEVELS = "_.-'";
    protected static final char C2_DOT = '+';
    protected static final char C2_VERTICAL = '|';
    protected static final char C2_HORIZONTAL = '-';
    protected static final String[] C2_HORIZONTAL_UP = new String[]{"/", ",'", ".-'", "_,-\"", ",--'\"", ".--'\"\"", ".--''\"\"", "..--''\"\""};
    protected static final String[] C2_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "`-._", "``--.", "\"\"`--.", "\"\"``--.", "\"\"``--.."};
    protected static final String[] C2_VERTICAL_UP = new String[]{"'.", "'|.", "'||.", "'|||.", "'||||.", "'|||||.", "'||||||.", "'|||||||."};
    protected static final String[] C2_VERTICAL_DOWN = new String[]{"`.", "`|.", "`||.", "`|||.", "`||||.", "`|||||.", "`||||||.", "`|||||||."};
    protected static final String C2_HORIZONTAL_LEVELS_UP = ".-'\"";
    protected static final String C2_HORIZONTAL_LEVELS_DOWN = "\"`-.";
    protected static final String C2_HORIZONTAL_LEVELS = ".-'";
    protected static final char B_DOT = '+';
    protected static final char B_VERTICAL = ':';
    protected static final char B_HORIZONTAL = '-';
    protected static final String[] B_HORIZONTAL_UP = new String[]{"/", ".'", ".-'", ".-*\"", "_.-*'", "_.-*\"'", "_.-=*\"'", "_.--=*\"'"};
    protected static final String[] B_HORIZONTAL_DOWN = new String[]{"\\", "`.", "`-.", "\"*-.", "`*-._", "`\"*-._", "`\"*=-._", "`\"*=--._"};
    protected static final String[] B_VERTICAL_UP = new String[]{"/", ";:", ";|:", ";||:", ";|||:", ";||||:", ";|||||:", ";||||||:"};
    protected static final String[] B_VERTICAL_DOWN = new String[]{"\\", ":;", ":|;", ":||;", ":|||;", ":||||;", ":|||||;", ":||||||;"};
    protected static final String B_HORIZONTAL_LEVELS_UP = "_.-=*\"'";
    protected static final String B_HORIZONTAL_LEVELS_DOWN = "`\"*=-._";
    protected static final String B_HORIZONTAL_LEVELS = "_.-'";

    protected static final String stretch(String string, int n) {
        int n2;
        int n3 = string.length();
        int n4 = n2 = n - n3;
        while (n4 > 0) {
            int n5 = n4 * n3 / (n2 + 1);
            string = string.substring(0, n5 + 1) + string.substring(n5);
            --n4;
        }
        return string;
    }

    public static void drawLine(PixelPlate pixelPlate, double d, double d2, double d3, double d4, int n) {
        LineAlgorithm.drawLine(pixelPlate, d, d2, d3, d4, n, false);
    }

    public static void drawLine(PixelPlate pixelPlate, Point2d point2d, Point2d point2d2, int n, boolean bl) {
        LineAlgorithm.drawLine(pixelPlate, point2d.x, point2d.y, point2d2.x, point2d2.y, n, bl);
    }

    public static void drawLine(PixelPlate pixelPlate, double d, double d2, double d3, double d4, int n, boolean bl) {
        int n2;
        double d5;
        int n3;
        int n4;
        int n5;
        int n6;
        char c = '+';
        char c2 = '|';
        char c3 = '-';
        String[] stringArray = N_HORIZONTAL_UP;
        String[] stringArray2 = N_HORIZONTAL_DOWN;
        String[] stringArray3 = N_VERTICAL_UP;
        String[] stringArray4 = N_VERTICAL_DOWN;
        String string = "_.-'";
        String string2 = "`-._";
        String string3 = "_.-'";
        if (n == 1) {
            c = '+';
            c2 = '|';
            c3 = '-';
            stringArray = M_HORIZONTAL_UP;
            stringArray2 = M_HORIZONTAL_DOWN;
            stringArray3 = M_VERTICAL_UP;
            stringArray4 = M_VERTICAL_DOWN;
            string = M_HORIZONTAL_LEVELS_UP;
            string2 = "\"-._";
            string3 = "_.-\"";
        } else if (n == 2) {
            c = '+';
            c2 = ':';
            c3 = '-';
            stringArray = G_HORIZONTAL_UP;
            stringArray2 = G_HORIZONTAL_DOWN;
            stringArray3 = G_VERTICAL_UP;
            stringArray4 = G_VERTICAL_DOWN;
            string = G_HORIZONTAL_LEVELS_UP;
            string2 = G_HORIZONTAL_LEVELS_DOWN;
            string3 = G_HORIZONTAL_LEVELS;
        } else if (n == 3) {
            c = '+';
            c2 = '|';
            c3 = '-';
            stringArray = S_HORIZONTAL_UP;
            stringArray2 = S_HORIZONTAL_DOWN;
            stringArray3 = S_VERTICAL_UP;
            stringArray4 = S_VERTICAL_DOWN;
            string = "_.-\"";
            string2 = "\"-._";
            string3 = "_.-\"";
        } else if (n == 4) {
            c = '+';
            c2 = '|';
            c3 = '-';
            stringArray = C1_HORIZONTAL_UP;
            stringArray2 = C1_HORIZONTAL_DOWN;
            stringArray3 = C1_VERTICAL_UP;
            stringArray4 = C1_VERTICAL_DOWN;
            string = C1_HORIZONTAL_LEVELS_UP;
            string2 = "`-._";
            string3 = "_.-'";
        } else if (n == 5) {
            c = '+';
            c2 = '|';
            c3 = '-';
            stringArray = C2_HORIZONTAL_UP;
            stringArray2 = C2_HORIZONTAL_DOWN;
            stringArray3 = C2_VERTICAL_UP;
            stringArray4 = C2_VERTICAL_DOWN;
            string = C2_HORIZONTAL_LEVELS_UP;
            string2 = C2_HORIZONTAL_LEVELS_DOWN;
            string3 = C2_HORIZONTAL_LEVELS;
        } else if (n == 6) {
            c = '+';
            c2 = ':';
            c3 = '-';
            stringArray = B_HORIZONTAL_UP;
            stringArray2 = B_HORIZONTAL_DOWN;
            stringArray3 = B_VERTICAL_UP;
            stringArray4 = B_VERTICAL_DOWN;
            string = B_HORIZONTAL_LEVELS_UP;
            string2 = B_HORIZONTAL_LEVELS_DOWN;
            string3 = "_.-'";
        }
        if (d > d3) {
            n6 = (int)Math.round(d3);
            n5 = (int)Math.round(d4);
            n4 = (int)Math.round(d);
            n3 = (int)Math.round(d2);
            d5 = d;
            d = d3;
            d3 = d5;
            d5 = d2;
            d2 = d4;
            d4 = d5;
        } else {
            n4 = (int)Math.round(d3);
            n3 = (int)Math.round(d4);
            n6 = (int)Math.round(d);
            n5 = (int)Math.round(d2);
        }
        int n7 = n4 - n6;
        int n8 = n3 - n5;
        if (n7 == 0 && n8 == 0) {
            LineAlgorithm.drawLineDot(pixelPlate, n6, n5, c);
            return;
        }
        if (n7 == 0) {
            if (n8 >= 0) {
                LineAlgorithm.drawLineVertical(pixelPlate, n6, n5, n5 + n8, c2);
            } else {
                LineAlgorithm.drawLineVertical(pixelPlate, n6, n5 + n8, n5, c2);
            }
            return;
        }
        if (d4 == d2) {
            if (bl) {
                LineAlgorithm.drawLineHorizontal(pixelPlate, n6, n6 + n7, n5, c3);
                return;
            }
            d5 = 1.0 - (d2 - (double)n3 + 0.5);
            int n9 = (int)((double)string3.length() * d5);
            if (n9 > string3.length() - 1) {
                n9 = string3.length() - 1;
            }
            LineAlgorithm.drawLineHorizontal(pixelPlate, n6, n6 + n7, n5, string3.charAt(n9));
            return;
        }
        int n10 = n7 >= 0 ? n7 : -n7;
        int n11 = n2 = n8 >= 0 ? n8 : -n8;
        if (bl && n2 == 0) {
            LineAlgorithm.drawLineHorizontal(pixelPlate, n6, n6 + n7, n5, c3);
            return;
        }
        boolean bl2 = false;
        if (d4 - d2 < 0.0) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (n10 < n2) {
            bl3 = true;
        }
        if (!bl3 && !bl2) {
            if ((n10 + 1) / (n2 + 1) >= 4 || n2 == 0) {
                double d6 = (d4 - d2) / (d3 - d);
                double d7 = (d2 * d3 - d4 * d) / (d3 - d);
                int n12 = 0;
                while (n12 <= n7) {
                    double d8 = d6 * (double)(n12 + n6) + d7;
                    int n13 = (int)Math.round(d8);
                    double d9 = d8 - (double)n13 + 0.5;
                    int n14 = (int)((double)string2.length() * d9);
                    if (n14 > string2.length() - 1) {
                        n14 = string2.length() - 1;
                    }
                    pixelPlate.set(n12 + n6, n13, string2.charAt(n14));
                    ++n12;
                }
                return;
            }
            int n15 = n4;
            double d10 = (double)(n8 + 1) / (double)(n7 + 1);
            double d11 = (0.5 - (double)n6) * d10 - (0.5 - (double)n5);
            int[] nArray = new int[n7 + 1];
            int n16 = 0;
            while (n16 <= n7) {
                nArray[n16] = (int)Math.round(d10 * (double)(n16 + n6) + d11);
                ++n16;
            }
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            n18 = 0;
            while (n18 <= n7) {
                n17 = 0;
                n19 = nArray[n18];
                while (n18 <= n7) {
                    if (nArray[n18] == n19) {
                        ++n17;
                        ++n18;
                        continue;
                    }
                    LineAlgorithm.drawLineHorizontalDown(pixelPlate, n6 + n18 - n17, n6 + n18 - 1, n19, n15, stringArray2);
                    n17 = 0;
                    n19 = nArray[n18];
                }
                ++n18;
            }
            LineAlgorithm.drawLineHorizontalDown(pixelPlate, n6 + n7 - n17 + 1, n6 + n18 - 2, n19, n15, stringArray2);
            return;
        }
        if (!bl3 && bl2) {
            if ((n10 + 1) / (n2 + 1) >= 4 || n2 == 0) {
                double d12 = (d4 - d2) / (d3 - d);
                double d13 = (d2 * d3 - d4 * d) / (d3 - d);
                int n20 = 0;
                while (n20 <= n7) {
                    double d14 = d12 * (double)(n20 + n6) + d13;
                    int n21 = (int)Math.round(d14);
                    double d15 = d14 - (double)n21 + 0.5;
                    int n22 = (int)((double)string.length() * (1.0 - d15));
                    if (n22 > string.length() - 1) {
                        n22 = string.length() - 1;
                    }
                    pixelPlate.set(n20 + n6, n21, string.charAt(n22));
                    ++n20;
                }
                return;
            }
            int n23 = n4;
            double d16 = (double)(n8 - 1) / (double)(n7 + 1);
            double d17 = (0.5 - (double)n6) * d16 + (0.5 + (double)n5);
            int[] nArray = new int[n7 + 1];
            int n24 = 0;
            while (n24 <= n7) {
                nArray[n24] = (int)Math.round(d16 * (double)(n24 + n6) + d17);
                ++n24;
            }
            int n25 = 0;
            int n26 = 0;
            int n27 = 0;
            n26 = 0;
            while (n26 <= n7) {
                n25 = 0;
                n27 = nArray[n26];
                while (n26 <= n7) {
                    if (nArray[n26] == n27) {
                        ++n25;
                        ++n26;
                        continue;
                    }
                    LineAlgorithm.drawLineHorizontalUp(pixelPlate, n6 + n26 - n25, n6 + n26 - 1, n27, n23, stringArray);
                    n25 = 0;
                    n27 = nArray[n26];
                }
                ++n26;
            }
            LineAlgorithm.drawLineHorizontalUp(pixelPlate, n6 + n7 - n25 + 1, n6 + n26 - 2, n27, n23, stringArray);
            return;
        }
        if (bl3 && !bl2) {
            double d18 = (double)(n7 + 1) / (double)(n8 + 1);
            double d19 = (0.5 - (double)n5) * d18 + ((double)n6 - 0.5);
            int[] nArray = new int[n8 + 1];
            int n28 = 0;
            while (n28 <= n8) {
                nArray[n28] = (int)Math.round(d18 * (double)(n28 + n5) + d19);
                ++n28;
            }
            int n29 = 0;
            int n30 = 0;
            int n31 = 0;
            int n32 = n5;
            n30 = 0;
            while (n30 <= n8) {
                n29 = 0;
                n31 = nArray[n30];
                while (n30 <= n8) {
                    if (nArray[n30] == n31) {
                        ++n29;
                        ++n30;
                        continue;
                    }
                    LineAlgorithm.drawLineVerticalDown(pixelPlate, n31, n5 + n30 - n29, n5 + n30 - 1, n32, stringArray4);
                    n29 = 0;
                    n31 = nArray[n30];
                }
                ++n30;
            }
            LineAlgorithm.drawLineVerticalDown(pixelPlate, n31, n5 + n8 - n29 + 1, n5 + n30 - 2, n32, stringArray4);
            return;
        }
        if (bl3 && bl2) {
            double d20 = (double)(n7 + 1) / (double)(n8 - 1);
            double d21 = -(0.5 + (double)n5) * d20 + ((double)n6 - 0.5);
            int[] nArray = new int[n2 + 1];
            int n33 = n5 + n8;
            int n34 = 0;
            while (n34 <= n2) {
                nArray[n34] = (int)Math.round(d20 * (double)(n3 + n34) + d21);
                ++n34;
            }
            int n35 = 0;
            int n36 = 0;
            int n37 = 0;
            n36 = 0;
            while (n36 <= n2) {
                n35 = 0;
                n37 = nArray[n36];
                while (n36 <= n2) {
                    if (nArray[n36] == n37) {
                        ++n35;
                        ++n36;
                        continue;
                    }
                    LineAlgorithm.drawLineVerticalUp(pixelPlate, n37, n3 + n36 - n35, n3 + n36 - 1, n33, stringArray3);
                    n35 = 0;
                    n37 = nArray[n36];
                }
                ++n36;
            }
            LineAlgorithm.drawLineVerticalUp(pixelPlate, n37, n3 - n8 - n35 + 1, n3 + n36 - 2, n33, stringArray3);
            return;
        }
    }

    protected static void drawLineHorizontal(PixelPlate pixelPlate, int n, int n2, int n3, char c) {
        int n4 = n;
        while (n4 <= n2) {
            pixelPlate.set(n4, n3, c);
            ++n4;
        }
    }

    protected static void drawLineHorizontalUp(PixelPlate pixelPlate, int n, int n2, int n3, int n4, String[] stringArray) {
        int n5 = n2 - n;
        int n6 = stringArray.length;
        String string = "";
        if (n5 >= n6) {
            string = stringArray[n6 - 1];
            string = LineAlgorithm.stretch(string, n5 + 1);
        } else {
            string = stringArray[n5];
        }
        int n7 = 0;
        while (n7 < string.length() && n + n7 <= n4) {
            pixelPlate.set(n + n7, n3, string.charAt(n7));
            ++n7;
        }
    }

    protected static void drawLineHorizontalDown(PixelPlate pixelPlate, int n, int n2, int n3, int n4, String[] stringArray) {
        int n5 = n2 - n;
        int n6 = stringArray.length;
        String string = "";
        if (n5 >= n6) {
            string = stringArray[n6 - 1];
            string = LineAlgorithm.stretch(string, n5 + 1);
        } else {
            string = stringArray[n5];
        }
        int n7 = 0;
        while (n7 < string.length() && n + n7 <= n4) {
            pixelPlate.set(n + n7, n3, string.charAt(n7));
            ++n7;
        }
    }

    protected static void drawLineVerticalUp(PixelPlate pixelPlate, int n, int n2, int n3, int n4, String[] stringArray) {
        int n5 = n3 - n2;
        int n6 = stringArray.length;
        String string = "";
        if (n5 >= n6) {
            string = stringArray[n6 - 1];
            string = LineAlgorithm.stretch(string, n5 + 1);
        } else {
            string = stringArray[n5];
        }
        int n7 = 0;
        while (n7 < string.length() && n2 + n5 - n7 >= n4) {
            pixelPlate.set(n, n2 + n5 - n7, string.charAt(n7));
            ++n7;
        }
    }

    protected static void drawLineVerticalDown(PixelPlate pixelPlate, int n, int n2, int n3, int n4, String[] stringArray) {
        int n5 = n3 - n2;
        int n6 = stringArray.length;
        String string = "";
        if (n5 >= n6) {
            string = stringArray[n6 - 1];
            string = LineAlgorithm.stretch(string, n5 + 1);
        } else {
            string = stringArray[n5];
        }
        int n7 = 0;
        while (n7 < string.length() && n2 + n5 - n7 >= n4) {
            pixelPlate.set(n, n2 + n5 - n7, string.charAt(n7));
            ++n7;
        }
    }

    protected static void drawLineVertical(PixelPlate pixelPlate, int n, int n2, int n3, char c) {
        int n4 = n2;
        while (n4 <= n3) {
            pixelPlate.set(n, n4, c);
            ++n4;
        }
    }

    protected static void drawLineDot(PixelPlate pixelPlate, int n, int n2, char c) {
        pixelPlate.set(n, n2, c);
    }

    protected static void drawLineUp(PixelPlate pixelPlate, int n, int n2, char c) {
        pixelPlate.set(n, n2, c);
    }

    protected static void drawLineDown(PixelPlate pixelPlate, int n, int n2, char c) {
        pixelPlate.set(n, n2, c);
    }

    public static void drawLineBresenham(CharacterDrawable characterDrawable, Point point, Point point2, char c) {
        LineAlgorithm.drawLineBresenham(characterDrawable, point.x, point.y, point2.x, point2.y, c);
    }

    public static void drawLineBresenham(CharacterDrawable characterDrawable, int n, int n2, int n3, int n4, char c) {
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = n3 - n;
        int n9 = n4 - n2;
        int n10 = 1;
        int n11 = 1;
        if (n8 < 0) {
            n10 = -1;
            n8 = -n8;
        }
        if (n9 < 0) {
            n11 = -1;
            n9 = -n9;
        }
        if (n9 <= n8) {
            int n12 = 2 * n8;
            int n13 = 2 * n9;
            while (true) {
                characterDrawable.set(n5, n6, c);
                if (n5 != n3) {
                    n5 += n10;
                    if ((n7 += n13) <= n8) continue;
                    n6 += n11;
                    n7 -= n12;
                    continue;
                }
                break;
            }
        } else {
            int n14 = 2 * n9;
            int n15 = 2 * n8;
            while (true) {
                characterDrawable.set(n5, n6, c);
                if (n6 == n4) break;
                n6 += n11;
                if ((n7 += n15) <= n9) continue;
                n5 += n10;
                n7 -= n14;
            }
        }
    }
}

