/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.Point2d;
import java.awt.Point;
import java.util.Vector;

public class BezierAlgorithm {
    protected static final double STD_EPSILON = 2.5;
    protected static final int MAX_DEPTH = 7;

    public static Point[] getPolyLineForBezier(Point[] pointArray) {
        return BezierAlgorithm.getPolyLineForBezier(pointArray, 1.0);
    }

    public static Point[] getPolyLineForBezier(Point[] pointArray, double d) {
        Point2d[] point2dArray = new Point2d[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            point2dArray[n] = new Point2d(pointArray[n]);
            ++n;
        }
        Vector<Point2d> vector = new Vector<Point2d>(64);
        vector.addElement(point2dArray[0]);
        BezierAlgorithm.internalBezier(vector, point2dArray, 7, 2.5 * d);
        Point[] pointArray2 = new Point[vector.size()];
        int n2 = 0;
        while (n2 < pointArray2.length) {
            Point2d point2d = (Point2d)vector.elementAt(n2);
            pointArray2[n2] = new Point((int)Math.round(point2d.x), (int)Math.round(point2d.y));
            ++n2;
        }
        return pointArray2;
    }

    public static Point2d[] getPolyLineForBezier(Point2d[] point2dArray) {
        return BezierAlgorithm.getPolyLineForBezier(point2dArray, 1.0);
    }

    public static Point2d[] getPolyLineForBezier(Point2d[] point2dArray, double d) {
        Vector<Point2d> vector = new Vector<Point2d>(64);
        vector.addElement(point2dArray[0]);
        BezierAlgorithm.internalBezier(vector, point2dArray, 7, 2.5 * d);
        Point2d[] point2dArray2 = new Point2d[vector.size()];
        int n = 0;
        while (n < point2dArray2.length) {
            point2dArray2[n] = (Point2d)vector.elementAt(n);
            ++n;
        }
        return point2dArray2;
    }

    protected static void internalBezier(Vector vector, Point2d[] point2dArray, int n, double d) {
        if (n == 0) {
            vector.addElement(point2dArray[point2dArray.length - 1]);
            return;
        }
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < point2dArray.length - 2) {
            double d3 = point2dArray[n2 + 2].x - 2.0 * point2dArray[n2 + 1].x + point2dArray[n2].x;
            double d4 = point2dArray[n2 + 2].y - 2.0 * point2dArray[n2 + 1].y + point2dArray[n2].y;
            d3 = d3 >= 0.0 ? d3 : -d3;
            double d5 = d4 = d4 >= 0.0 ? d4 : -d4;
            if (d3 > d2) {
                d2 = d3;
            }
            if (d4 > d2) {
                d2 = d4;
            }
            ++n2;
        }
        if (d2 < d) {
            vector.addElement(point2dArray[point2dArray.length - 1]);
            return;
        }
        Point2d[] point2dArray2 = new Point2d[point2dArray.length];
        Point2d[] point2dArray3 = new Point2d[point2dArray.length];
        if (point2dArray.length == 3) {
            point2dArray2[0] = point2dArray[0];
            point2dArray2[1] = new Point2d((point2dArray[0].x + point2dArray[1].x) / 2.0, (point2dArray[0].y + point2dArray[1].y) / 2.0);
            point2dArray3[1] = new Point2d((point2dArray[1].x + point2dArray[2].x) / 2.0, (point2dArray[1].y + point2dArray[2].y) / 2.0);
            point2dArray2[2] = new Point2d((point2dArray3[1].x + point2dArray2[1].x) / 2.0, (point2dArray3[1].y + point2dArray2[1].y) / 2.0);
            point2dArray3[0] = point2dArray2[2];
            point2dArray3[2] = point2dArray[2];
            BezierAlgorithm.internalBezier(vector, point2dArray2, n - 1, d);
            BezierAlgorithm.internalBezier(vector, point2dArray3, n - 1, d);
            return;
        }
        System.err.println("drawBezier fuer diesen Kurvengrad noch nicht implementiert!");
    }
}

