/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2AsciiAlgorithm1;
import de.jave.image2ascii.Image2AsciiAlgorithm4;
import de.jave.image2ascii.Image2AsciiAlgorithm9c;
import de.jave.image2ascii.Image2AsciiAlgorithmBraille;
import de.jave.image2ascii.Image2AsciiAlgorithmEdge;
import de.jave.image2ascii.Image2AsciiAlgorithmEdgeDetect;
import de.jave.image2ascii.Image2AsciiAlgorithmFeltpen;
import de.jave.image2ascii.Image2AsciiAlgorithmGradient;
import de.jave.image2ascii.Image2AsciiAlgorithmJavE;
import de.jave.image2ascii.Image2AsciiAlgorithmPixelPlate;

public class Image2AsciiAlgorithmFactory {
    protected static Image2AsciiAlgorithm[] algorithms;

    private Image2AsciiAlgorithmFactory() {
    }

    public static final Image2AsciiAlgorithm[] createAlgorithms() {
        algorithms = new Image2AsciiAlgorithm[10];
        int n = 0;
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmJavE();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithm4();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithm1();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmGradient();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmEdge();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmEdgeDetect();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmPixelPlate();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmBraille();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithmFeltpen();
        Image2AsciiAlgorithmFactory.algorithms[n++] = new Image2AsciiAlgorithm9c();
        return algorithms;
    }

    public static final Image2AsciiAlgorithm getAlgorithm(String string) {
        if (algorithms == null) {
            Image2AsciiAlgorithmFactory.createAlgorithms();
        }
        string = string.toLowerCase();
        int n = 0;
        while (n < algorithms.length) {
            if (algorithms[n].getAlgorithmName().toLowerCase().equals(string)) {
                return algorithms[n];
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < algorithms.length) {
            if (algorithms[n2].getAlgorithmName().toLowerCase().startsWith(string)) {
                return algorithms[n2];
            }
            ++n2;
        }
        return null;
    }
}

