/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GuiTools;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class WizardSideLabel
extends Canvas {
    protected String[] labels;
    protected int step;
    protected static final Font FONT = new Font("Dialog", 0, 15);
    protected static final int MAX_CELL_HEIGHT = 28;

    public WizardSideLabel(String[] stringArray) {
        this.labels = stringArray;
        this.step = 0;
    }

    public void setStep(int n) {
        this.step = n;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(FONT);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.labels.length) {
            n = fontMetrics.stringWidth(this.labels[n3]);
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        n = fontMetrics.getHeight() * this.labels.length;
        return new Dimension(n2 += 34, n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        GuiTools.drawSmall3dRectangleDown(graphics, dimension);
        graphics.setColor(this.getForeground());
        graphics.setFont(FONT);
        int n = dimension.height / this.labels.length;
        int n2 = 0;
        if (n > 28) {
            n2 = (dimension.height - 28 * this.labels.length) / 2;
            n = 28;
        }
        int n3 = 0;
        while (n3 < this.labels.length) {
            graphics.drawString(this.labels[n3], 17, n2 + n * n3 + n - 6);
            ++n3;
        }
        int n4 = n2 + (this.step + 1) * n - 3;
        graphics.drawLine(3, n4, dimension.width - 3, n4);
        graphics.fillRect(3, n4 - 3, 8, 3);
    }
}

