/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GScrollable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class GScrollPanel
extends GBorderedPanel
implements AdjustmentListener {
    protected Canvas content;
    protected Scrollbar vScrollbar;
    protected Scrollbar hScrollbar;
    protected boolean vScrollbarVisible;
    protected boolean hScrollbarVisible;
    protected int horizontalIncrement;
    protected int verticalIncrement;
    protected int verticalBlockIncrement;

    public GScrollPanel(Canvas canvas) {
        super(0);
        this.content = canvas;
        this.horizontalIncrement = 1;
        this.verticalIncrement = 1;
        this.verticalBlockIncrement = 10;
        this.setLayout(new BorderLayout());
        this.add((Component)canvas, "Center");
        this.hScrollbar = new Scrollbar(0);
        this.vScrollbar = new Scrollbar(1);
        this.hScrollbar.addAdjustmentListener(this);
        this.vScrollbar.addAdjustmentListener(this);
        this.vScrollbarVisible = false;
        this.hScrollbarVisible = false;
    }

    public void setHorizontalIncrement(int n) {
        this.horizontalIncrement = n;
    }

    public void setVerticalIncrement(int n) {
        this.verticalIncrement = n;
    }

    public void setVerticalBlockIncrement(int n) {
        this.verticalBlockIncrement = n;
        this.vScrollbar.setBlockIncrement(n);
    }

    protected void adjustScrollbars() {
        Dimension dimension = this.content.getPreferredSize();
        Dimension dimension2 = this.content.getSize();
        if (this.hScrollbarVisible) {
            dimension2.height += this.hScrollbar.getSize().height;
        }
        if (this.vScrollbarVisible) {
            dimension2.width += this.vScrollbar.getSize().width;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (dimension2.height >= dimension.height && dimension2.width >= dimension.width) {
            bl = false;
            bl2 = false;
        } else if (dimension2.width < dimension.width) {
            bl2 = true;
            dimension2.height -= this.hScrollbar.getSize().height;
            if (dimension2.height < dimension.height) {
                bl = true;
                dimension2.width -= this.vScrollbar.getSize().width;
            }
        } else if (dimension2.height < dimension.height) {
            bl = true;
            dimension2.width -= this.vScrollbar.getSize().width;
            if (dimension2.width < dimension.width) {
                bl2 = true;
                dimension2.height -= this.hScrollbar.getSize().height;
            }
        }
        if (bl && !this.vScrollbarVisible) {
            this.vScrollbarVisible = true;
            this.add((Component)this.vScrollbar, "East");
        } else if (!bl && this.vScrollbarVisible) {
            this.remove(this.vScrollbar);
            this.vScrollbarVisible = false;
        }
        if (bl2 && !this.hScrollbarVisible) {
            this.hScrollbarVisible = true;
            this.add((Component)this.hScrollbar, "South");
        } else if (!bl2 && this.hScrollbarVisible) {
            this.remove(this.hScrollbar);
            this.hScrollbarVisible = false;
        }
        if (this.hScrollbarVisible) {
            this.hScrollbar.setMinimum(0);
            this.hScrollbar.setMaximum(dimension.width / this.horizontalIncrement);
            this.hScrollbar.setVisibleAmount(dimension2.width / this.horizontalIncrement);
            this.hScrollbar.setUnitIncrement(1);
        }
        if (this.vScrollbarVisible) {
            this.vScrollbar.setMinimum(0);
            this.vScrollbar.setMaximum(dimension.height / this.verticalIncrement);
            this.vScrollbar.setVisibleAmount(dimension2.height / this.verticalIncrement - 1);
            this.vScrollbar.setUnitIncrement(1);
            this.vScrollbar.setBlockIncrement(this.verticalBlockIncrement / this.verticalIncrement);
        }
        super.doLayout();
    }

    public Dimension getViewportSize() {
        return this.content.getSize();
    }

    public Point getScrollPosition() {
        int n = 0;
        if (this.hScrollbarVisible) {
            n = this.hScrollbar.getValue();
        }
        int n2 = 0;
        if (this.vScrollbarVisible) {
            n2 = this.vScrollbar.getValue();
        }
        return new Point(n * this.horizontalIncrement, n2 * this.verticalIncrement);
    }

    public Point getScrollLocation() {
        int n = 0;
        if (this.hScrollbarVisible) {
            n = this.hScrollbar.getValue();
        }
        int n2 = 0;
        if (this.vScrollbarVisible) {
            n2 = this.vScrollbar.getValue();
        }
        return new Point(n, n2);
    }

    public void setScrollLocation(Point point) {
        this.hScrollbar.setValue(point.x);
        this.vScrollbar.setValue(point.y);
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void blockUp() {
        int n = this.vScrollbar.getValue() - this.vScrollbar.getBlockIncrement();
        if (n < 0) {
            n = 0;
        }
        this.vScrollbar.setValue(n);
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void blockDown() {
        int n = this.vScrollbar.getValue() + this.vScrollbar.getBlockIncrement();
        if (n > this.vScrollbar.getMaximum()) {
            n = this.vScrollbar.getMaximum();
        }
        this.vScrollbar.setValue(n);
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void verticalHome() {
        this.vScrollbar.setValue(this.vScrollbar.getMinimum());
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void verticalEnd() {
        this.vScrollbar.setValue(this.vScrollbar.getMaximum());
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
    }

    public void ensureVisible(Point point) {
        int n;
        int n2;
        int n3;
        if (!this.vScrollbarVisible && !this.hScrollbarVisible) {
            return;
        }
        boolean bl = false;
        if (this.hScrollbarVisible) {
            n3 = this.hScrollbar.getValue() * this.horizontalIncrement;
            n2 = n3 + this.hScrollbar.getVisibleAmount() * this.horizontalIncrement;
            if (n3 > point.x) {
                this.hScrollbar.setValue(point.x / this.horizontalIncrement);
                bl = true;
            } else if (n2 <= point.x) {
                n = (point.x - (n2 - n3)) / this.horizontalIncrement + 1;
                this.hScrollbar.setValue(n);
                bl = true;
            }
        }
        if (this.vScrollbarVisible) {
            n3 = this.vScrollbar.getValue() * this.verticalIncrement;
            n2 = n3 + this.vScrollbar.getVisibleAmount() * this.verticalIncrement;
            if (n3 > point.y) {
                this.vScrollbar.setValue(point.y / this.verticalIncrement);
                bl = true;
            } else if (n2 <= point.y) {
                n = (point.y - (n2 - n3)) / this.verticalIncrement + 1;
                this.vScrollbar.setValue(n);
                bl = true;
            }
        }
        if (bl) {
            ((GScrollable)((Object)this.content)).scrollPositionChanged(this);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.adjustScrollbars();
    }
}

