/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGDriver;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;

public class Figlet
extends Applet
implements ActionListener,
ItemListener,
WindowListener {
    private boolean started = false;
    private Frame f;
    private static final String TITLE = "FIGLet Applet 0.3";
    private static final String INFO = "FIGLet Applet 0.31998 by Gebhard Markus, ukgh@rz.uni-karlsruhe.de";
    private static final String COPYRIGHT = "brought 2 U by Markus Gebhard 1999";
    private FIGDriver figletizer;
    private String currentFont;
    private int scale = 8;
    private TextArea taOutput;
    private TextArea taInput;
    private Button bScalePlus;
    private Button bScaleMinus;
    private Button bDemo;
    private Button bConvert;
    private Choice choice_scale;
    private Choice choice_font;

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.dialog();
    }

    public void start() {
        this.currentFont = "standard";
        this.figletizer = new FIGDriver();
        this.showStatus("loading font " + this.currentFont + "...");
        this.figletizer.setFont(this.getCodeBase() + this.currentFont);
        this.showStatus("ready");
        this.validate();
        this.figletize();
        this.repaint();
        this.taInput.requestFocus();
    }

    public void paint(Graphics graphics) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bConvert) {
            this.figletize();
            return;
        }
        if (actionEvent.getSource() == this.bDemo) {
            String string = new String("");
            string = string + "! _$%&/()=?`123";
            string = string + "\n";
            string = string + "4567890abcdefghi";
            string = string + "\n";
            string = string + "jklmnopqrstuvwxy";
            string = string + "\n";
            string = string + "z\u00e4\u00f6\u00fcABCDEFGHIJKLMNO";
            string = string + "\n";
            string = string + "PQRSTUVWXYZ\u00c4\u00d6\u00dc\u00df*+#-:";
            this.taInput.setText(string);
            this.figletize();
            return;
        }
        if (actionEvent.getSource() == this.bScaleMinus) {
            int n = Integer.parseInt(this.choice_scale.getSelectedItem()) - 1;
            if (n >= 4) {
                this.scale = n;
                this.taOutput.setFont(new Font("Courier", 0, this.scale));
                this.choice_scale.select(String.valueOf(this.scale));
                this.validate();
            }
            return;
        }
        if (actionEvent.getSource() == this.bScalePlus) {
            int n = Integer.parseInt(this.choice_scale.getSelectedItem()) + 1;
            if (n <= 20) {
                this.scale = n;
                this.taOutput.setFont(new Font("Courier", 0, this.scale));
                this.choice_scale.select(String.valueOf(this.scale));
                this.validate();
            }
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choice_font) {
            String string = this.choice_font.getSelectedItem();
            if (!string.equals(this.currentFont)) {
                this.showStatus("loading font " + string + "...");
                this.currentFont = string;
                this.figletize();
                this.showStatus("finished");
            }
            return;
        }
        if (itemEvent.getSource() == this.choice_scale) {
            int n = Integer.parseInt(this.choice_scale.getSelectedItem());
            if (n != this.scale) {
                this.scale = n;
                this.taOutput.setFont(new Font("Courier", 0, this.scale));
                this.validate();
            }
            return;
        }
    }

    public void figletize() {
        if (this.figletizer == null) {
            return;
        }
        this.showStatus("converting...");
        this.taOutput.setText("");
        String string = this.taInput.getText();
        int n = string.indexOf(10);
        while (n != -1) {
            string = string.substring(0, n) + "<br>" + string.substring(n + 1);
            n = string.indexOf(10);
        }
        this.figletizer.setFont(this.getCodeBase() + this.currentFont);
        string = "<figlet ascii 80>" + string + "</fig>";
        String string2 = this.figletizer.FIGML(string);
        this.taOutput.append(string2);
        this.showStatus("ready");
    }

    public void dialog() {
        Object object;
        Object object2;
        this.add(new Label("Figlet Applet running"));
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        this.taInput = new TextArea(5, 10);
        this.taInput.setEditable(true);
        this.taInput.setText(TITLE);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.taInput, gridBagConstraints);
        panel.add(this.taInput);
        this.bConvert = new Button("convert");
        this.bConvert.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 15);
        gridBagLayout.setConstraints(this.bConvert, gridBagConstraints);
        panel.add(this.bConvert);
        this.taOutput = new TextArea(24, 90);
        this.taOutput.setFont(new Font("Courier", 0, this.scale));
        this.taOutput.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 10);
        gridBagLayout.setConstraints(this.taOutput, gridBagConstraints);
        panel.add(this.taOutput);
        Panel panel2 = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        panel2.setLayout(gridBagLayout2);
        Label label = new Label(TITLE, 0);
        label.setFont(new Font("Dialog", 1, 24));
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 12;
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        panel2.add(label);
        Label label2 = new Label(COPYRIGHT, 0);
        label2.setFont(new Font("Dialog", 1, 10));
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 50, 0);
        gridBagLayout2.setConstraints(label2, gridBagConstraints2);
        panel2.add(label2);
        Label label3 = new Label("font:");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(label3, gridBagConstraints2);
        panel2.add(label3);
        this.choice_font = new Choice();
        this.choice_font.addItemListener(this);
        String string = this.getParameter("fonts");
        if (string == null) {
            this.choice_font.addItem("standard");
        } else {
            object2 = new StringTokenizer(string, "\n\t, ;:\r");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                this.choice_font.addItem(((String)object).trim());
            }
        }
        this.choice_font.select("standard");
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagLayout2.setConstraints(this.choice_font, gridBagConstraints2);
        panel2.add(this.choice_font);
        object2 = new Label("layout:");
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 0;
        gridBagLayout2.setConstraints((Component)object2, gridBagConstraints2);
        panel2.add((Component)object2);
        object = new Label("size:");
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.fill = 0;
        gridBagLayout2.setConstraints((Component)object, gridBagConstraints2);
        panel2.add((Component)object);
        this.bScaleMinus = new Button("-");
        this.bScaleMinus.addActionListener(this);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 13;
        gridBagLayout2.setConstraints(this.bScaleMinus, gridBagConstraints2);
        panel2.add(this.bScaleMinus);
        this.choice_scale = new Choice();
        int n = 4;
        while (n < 21) {
            this.choice_scale.addItem(String.valueOf(n));
            ++n;
        }
        this.taOutput.setFont(new Font("Courier", 0, this.scale));
        this.choice_scale.select(String.valueOf(this.scale));
        this.choice_scale.addItemListener(this);
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = -1;
        gridBagConstraints2.anchor = 10;
        gridBagLayout2.setConstraints(this.choice_scale, gridBagConstraints2);
        panel2.add(this.choice_scale);
        this.bScalePlus = new Button("+");
        this.bScalePlus.addActionListener(this);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        gridBagLayout2.setConstraints(this.bScalePlus, gridBagConstraints2);
        panel2.add(this.bScalePlus);
        this.bDemo = new Button("demo");
        this.bDemo.addActionListener(this);
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout2.setConstraints(this.bDemo, gridBagConstraints2);
        panel2.add(this.bDemo);
        this.f = new Frame(TITLE);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.f.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridwidth = -1;
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(panel, gridBagConstraints3);
        this.f.add(panel);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.gridheight = 0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(panel2, gridBagConstraints3);
        this.f.add(panel2);
        this.f.addWindowListener(this);
        this.f.pack();
        this.f.show();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.f.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public String getAppletInfo() {
        return INFO;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"fonts", "String", "a list of all available font-files seperated by >,<"}};
        return stringArray;
    }
}

