/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGDriver;
import de.jave.figlet.FIGEditor;
import de.jave.util.ResultConsumer;
import de.jave.util.WarningCollector;
import java.awt.Frame;
import java.awt.TextArea;

public class FIGThread
extends Thread {
    private FIGDriver figDriver;
    private TextArea taOutput;
    protected ResultConsumer resultConsumer;
    private Frame fOutput;
    private String job;
    public boolean stop;
    private long jobCount;
    private long jobDoneCount;
    private WarningCollector warner;
    private FIGEditor editor;

    public FIGThread(FIGDriver fIGDriver, TextArea textArea, Frame frame, WarningCollector warningCollector) {
        this(fIGDriver, textArea, null, frame, warningCollector);
    }

    public FIGThread(FIGDriver fIGDriver, ResultConsumer resultConsumer, Frame frame, WarningCollector warningCollector) {
        this(fIGDriver, null, resultConsumer, frame, warningCollector);
    }

    public FIGThread(FIGDriver fIGDriver, TextArea textArea, ResultConsumer resultConsumer, Frame frame, WarningCollector warningCollector) {
        this.figDriver = fIGDriver;
        this.taOutput = textArea;
        this.resultConsumer = resultConsumer;
        this.fOutput = frame;
        this.warner = warningCollector;
        this.job = null;
        this.jobCount = 0L;
        this.jobDoneCount = 0L;
    }

    public synchronized void addJob(String string) {
        this.job = string;
        ++this.jobCount;
        this.interrupt();
    }

    private synchronized String getJob() {
        String string = this.job;
        this.job = null;
        return string;
    }

    public void run() {
        this.setPriority(this.getPriority() - 1);
        this.stop = false;
        String string = null;
        String string2 = "";
        while (!this.stop) {
            string = this.getJob();
            if (string != null) {
                long l = System.currentTimeMillis();
                try {
                    if (this.warner != null) {
                        this.warner.clear();
                    }
                    string2 = this.figDriver.FIGML(string);
                }
                catch (Exception exception) {
                    FIGDriver.warning("Error with FIGML! " + exception.toString());
                    string2 = exception.toString();
                }
                Thread.yield();
                if (this.taOutput != null) {
                    this.taOutput.setText(string2);
                }
                if (this.resultConsumer != null) {
                    this.resultConsumer.putResult(string2);
                }
                Thread.yield();
                ++this.jobDoneCount;
                long l2 = System.currentTimeMillis() - l;
                if (this.fOutput != null) {
                    this.fOutput.setTitle("FIGlet FIGML-output [" + l2 + "ms] " + this.jobDoneCount + "/" + this.jobCount);
                }
            }
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

