/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGDriver;
import de.jave.figlet.FIGFileManager;
import de.jave.figlet.FIGThread;
import de.jave.gui.CactusBar;
import de.jave.gui.GTextArea;
import de.jave.util.WarningCollector;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import gebhard.uielements.StatusBar;
import gebhard.uielements.WarningDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

public class FIGEditor
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
TextListener,
KeyListener,
NumberListener {
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static final int MIN_LINE_LENGTH = 1;
    private static final int MAX_LINE_LENGTH = 10000;
    private static String START_TEXT = "<figlet ascii 72>\n<hr=*>\n<halign=center> Welcome to<br>\nFiglet!\n<hr=*>\n</fig>";
    private TextArea asciiOutput;
    private TextArea taInput;
    public static final String TITLE = "FIGEditor alpha3 (0.3)";
    private static final Color BACKGROUND = new Color(128, 128, 255);
    private Button bFigletize;
    private Button bFonts;
    protected Button bSizePlus;
    protected Button bSizeMinus;
    private Choice chFont;
    private Choice chControl;
    private Choice chOutput;
    private IntegerTextField tfLength;
    private Checkbox cbOnTheFly;
    private Checkbox cbPopular;
    private Checkbox cbWarnings;
    private Toolkit toolkit;
    private Image icon;
    protected Dialog inputDialog;
    private StatusBar status;
    private FIGDriver figDriver;
    private FIGThread figThread;
    private WarningCollector warner;
    private WarningDialog warningDialog;

    public FIGEditor() {
        super(TITLE);
        FIGFileManager.init();
        this.init();
        this.warningDialog = new WarningDialog((Frame)this, "Warnings", "", false);
        this.warner = new WarningCollector(this.warningDialog);
        this.warningDialog.setPopUp(false);
        this.warningDialog.setVisible(false);
        this.figDriver = new FIGDriver(this.warner);
        this.figThread = new FIGThread(this.figDriver, this.asciiOutput, (Frame)this, this.warner);
        this.figThread.start();
        this.figletize();
    }

    public void clearWarnings() {
        this.warner.clear();
    }

    private void init() {
        this.inputDialog = new Dialog(this, TITLE, false);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.icon = this.toolkit.getImage("./images/icon.gif");
        this.setIconImage(this.icon);
        this.addWindowListener(this);
        this.asciiOutput = new TextArea(30, 80);
        this.asciiOutput.setFont(new Font("Monospaced", 0, 12));
        this.asciiOutput.addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.asciiOutput, "Center");
        Panel panel = new Panel();
        this.bSizeMinus = new Button("Font size -1");
        this.bSizeMinus.addActionListener(this);
        panel.add(this.bSizeMinus);
        this.bSizePlus = new Button("Font size +1");
        this.bSizePlus.addActionListener(this);
        panel.add(this.bSizePlus);
        this.add((Component)panel, "South");
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.chFont = new Choice();
        this.chControl = new Choice();
        String[] stringArray = FIGFileManager.getAllFontNames();
        int n = 0;
        while (n < stringArray.length) {
            this.chFont.add(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = FIGFileManager.getAllControlNames();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.chFont.add(stringArray2[n2]);
            ++n2;
        }
        this.chOutput = new Choice();
        int n3 = 0;
        while (n3 < FIGDriver.FORMAT_STR.length) {
            this.chOutput.add(FIGDriver.FORMAT_STR[n3]);
            ++n3;
        }
        this.bFonts = new Button("show Fonts");
        this.bFonts.addActionListener(this);
        this.tfLength = new IntegerTextField(80, 1, 10000);
        this.tfLength.addNumberListener(this);
        panel2.add(this.chOutput);
        panel2.add(new Label("length:", 2));
        panel2.add(this.tfLength);
        panel2.add(new Label("font:", 2));
        panel2.add(this.chFont);
        panel2.add(new Label("controlfile:", 2));
        panel2.add(this.chControl);
        this.cbOnTheFly = new Checkbox("on the fly", true);
        panel2.add(this.cbOnTheFly);
        this.cbWarnings = new Checkbox("warnings", false);
        this.cbWarnings.addItemListener(this);
        panel2.add(this.cbWarnings);
        this.cbPopular = new Checkbox("popular fonts only", false);
        this.cbPopular.addItemListener(this);
        panel2.add(this.cbPopular);
        this.chFont.addItemListener(this);
        this.chControl.addItemListener(this);
        this.chOutput.addItemListener(this);
        this.taInput = new GTextArea(START_TEXT, 20, 80, 0);
        this.taInput.setBackground(BACKGROUND);
        this.taInput.addTextListener(this);
        this.taInput.addKeyListener(this);
        this.taInput.setFont(new Font("Monospaced", 0, 12));
        Button button = new Button("figletize");
        button.addActionListener(this);
        this.status = new StatusBar();
        this.inputDialog.addWindowListener(this);
        this.inputDialog.setLayout(new BorderLayout());
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)panel2, "North");
        panel3.add((Component)this.taInput, "Center");
        panel3.add((Component)button, "East");
        this.inputDialog.add((Component)panel3, "Center");
        CactusBar cactusBar = new CactusBar("FIGLet");
        this.inputDialog.add((Component)cactusBar, "West");
        this.inputDialog.add((Component)this.status, "South");
        this.inputDialog.pack();
        this.inputDialog.show();
    }

    private void figletize() {
        String string = this.taInput.getText();
        this.figThread.addJob(string);
    }

    private void allFontsForChoice() {
        this.chFont.removeAll();
        String[] stringArray = FIGFileManager.getAllFontNames();
        int n = 0;
        while (n < stringArray.length) {
            this.chFont.add(stringArray[n]);
            ++n;
        }
    }

    private void popularFontsForChoice() {
        this.chFont.removeAll();
        String[] stringArray = FIGFileManager.getAllFontNames();
        int n = 0;
        while (n < stringArray.length) {
            this.chFont.add(stringArray[n]);
            ++n;
        }
    }

    private void setOutputFormat(String string, int n) {
        String string2 = this.taInput.getText();
        int n2 = string2.indexOf("<fig");
        if (n2 == -1) {
            string2 = "<figlet " + string + " " + n;
            this.taInput.setText(string2);
            return;
        }
        int n3 = string2.indexOf(62, n2);
        string2 = string2.substring(0, n2) + "<figlet " + string + " " + n + ">" + string2.substring(n3 + 1);
        this.taInput.setText(string2);
    }

    private void setTextFont(String string) {
        String string2;
        String string3;
        String string4;
        String string5 = this.taInput.getText();
        int n = this.taInput.getCaretPosition();
        if (n > 5) {
            string4 = string5.substring(0, n - 5);
            string3 = string5.substring(n);
            if (string5.substring(n - 5, n).equals(".flf>")) {
                int n2 = string4.lastIndexOf(60);
                string4 = string4.substring(0, n2);
                string5 = string4 + string + string3;
                this.taInput.setText(string5);
                this.taInput.setCaretPosition(string4.length() + string.length());
                this.figletize();
                this.taInput.requestFocus();
                return;
            }
        }
        if (n < string5.length() - 6) {
            int n3;
            string4 = string5.substring(0, n);
            string3 = string5.substring(n);
            if (string3.charAt(0) == '<' && string3.substring(0, n3 = string3.indexOf(62)).endsWith(".flf")) {
                string3 = string3.substring(n3 + 1);
                string5 = string4 + string + string3;
                this.taInput.setText(string5);
                this.taInput.setCaretPosition(string4.length());
                this.figletize();
                this.taInput.requestFocus();
                return;
            }
        }
        int n4 = string5.lastIndexOf(60, n);
        int n5 = string5.indexOf(62, n);
        if (n4 != -1 && n5 != -1 && (string2 = string5.substring(n4, n5)).endsWith(".flf")) {
            String string6 = string5.substring(0, n4);
            String string7 = string5.substring(n5 + 1);
            string5 = string6 + string + string7;
            this.taInput.setText(string5);
            this.taInput.setCaretPosition(string6.length() + string.length());
            this.figletize();
            this.taInput.requestFocus();
            return;
        }
        this.taInput.insert(string, this.taInput.getCaretPosition());
        this.figletize();
        this.taInput.requestFocus();
    }

    protected void outputFontSizeMinus() {
        Font font = this.asciiOutput.getFont();
        int n = font.getSize();
        if (n <= 4) {
            return;
        }
        font = new Font(font.getName(), font.getStyle(), --n);
        this.asciiOutput.setFont(font);
    }

    protected void outputFontSizePlus() {
        Font font = this.asciiOutput.getFont();
        font = new Font(font.getName(), font.getStyle(), font.getSize() + 1);
        this.asciiOutput.setFont(font);
    }

    private void showFonts() {
        String string = this.taInput.getSelectedText();
        if (string == null || string.equals("")) {
            string = "abcABC";
        }
        Vector<String> vector = new Vector<String>(200, 100);
        File file = new File(".");
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".flf")) {
                vector.addElement(stringArray[n].substring(0, stringArray[n].length() - 4));
            }
            ++n;
        }
    }

    public void numberChanged(NumberEvent numberEvent) {
        if (numberEvent.getSource().equals(this.tfLength)) {
            this.setOutputFormat(this.chOutput.getSelectedItem(), this.tfLength.getValue());
            if (this.cbOnTheFly.getState()) {
                this.figletize();
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.tfLength) {
            return;
        }
        if (this.cbOnTheFly.getState()) {
            this.figletize();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.chFont)) {
            this.setTextFont("<" + this.chFont.getSelectedItem() + ".flf>");
        } else if (itemEvent.getSource().equals(this.chOutput)) {
            this.setOutputFormat(this.chOutput.getSelectedItem(), this.tfLength.getValue());
            if (this.cbOnTheFly.getState()) {
                this.figletize();
            }
        } else if (itemEvent.getSource().equals(this.chControl)) {
            String string = "<" + this.chControl.getSelectedItem() + ".flc>";
            this.taInput.insert(string, this.taInput.getCaretPosition());
        } else if (itemEvent.getSource().equals(this.cbWarnings)) {
            boolean bl = this.cbWarnings.getState();
            this.warningDialog.setPopUp(bl);
            if (!bl) {
                this.warningDialog.setVisible(false);
            }
        } else if (itemEvent.getSource().equals(this.cbPopular)) {
            if (this.cbPopular.getState()) {
                this.popularFontsForChoice();
            } else {
                this.allFontsForChoice();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bFonts) {
            this.showFonts();
            return;
        }
        if (object == this.bSizePlus) {
            this.outputFontSizePlus();
        } else if (object == this.bSizeMinus) {
            this.outputFontSizeMinus();
        } else {
            this.figletize();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getComponent() == this.asciiOutput && keyEvent.isControlDown() && !keyEvent.isAltDown()) {
            int n = keyEvent.getKeyCode();
            if (n == 65) {
                this.asciiOutput.selectAll();
            } else if (n == 56) {
                this.outputFontSizeMinus();
            } else if (n == 57) {
                this.outputFontSizePlus();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getComponent() != this.asciiOutput && keyEvent.getKeyChar() == '\n' && !keyEvent.isShiftDown()) {
            int n = this.taInput.getCaretPosition();
            this.taInput.insert("<br>", n);
        }
    }

    public static void main(String[] stringArray) {
        FIGEditor fIGEditor = new FIGEditor();
        fIGEditor.pack();
        fIGEditor.show();
    }
}

