/*
 * Decompiled with CFR 0.152.
 */
package de.jave.calculus;

import de.jave.calculus.Calculus;
import de.jave.calculus.CalculusTreeConstants;
import de.jave.calculus.CalculusVisitor;
import de.jave.calculus.Node;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Calculus parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(Calculus calculus, int n) {
        this(n);
        this.parser = calculus;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(CalculusVisitor calculusVisitor, Object object) {
        return calculusVisitor.visit(this, object);
    }

    public Object childrenAccept(CalculusVisitor calculusVisitor, Object object) {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n].jjtAccept(calculusVisitor, object);
                ++n;
            }
        }
        return object;
    }

    public String toString() {
        return CalculusTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public double evaluate(double d) throws Exception {
        SimpleNode simpleNode = (SimpleNode)this.children[0];
        return simpleNode.evaluate(d);
    }
}

