/*
 * Decompiled with CFR 0.152.
 */
package de.jave.util;

public class Queue {
    protected Object[] entries;
    protected int start;
    protected int end;

    public Queue() {
        this(200);
    }

    public Queue(int n) {
        this.entries = new Object[n];
        this.start = 0;
        this.end = -1;
    }

    public synchronized void put(Object object) {
        if (this.size() == this.capacity()) {
            this.ensureCapacity(2 * this.capacity());
        }
        ++this.end;
        this.end %= this.capacity();
        this.entries[this.end] = object;
    }

    public synchronized Object get() {
        if (this.size() == 0) {
            throw new RuntimeException("Tried to get entry from Queue where queue is empty!");
        }
        Object object = this.entries[this.start];
        if (this.start == this.end) {
            this.start = 0;
            this.end = -1;
        } else {
            ++this.start;
            this.start %= this.capacity();
        }
        return object;
    }

    public int capacity() {
        return this.entries.length;
    }

    public int size() {
        if (this.end == -1) {
            return 0;
        }
        if (this.end < this.start) {
            return this.capacity() + this.end - this.start + 1;
        }
        return this.end - this.start + 1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected synchronized void ensureCapacity(int n) {
        Object[] objectArray = new Object[n];
        if (this.end < this.start) {
            System.arraycopy(this.entries, this.start, objectArray, 0, this.capacity() - this.start);
            System.arraycopy(this.entries, 0, objectArray, this.capacity() - this.start, this.end + 1);
            this.end = this.capacity() - this.start + 1;
            this.start = 0;
        } else {
            System.arraycopy(this.entries, this.start, objectArray, 0, this.end - this.start + 1);
            this.end -= this.start;
            this.start = 0;
        }
        this.entries = objectArray;
    }

    public synchronized void clear() {
        this.start = 0;
        this.end = -1;
    }

    public static void main(String[] stringArray) {
        Queue queue = new Queue(5);
        int n = 0;
        while (n < 20) {
            queue.put(new Integer(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < 5) {
            System.out.println(queue.get());
            ++n2;
        }
        int n3 = 20;
        while (n3 < 25) {
            queue.put(new Integer(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < 20) {
            System.out.println(queue.get());
            ++n4;
        }
    }
}

