/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.JavePlayer;
import de.jave.javeplayer.JavePlayerTools;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.GridLayout;

public class JavePlayerApplet
extends Applet {
    protected boolean initialized = false;
    protected JavePlayer player;

    public String getAppletInfo() {
        return "Jave Player V1.3";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"FILE", "String", "Name of the Jave movie file to be loaded"}, {"BACKGROUND", "Hex-Value", "Color for background, e.g.: #FFFF60"}, {"FOREGROUND", "Hex-Value", "Color for foreground, e.g.: #FFFF60"}, {"DURATION", "int", "Default duration for a frame"}, {"AUTOSTART", "int", "Player will immediately start playing the movie if value is 1"}, {"LOOP", "int", "Player will loop infinite times if value is 1"}, {"CONTROLS", "int", "0: No controls 1: Just buttons 2: All controls visible"}, {"SOUND", "String", "Name of a sound file (*.mid, *.au or *.wav) to be played at play()"}, {"SOUNDSTART", "String", "When to play the sound file: 'once', 'loop' or 'event'"}};
        return stringArray;
    }

    public void init() {
        Object object;
        if (this.initialized) {
            return;
        }
        int n = 66;
        int n2 = 2;
        boolean bl = false;
        boolean bl2 = false;
        Color color = JavePlayer.DEFAULT_BACKGROUND;
        Color color2 = JavePlayer.DEFAULT_FOREGROUND;
        String string = null;
        int n3 = 0;
        try {
            object = this.getParameter("DURATION");
            if (object != null) {
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Error reading parameter 'DURATION': " + numberFormatException);
                }
            }
            if ((object = this.getParameter("CONTROLS")) != null) {
                if (((String)object).equals("0")) {
                    n2 = 0;
                } else if (((String)object).equals("1")) {
                    n2 = 1;
                } else {
                    System.err.println("Error reading parameter 'CONTROLS': Must be 0 or 1");
                }
            }
            if ((object = this.getParameter("LOOP")) != null && ((String)object).equals("1")) {
                bl = true;
            }
            if ((object = this.getParameter("SOUND")) != null && ((String)object).length() > 0) {
                string = object;
            }
            if ((object = this.getParameter("SOUNDSTART")) != null) {
                if (((String)(object = ((String)object).toLowerCase())).equals("once")) {
                    n3 = 0;
                } else if (((String)object).equals("loop")) {
                    n3 = 1;
                } else if (((String)object).equals("event")) {
                    n3 = 2;
                } else {
                    System.err.println("Error reading parameter 'SOUNDSTART': Must be 'once' or 'loop' or 'event'");
                }
            }
            if ((object = this.getParameter("AUTOSTART")) != null && ((String)object).equals("1")) {
                bl2 = true;
            }
            if ((object = this.getParameter("BACKGROUND")) != null) {
                color = JavePlayerTools.hexToColor((String)object);
            }
            if ((object = this.getParameter("FOREGROUND")) != null) {
                color2 = JavePlayerTools.hexToColor((String)object);
            }
        }
        catch (Exception exception) {
            System.err.println("Error reading parameters: " + exception);
        }
        this.player = new JavePlayer(n, n2, bl, bl2, color, color2);
        if (string != null) {
            object = this.getAudioClip(this.getDocumentBase(), string);
            this.player.setAudioClip((AudioClip)object);
            this.player.setAudioStart(n3);
        }
        this.setLayout(new GridLayout(1, 0, 0, 0));
        this.add(this.player);
        this.initialized = true;
    }

    public void start() {
        this.player.load(this.getCodeBase() + this.getParameter("FILE"));
    }

    public void stop() {
        this.player.stop();
    }
}

