/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.JaveMovieFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;

public class JavePlate
extends Canvas {
    protected char[][] content;
    protected char[][] selection;
    protected JaveMovieFrame currentFrame;
    protected int width;
    protected int height;
    protected int selectionWidth;
    protected int selectionHeight;
    protected int charWidth;
    protected int charHeight;
    protected boolean isRepainted;
    protected String statusMessage = "* No Movie Loaded *";
    protected static final Font MESSAGE_FONT = new Font("Dialog", 0, 11);
    protected static final int DEFAULT_FONT_SIZE = 11;
    protected static final int MIN_FONT_SIZE = 7;
    protected static final int MAX_FONT_SIZE = 16;
    protected int fontSize;
    private Dimension offDimension;
    private Image offImage;
    private Graphics offGraphics;

    public JavePlate() {
        this.setFontSize(11);
    }

    public void setStatusMessage(String string) {
        this.statusMessage = string;
        this.repaint();
    }

    public void setContent(JaveMovieFrame javeMovieFrame) {
        Color color;
        Color color2;
        if (javeMovieFrame == null) {
            this.content = null;
            this.selection = null;
            this.currentFrame = javeMovieFrame;
            return;
        }
        this.content = javeMovieFrame.getContent();
        this.selection = javeMovieFrame.getSelection();
        this.height = this.content.length;
        this.width = this.content[0].length;
        if (this.selection != null) {
            this.selectionHeight = this.selection.length;
            this.selectionWidth = this.selection[0].length;
        }
        if ((color2 = javeMovieFrame.getForeground()) != null) {
            this.setForeground(color2);
        }
        if ((color = javeMovieFrame.getBackground()) != null) {
            this.setBackground(color);
        }
        this.currentFrame = javeMovieFrame;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width * this.charWidth + 4, this.height * this.charHeight + 4);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void setFontSize(int n) {
        if (n == this.fontSize) {
            return;
        }
        this.fontSize = n;
        this.setFont(new Font("Monospaced", 0, this.fontSize));
        this.charWidth = this.getFontMetrics(this.getFont()).stringWidth("#");
        this.charHeight = (int)Math.round(-0.14 * (double)this.fontSize * (double)this.fontSize + 4.56 * (double)this.fontSize - 19.3);
        this.repaint();
    }

    public void zoomIn() {
        if (this.fontSize < 16) {
            this.setFontSize(this.fontSize + 1);
        }
    }

    public void zoomOut() {
        if (this.fontSize > 7) {
            this.setFontSize(this.fontSize - 1);
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.offGraphics == null || this.offDimension.width != dimension.width || this.offDimension.height != dimension.height) {
            this.offImage = this.createImage(dimension.width, dimension.height);
            this.offGraphics = this.offImage.getGraphics();
            this.offDimension = new Dimension(dimension.width, dimension.height);
        }
        this.offGraphics.setColor(this.getBackground());
        this.offGraphics.fillRect(0, 0, dimension.width, dimension.height);
        this.offGraphics.setColor(SystemColor.controlDkShadow);
        this.offGraphics.drawLine(1, 1, dimension.width - 1, 1);
        this.offGraphics.drawLine(1, 2, 1, dimension.height - 1);
        this.offGraphics.setColor(SystemColor.controlShadow);
        this.offGraphics.drawLine(0, 0, dimension.width - 1, 0);
        this.offGraphics.drawLine(0, 1, 0, dimension.height - 1);
        this.offGraphics.setColor(SystemColor.controlHighlight);
        this.offGraphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        this.offGraphics.drawLine(dimension.width - 2, dimension.height - 3, dimension.width - 2, 1);
        this.offGraphics.setColor(SystemColor.controlLtHighlight);
        this.offGraphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        this.offGraphics.drawLine(dimension.width - 1, dimension.height - 2, dimension.width - 1, 0);
        this.offGraphics.setColor(this.getForeground());
        this.offGraphics.setFont(this.getFont());
        if (this.content != null && this.content.length > 0) {
            int n;
            Object object;
            int n2 = (dimension.width - this.content[0].length * this.charWidth) / 2;
            int n3 = (dimension.height - this.content.length * this.charHeight) / 2;
            if (n2 < 2) {
                n2 = 2;
            }
            if (n3 < 2) {
                n3 = 2;
            }
            int n4 = 0;
            while (n4 < this.height) {
                this.offGraphics.drawString(new String(this.content[n4]), n2, n3 + n4 * this.charHeight + this.charHeight * 3 / 4);
                ++n4;
            }
            if (this.selection != null) {
                object = this.getForeground();
                Color color = this.getBackground();
                this.offGraphics.setColor(new Color((((Color)object).getRed() + color.getRed()) / 2, (((Color)object).getGreen() + color.getGreen()) / 2, (((Color)object).getBlue() + color.getBlue()) / 2));
                n = this.currentFrame.getSelectionX();
                int n5 = this.currentFrame.getSelectionY();
                int n6 = 0;
                while (n6 < this.selectionHeight) {
                    this.offGraphics.drawString(new String(this.selection[n6]), n2 + n * this.charWidth, n3 + (n5 + n6) * this.charHeight + this.charHeight * 3 / 4);
                    ++n6;
                }
                this.offGraphics.setColor(this.getBackground().darker());
                this.offGraphics.drawRect(n2 + n * this.charWidth, n3 + n5 * this.charHeight, this.selectionWidth * this.charWidth, this.selectionHeight * this.charHeight);
            }
            object = this.currentFrame.getTool();
            int n7 = this.currentFrame.getCursorX();
            n = this.currentFrame.getCursorY();
            if (object != null && ((String)object).equals("Text") && n7 >= 0 && n >= 0) {
                this.offGraphics.setColor(Color.gray);
                this.offGraphics.drawLine(n2 + n7 * this.charWidth + 2, n3 + n * this.charHeight + this.charHeight - 2, n2 + n7 * this.charWidth + 2, n3 + n * this.charHeight + 2);
            }
        } else if (this.statusMessage != null && this.statusMessage.length() > 0) {
            this.offGraphics.setFont(MESSAGE_FONT);
            int n = this.getFontMetrics(MESSAGE_FONT).stringWidth(this.statusMessage);
            this.offGraphics.drawString(this.statusMessage, (dimension.width - n) / 2, dimension.height / 2 + 12);
        }
        graphics.drawImage(this.offImage, 0, 0, this);
        this.isRepainted = true;
    }

    public void repaint() {
        this.isRepainted = false;
        super.repaint();
    }

    public boolean isRepainted() {
        return this.isRepainted;
    }
}

