/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GDialog;
import de.jave.gui.GGridLayout2;
import de.jave.jave.Ascii;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveSelection;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class SteganogramDecoder
implements TextListener {
    protected TextField tfDecoded;
    protected TextField tfGradient;
    protected Panel panel;
    protected Jave jave;

    public SteganogramDecoder(Jave jave) {
        this.jave = jave;
        this.panel = new Panel();
        this.panel.setLayout(new GGridLayout2(0, 2));
        this.tfGradient = new TextField(" .'~:;!>+=icjtJY56SXDQKHNWM");
        this.tfDecoded = new TextField("", 27);
        this.panel.add(new Label("Key (gradient):", 2));
        this.panel.add(this.tfGradient);
        this.panel.add(new Label("Text:", 2));
        this.panel.add(this.tfDecoded);
        this.tfGradient.addTextListener(this);
    }

    public void show() {
        GDialog gDialog = new GDialog((Frame)this.jave, "Decode Steganogram", (Component)this.panel, GDialog.OK);
        this.decode();
        gDialog.show();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.decode();
    }

    public void decode() {
        JaveSelection javeSelection = this.jave.getContentOfInterest();
        if (javeSelection == null) {
            this.tfDecoded.setText("");
            return;
        }
        String string = this.tfGradient.getText();
        CharacterPlate characterPlate = javeSelection.getContent();
        int n = characterPlate.getWidth();
        int n2 = characterPlate.getHeight();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        do {
            char c = '\u0000';
            int n5 = 0;
            while (n5 < 8) {
                boolean bl;
                boolean bl2 = bl = string.indexOf(characterPlate.get(n3, n4)) % 2 == 1;
                if (bl) {
                    c = (char)(c | 1 << n5);
                }
                if (++n3 >= n) {
                    n3 = 0;
                    ++n4;
                }
                ++n5;
            }
            if (Ascii.isAscii(c)) {
                stringBuffer.append(c);
                continue;
            }
            n4 = n2;
        } while (n4 < n2);
        this.tfDecoded.setText(stringBuffer.toString());
    }
}

