/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GGridLayout;
import de.jave.gui.GImageCanvas;
import de.jave.gui.GProgressDialog;
import de.jave.gui.GUpDownArrangement;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Document;
import de.jave.jave.DocumentListener;
import de.jave.jave.JMOVExporter;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveColorChooser;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveMovieExportThread;
import de.jave.jave.MovieBorder;
import de.jave.jave.Selection;
import de.jave.javeplayer.JaveMovieFile;
import de.jave.javeplayer.JaveMovieFrame;
import de.jave.javeplayer.JavePlayer;
import de.jave.util.Toolbox;
import gebhard.uielements.IntegerTextField;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Hashtable;

public class JaveMovieEditor
extends Frame
implements AdjustmentListener,
ActionListener,
WindowListener,
DocumentListener,
ItemListener,
MouseListener {
    protected static final String TITLE = "JavE Movie Editor";
    protected boolean enableThumbnailCache = true;
    protected int currentFrameIndex;
    protected JaveMovieFile movieFile;
    protected String currentDirectory;
    protected MenuItem miFrameDelete;
    protected MenuItem miFrameDuplicate;
    protected MenuItem miFrameMoveLeft;
    protected MenuItem miFrameMoveRight;
    protected MenuItem miFrameColor;
    protected MenuItem miFrameDuration;
    protected MenuItem miFramesDelete;
    protected MenuItem miFramesMoveLeft;
    protected MenuItem miFramesMoveRight;
    protected MenuItem miFramesSelectAll;
    protected MenuItem miFramesDeselectAll;
    protected MenuItem miFramesReverse;
    protected MenuItem miFramesColor;
    protected MenuItem miFramesDuration;
    protected GImageCanvas thumbLeft;
    protected GImageCanvas thumbLeft2;
    protected GImageCanvas thumbCenter;
    protected GImageCanvas thumbRight;
    protected GImageCanvas thumbRight2;
    protected int thumbNailCount = JaveGlobalRessources.getInifile().getInt("JMOV-Editor", "thumbnailcount", 5);
    protected Button bPrev;
    protected Button bNext;
    protected Button bShowInPlayer;
    protected MovieBorder movieBorder1;
    protected MovieBorder movieBorder2;
    protected Scrollbar frameScrollbar;
    protected MenuItem miNew;
    protected MenuItem miLoad;
    protected MenuItem miSave;
    protected MenuItem miSaveAs;
    protected MenuItem miExport;
    protected MenuItem miClose;
    protected MenuItem miExit;
    protected MenuItem miMovieInfo;
    protected MenuItem miRemoveBorders;
    protected MenuItem miStrip;
    protected MenuItem miDelete;
    protected MenuItem miDuplicate;
    protected MenuItem miMoveLeft;
    protected MenuItem miMoveRight;
    protected MenuItem miCopy;
    protected MenuItem miCut;
    protected MenuItem miPaste;
    protected Jave jave;
    protected Document document;
    protected List frameList;
    protected PopupMenu popupMenuFrame;
    protected PopupMenu popupMenuFrames;
    protected int lastSelectedFrameIndex = -1;

    public JaveMovieEditor(Jave jave) {
        this(jave, null);
    }

    public JaveMovieEditor(Jave jave, Document document) {
        super(TITLE);
        this.jave = jave;
        if (jave != null) {
            this.setIconImage(jave.getIconImage());
        }
        this.createGui();
        this.setMenuBar(this.createMenuBar());
        this.movieFile = this.createNewMovieFile();
        if (document != null) {
            JaveMovieFrame javeMovieFrame = new JaveMovieFrame();
            javeMovieFrame.setBackground(JaveGlobalRessources.colorPlateBackground);
            javeMovieFrame.setForeground(JaveGlobalRessources.colorText);
            javeMovieFrame.setDuration(66);
            CharacterPlate characterPlate = document.getContent();
            javeMovieFrame.setContent(JaveAsciiPacker.encode(characterPlate));
            if (jave.plate.hasSelection()) {
                Selection selection = jave.plate.getSelection();
                javeMovieFrame.setSelection(JaveAsciiPacker.encode(selection.getContent()));
                javeMovieFrame.setSelectionX(selection.getLocation().x);
                javeMovieFrame.setSelectionY(selection.getLocation().y);
            } else {
                javeMovieFrame.setSelection(null);
            }
            this.movieFile.add(javeMovieFrame);
            this.movieFile.setModified(false);
            this.updateFrameTitle();
        }
        this.setMovieFile(this.movieFile);
        this.addWindowListener(this);
        this.pack();
    }

    public void documentClosing() {
    }

    public void documentHiding() {
    }

    public void documentShowing() {
    }

    public void documentChanged() {
        this.updateContentForCurrentFrame();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setCurrentFrame(this.frameScrollbar.getValue());
    }

    protected JaveMovieFile createNewMovieFile() {
        JaveMovieFile javeMovieFile = new JaveMovieFile();
        javeMovieFile.setDate(Toolbox.getDateString());
        javeMovieFile.setSoftware("JavE 5.0 (Movie Editor)");
        javeMovieFile.setAuthor(JaveGlobalRessources.getInifile().getString("Personal", "name", ""));
        javeMovieFile.setEMail(JaveGlobalRessources.getInifile().getString("Personal", "mail", ""));
        javeMovieFile.setModified(false);
        return javeMovieFile;
    }

    protected final void createGui() {
        this.bPrev = new Button("<<");
        this.bPrev.addActionListener(this);
        this.bNext = new Button(">>");
        this.bNext.addActionListener(this);
        this.thumbLeft = new GImageCanvas();
        this.thumbCenter = new GImageCanvas();
        this.thumbRight = new GImageCanvas();
        this.thumbLeft.setMinimumSize(100, 60);
        this.thumbCenter.setMinimumSize(100, 60);
        this.thumbRight.setMinimumSize(100, 60);
        if (this.thumbNailCount == 5) {
            this.thumbLeft2 = new GImageCanvas();
            this.thumbRight2 = new GImageCanvas();
            this.thumbLeft2.setMinimumSize(100, 60);
            this.thumbRight2.setMinimumSize(100, 60);
        }
        this.movieBorder1 = new MovieBorder("");
        this.movieBorder2 = new MovieBorder("");
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 2, 2));
        if (this.thumbNailCount == 5) {
            panel.add(this.thumbLeft2);
        }
        panel.add(this.thumbLeft);
        panel.add(this.thumbCenter);
        panel.add(this.thumbRight);
        if (this.thumbNailCount == 5) {
            panel.add(this.thumbRight2);
        }
        panel.setBackground(Color.black);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.bPrev, "West");
        panel2.add((Component)this.bNext, "East");
        panel2.add((Component)panel, "Center");
        panel2.add((Component)this.movieBorder1, "North");
        panel2.add((Component)this.movieBorder2, "South");
        this.frameList = new List(6, true);
        this.frameList.addActionListener(this);
        this.frameList.addItemListener(this);
        this.bShowInPlayer = new Button("Show in Player");
        this.bShowInPlayer.addActionListener(this);
        this.frameScrollbar = new Scrollbar(0, 0, 1, 0, 0);
        this.frameScrollbar.addAdjustmentListener(this);
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        panel3.add((Component)panel2, "Center");
        panel3.add((Component)this.frameScrollbar, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)panel3, "East");
        this.add((Component)this.frameList, "Center");
        this.add((Component)this.bShowInPlayer, "South");
        this.thumbLeft.addMouseListener(this);
        this.thumbRight.addMouseListener(this);
        if (this.thumbLeft2 != null) {
            this.thumbLeft2.addMouseListener(this);
        }
        if (this.thumbRight2 != null) {
            this.thumbRight2.addMouseListener(this);
        }
        this.popupMenuFrame = new PopupMenu();
        this.miFrameDelete = new MenuItem("Delete");
        this.miFrameDuplicate = new MenuItem("Duplicate");
        this.miFrameMoveLeft = new MenuItem("<< Move left");
        this.miFrameMoveRight = new MenuItem("Move right >>");
        this.miFrameColor = new MenuItem("Color");
        this.miFrameDuration = new MenuItem("Duration");
        this.miFrameDelete.addActionListener(this);
        this.miFrameDuplicate.addActionListener(this);
        this.miFrameMoveLeft.addActionListener(this);
        this.miFrameMoveRight.addActionListener(this);
        this.miFrameColor.addActionListener(this);
        this.miFrameDuration.addActionListener(this);
        this.popupMenuFrame.add(this.miFrameDelete);
        this.popupMenuFrame.add(this.miFrameDuplicate);
        this.popupMenuFrame.addSeparator();
        this.popupMenuFrame.add(this.miFrameMoveLeft);
        this.popupMenuFrame.add(this.miFrameMoveRight);
        this.popupMenuFrame.addSeparator();
        this.popupMenuFrame.add(this.miFrameColor);
        this.popupMenuFrame.add(this.miFrameDuration);
        this.thumbCenter.add(this.popupMenuFrame);
        this.thumbCenter.addMouseListener(this);
        this.popupMenuFrames = new PopupMenu();
        this.miFramesDelete = new MenuItem("Delete");
        this.miFramesMoveLeft = new MenuItem("<< Move left");
        this.miFramesMoveRight = new MenuItem("Move right >>");
        this.miFramesSelectAll = new MenuItem("Select all");
        this.miFramesDeselectAll = new MenuItem("Unselect all");
        this.miFramesReverse = new MenuItem("Reverse");
        this.miFramesColor = new MenuItem("Color");
        this.miFramesDuration = new MenuItem("Duration");
        this.miFramesDelete.addActionListener(this);
        this.miFramesMoveLeft.addActionListener(this);
        this.miFramesMoveRight.addActionListener(this);
        this.miFramesSelectAll.addActionListener(this);
        this.miFramesDeselectAll.addActionListener(this);
        this.miFramesReverse.addActionListener(this);
        this.miFramesColor.addActionListener(this);
        this.miFramesDuration.addActionListener(this);
        this.popupMenuFrames.add(this.miFramesDelete);
        this.popupMenuFrames.add(this.miFramesReverse);
        this.popupMenuFrames.addSeparator();
        this.popupMenuFrames.add(this.miFramesMoveLeft);
        this.popupMenuFrames.add(this.miFramesMoveRight);
        this.popupMenuFrames.addSeparator();
        this.popupMenuFrames.add(this.miFramesSelectAll);
        this.popupMenuFrames.add(this.miFramesDeselectAll);
        this.popupMenuFrames.addSeparator();
        this.popupMenuFrames.add(this.miFramesColor);
        this.popupMenuFrames.add(this.miFramesDuration);
        this.frameList.add(this.popupMenuFrames);
        this.frameList.addMouseListener(this);
    }

    protected void doMovieInfo() {
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Movie Information");
        gBorderedPanel.setLayout(new GGridLayout(0, 2, 1, 1));
        gBorderedPanel.add(new Label("Title:", 2));
        TextField textField = new TextField(22);
        gBorderedPanel.add(textField);
        gBorderedPanel.add(new Label("Date:", 2));
        TextField textField2 = new TextField(22);
        gBorderedPanel.add(textField2);
        gBorderedPanel.add(new Label("Author:", 2));
        TextField textField3 = new TextField(22);
        gBorderedPanel.add(textField3);
        gBorderedPanel.add(new Label("EMail:", 2));
        TextField textField4 = new TextField(22);
        gBorderedPanel.add(textField4);
        gBorderedPanel.add(new Label("Software:", 2));
        TextField textField5 = new TextField(22);
        gBorderedPanel.add(textField5);
        textField.setText(this.movieFile.getTitle());
        textField2.setText(this.movieFile.getDate());
        textField3.setText(this.movieFile.getAuthor());
        textField4.setText(this.movieFile.getEMail());
        textField5.setText(this.movieFile.getSoftware());
        GDialog gDialog = new GDialog((Frame)this, TITLE, (Component)gBorderedPanel, GDialog.OK_CANCEL);
        gDialog.show();
        if (gDialog.getAnswer() == 0) {
            this.movieFile.setTitle(textField.getText());
            this.movieFile.setDate(textField2.getText());
            this.movieFile.setAuthor(textField3.getText());
            this.movieFile.setEMail(textField4.getText());
            this.movieFile.setSoftware(textField5.getText());
            this.updateFrameTitle();
        }
    }

    protected void doFrameDurations(int[] nArray) {
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Duration");
        IntegerTextField integerTextField = new IntegerTextField(this.movieFile.getFrame(nArray[0]).getDuration(), 0, 60000);
        gBorderedPanel.add(new GUpDownArrangement(integerTextField));
        gBorderedPanel.add(new Label("ms", 0));
        GDialog gDialog = new GDialog((Frame)this, TITLE, (Component)gBorderedPanel, GDialog.OK_CANCEL);
        gDialog.show();
        if (gDialog.getAnswer() == 0) {
            int n = integerTextField.getValue();
            int n2 = 0;
            while (n2 < nArray.length) {
                this.movieFile.getFrame(nArray[n2]).setDuration(n);
                ++n2;
            }
            this.movieFile.setModified(false);
            this.updateFrameTitle();
        }
    }

    protected final MenuBar createMenuBar() {
        this.miNew = this.createMenuItem("New", 110);
        this.miLoad = this.createMenuItem("Open", 111);
        this.miSave = this.createMenuItem("Save", 115);
        this.miSaveAs = this.createMenuItem("Save As...");
        this.miExport = this.createMenuItem("Export");
        this.miClose = this.createMenuItem("Close", 119);
        this.miExit = this.createMenuItem("Exit", 120);
        this.miDelete = this.createMenuItem("Delete");
        this.miDuplicate = this.createMenuItem("Duplicate");
        this.miMoveLeft = this.createMenuItem("Move Left");
        this.miMoveRight = this.createMenuItem("Move Right");
        Menu menu = new Menu("File");
        menu.add(this.miNew);
        menu.add(this.miLoad);
        menu.addSeparator();
        menu.add(this.miSave);
        menu.add(this.miSaveAs);
        menu.add(this.miClose);
        menu.addSeparator();
        menu.add(this.miExport);
        menu.addSeparator();
        menu.add(this.miExit);
        this.miStrip = this.createMenuItem("Strip non-movie information");
        this.miRemoveBorders = this.createMenuItem("Remove empty borders");
        this.miMovieInfo = this.createMenuItem("Information");
        Menu menu2 = new Menu("Movie");
        menu2.add(this.miStrip);
        menu2.addSeparator();
        menu2.add(this.miMovieInfo);
        Menu menu3 = new Menu("Frame");
        menu3.add(this.miDelete);
        menu3.add(this.miDuplicate);
        menu3.addSeparator();
        menu3.add(this.miMoveLeft);
        menu3.add(this.miMoveRight);
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.add(menu3);
        return menuBar;
    }

    protected final MenuItem createMenuItem(String string, int n) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setShortcut(new MenuShortcut(n));
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected final MenuItem createMenuItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void updateFrameTitle() {
        String string = this.movieFile.getFileName();
        if (string == null) {
            string = "untitled";
        }
        if (this.movieFile.isModified()) {
            string = string + " *";
        }
        this.setTitle("JavE Movie Editor - [" + string + "]");
    }

    protected JaveMovieFrame getFrame(int n) {
        if (n < 0 || n >= this.movieFile.getFrameCount()) {
            return null;
        }
        return this.movieFile.getFrame(n);
    }

    protected void buildFrameList() {
        this.frameList.removeAll();
        int n = 0;
        while (n < this.movieFile.getFrameCount()) {
            this.addToFrameList(n);
            ++n;
        }
        this.frameList.makeVisible(this.currentFrameIndex);
    }

    protected void addToFrameList(int n) {
        String string = this.movieFile.getFrame(n).getTool();
        if (string == null) {
            string = "frame " + (n + 1);
        }
        this.frameList.add(n + 1 + ": " + string, n);
    }

    protected void setCurrentFrame(int n) {
        Object object;
        Hashtable<Integer, Object> hashtable = null;
        if (this.enableThumbnailCache) {
            hashtable = new Hashtable<Integer, Object>(11);
            object = null;
            if (this.thumbLeft2 != null && (object = this.thumbLeft2.getImage()) != null) {
                hashtable.put(new Integer(this.currentFrameIndex - 2), object);
            }
            if ((object = this.thumbLeft.getImage()) != null) {
                hashtable.put(new Integer(this.currentFrameIndex - 1), object);
            }
            if ((object = this.thumbCenter.getImage()) != null) {
                hashtable.put(new Integer(this.currentFrameIndex), object);
            }
            if ((object = this.thumbRight.getImage()) != null) {
                hashtable.put(new Integer(this.currentFrameIndex + 1), object);
            }
            if (this.thumbRight2 != null && (object = this.thumbRight2.getImage()) != null) {
                hashtable.put(new Integer(this.currentFrameIndex + 2), object);
            }
        }
        this.enableThumbnailCache = true;
        this.currentFrameIndex = n;
        this.frameScrollbar.setMaximum(this.movieFile.getFrameCount());
        this.frameScrollbar.setValue(this.currentFrameIndex);
        object = null;
        object = this.movieFile.getFrameCount() == 0 ? "--" : n + 1 + " / " + this.movieFile.getFrameCount();
        this.movieBorder1.setLabel((String)object);
        this.movieBorder2.setLabel((String)object);
        JaveMovieFrame javeMovieFrame = null;
        if (this.thumbLeft2 != null) {
            javeMovieFrame = this.getFrame(n - 2);
        }
        JaveMovieFrame javeMovieFrame2 = this.getFrame(n - 1);
        JaveMovieFrame javeMovieFrame3 = this.getFrame(n);
        JaveMovieFrame javeMovieFrame4 = this.getFrame(n + 1);
        JaveMovieFrame javeMovieFrame5 = null;
        if (this.thumbRight2 != null) {
            javeMovieFrame5 = this.getFrame(n + 2);
        }
        if (javeMovieFrame3 != null) {
            Document document = this.document;
            this.document = this.jave.pasteAsNewDocument(new CharacterPlate(javeMovieFrame3.getContent()), "JMOV Editor frame: " + (n + 1));
            this.document.setMovieDocument(true);
            char[][] cArray = javeMovieFrame3.getSelection();
            if (cArray != null) {
                this.jave.pasteAsNewSelection(new CharacterPlate(cArray), javeMovieFrame3.getSelectionX(), javeMovieFrame3.getSelectionY());
            }
            this.document.setModified(false);
            this.document.addDocumentListener(this);
            if (document != null) {
                document.removeDocumentListener(this);
                this.jave.close(document);
            }
            this.jave.updateStatusFile();
        }
        if (this.thumbLeft2 != null) {
            this.setThumb(this.thumbLeft2, javeMovieFrame, this.currentFrameIndex - 2, hashtable);
        }
        this.setThumb(this.thumbLeft, javeMovieFrame2, n - 1, hashtable);
        this.setThumb(this.thumbCenter, javeMovieFrame3, n, hashtable);
        this.setThumb(this.thumbRight, javeMovieFrame4, n + 1, hashtable);
        if (this.thumbRight2 != null) {
            this.setThumb(this.thumbRight2, javeMovieFrame5, n + 2, hashtable);
        }
        this.miFrameMoveLeft.setEnabled(this.currentFrameIndex > 0);
        this.miMoveLeft.setEnabled(this.currentFrameIndex > 0);
        this.miFrameMoveRight.setEnabled(this.currentFrameIndex < this.movieFile.getFrameCount() - 1);
        this.miMoveRight.setEnabled(this.currentFrameIndex < this.movieFile.getFrameCount() - 1);
    }

    protected void refresh() {
        this.setCurrentFrame(this.currentFrameIndex);
    }

    protected void updateContentForCurrentFrame() {
        if (this.document != null) {
            CharacterPlate characterPlate = this.document.getContent();
            JaveMovieFrame javeMovieFrame = this.getCurrentFrame();
            javeMovieFrame.setContent(JaveAsciiPacker.encode(characterPlate));
            if (this.jave.plate.hasSelection()) {
                Selection selection = this.jave.plate.getSelection();
                javeMovieFrame.setSelection(JaveAsciiPacker.encode(selection.getContent()));
                javeMovieFrame.setSelectionX(selection.getLocation().x);
                javeMovieFrame.setSelectionY(selection.getLocation().y);
            } else {
                javeMovieFrame.setSelection(null);
            }
            this.setThumb(this.thumbCenter, javeMovieFrame, this.currentFrameIndex, null);
        }
    }

    protected void setThumb(GImageCanvas gImageCanvas, JaveMovieFrame javeMovieFrame, int n, Hashtable hashtable) {
        if (javeMovieFrame == null) {
            gImageCanvas.setImage(null);
            gImageCanvas.setSelected(false);
        } else {
            boolean bl = false;
            if (n >= 0 && n < this.movieFile.getFrameCount()) {
                bl = this.frameList.isIndexSelected(n);
            }
            gImageCanvas.setSelected(bl);
            if (hashtable != null && hashtable.containsKey(new Integer(n))) {
                gImageCanvas.setImage((Image)hashtable.get(new Integer(n)));
                return;
            }
            char[][] cArray = javeMovieFrame.getContent();
            CharacterPlate characterPlate = new CharacterPlate(cArray);
            char[][] cArray2 = javeMovieFrame.getSelection();
            if (cArray2 != null) {
                new CharacterPlate(cArray2).pasteInto(characterPlate, javeMovieFrame.getSelectionX(), javeMovieFrame.getSelectionY());
            }
            boolean bl2 = false;
            Color color = javeMovieFrame.getBackground();
            Color color2 = javeMovieFrame.getForeground();
            Image image = this.createImage(AsciiToThumbnailConverter.ascii2ImageQuick(characterPlate, 2, color, color2));
            gImageCanvas.setProportion(0.67);
            gImageCanvas.setImage(image);
        }
    }

    public void doPrev() {
        if (this.currentFrameIndex > 0) {
            this.setCurrentFrame(this.currentFrameIndex - 1);
        }
    }

    public void doNext() {
        if (this.currentFrameIndex < this.movieFile.getFrameCount() - 1) {
            this.setCurrentFrame(this.currentFrameIndex + 1);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.frameList) {
            Object object2 = itemEvent.getItem();
            this.lastSelectedFrameIndex = object2 instanceof Number ? (int)((Number)object2).doubleValue() : -1;
            this.updateThumbnailSelection();
            return;
        }
    }

    protected void updateThumbnailSelection() {
        this.thumbCenter.setSelected(this.frameList.isIndexSelected(this.currentFrameIndex));
        if (this.currentFrameIndex > 0) {
            this.thumbLeft.setSelected(this.frameList.isIndexSelected(this.currentFrameIndex - 1));
        }
        if (this.currentFrameIndex > 1 && this.thumbLeft2 != null) {
            this.thumbLeft2.setSelected(this.frameList.isIndexSelected(this.currentFrameIndex - 2));
        }
        if (this.currentFrameIndex + 1 < this.movieFile.getFrameCount()) {
            this.thumbRight.setSelected(this.frameList.isIndexSelected(this.currentFrameIndex + 1));
        }
        if (this.currentFrameIndex + 2 < this.movieFile.getFrameCount() && this.thumbRight2 != null) {
            this.thumbRight2.setSelected(this.frameList.isIndexSelected(this.currentFrameIndex + 2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bPrev) {
            this.doPrev();
            return;
        }
        if (object == this.bNext) {
            this.doNext();
            return;
        }
        if (object == this.frameList) {
            int n = this.frameList.getSelectedIndex();
            if (n == -1) {
                n = this.lastSelectedFrameIndex;
            }
            if (n != -1) {
                this.setCurrentFrame(n);
            }
            return;
        }
        if (object == this.bShowInPlayer) {
            JavePlayer javePlayer = new JavePlayer();
            javePlayer.setMovieFile(this.movieFile);
            GBorderedPanel gBorderedPanel = new GBorderedPanel(1);
            gBorderedPanel.add(javePlayer);
            GDialog gDialog = new GDialog((Frame)this, "JMOV player", (Component)gBorderedPanel, GDialog.CLOSE);
            gDialog.show();
            javePlayer = null;
            return;
        }
        if (object == this.miFrameDuration) {
            this.doFrameDurations(new int[]{this.currentFrameIndex});
            return;
        }
        if (object == this.miFramesDuration) {
            int[] nArray = this.frameList.getSelectedIndexes();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.doFrameDurations(nArray);
            return;
        }
        if (object == this.miFrameColor) {
            JaveColorChooser javeColorChooser = new JaveColorChooser();
            javeColorChooser.setSelectedColors(this.movieFile.getFrame(this.currentFrameIndex).getForeground(), this.movieFile.getFrame(this.currentFrameIndex).getBackground());
            GDialog gDialog = new GDialog((Frame)this, "Choose colors", (Component)javeColorChooser, GDialog.OK_CANCEL);
            gDialog.show();
            if (gDialog.getAnswer() == 0) {
                this.movieFile.getFrame(this.currentFrameIndex).setBackground(javeColorChooser.getSelectedBackgroundColor());
                this.movieFile.getFrame(this.currentFrameIndex).setForeground(javeColorChooser.getSelectedForegroundColor());
                this.enableThumbnailCache = false;
                this.refresh();
                this.updateFrameTitle();
            }
            return;
        }
        if (object == this.miFramesColor) {
            int[] nArray = this.frameList.getSelectedIndexes();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            JaveColorChooser javeColorChooser = new JaveColorChooser();
            GDialog gDialog = new GDialog((Frame)this, "Choose colors", (Component)javeColorChooser, GDialog.OK_CANCEL);
            gDialog.show();
            return;
        }
        if (object == this.miDelete || object == this.miFrameDelete) {
            this.doDeleteFrame();
            return;
        }
        if (object == this.miFramesDelete) {
            int[] nArray = this.frameList.getSelectedIndexes();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int n = nArray.length - 1;
            while (n >= 0) {
                this.movieFile.deleteFrame(nArray[n]);
                --n;
            }
            this.buildFrameList();
            if (this.currentFrameIndex >= this.movieFile.getFrameCount()) {
                this.setCurrentFrame(this.movieFile.getFrameCount() - 1);
            } else if (this.movieFile.getFrameCount() == 0) {
                this.setCurrentFrame(0);
            } else {
                this.refresh();
            }
            return;
        }
        if (object == this.miFramesReverse) {
            int[] nArray = this.frameList.getSelectedIndexes();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int n = nArray[0];
            int n2 = nArray[nArray.length - 1];
            this.doFramesRevert(n, n2);
        }
        if (object == this.miDuplicate || object == this.miFrameDuplicate) {
            this.doDublicateFrame();
            return;
        }
        if (object == this.miMoveLeft || object == this.miFrameMoveLeft) {
            this.doMoveFrameLeft();
            return;
        }
        if (object == this.miMoveRight || object == this.miFrameMoveRight) {
            this.doMoveFrameRight();
            return;
        }
        if (object == this.miFramesSelectAll) {
            int n = 0;
            while (n < this.frameList.getItemCount()) {
                this.frameList.select(n);
                ++n;
            }
            this.updateThumbnailSelection();
            return;
        }
        if (object == this.miFramesDeselectAll) {
            int n = 0;
            while (n < this.frameList.getItemCount()) {
                this.frameList.deselect(n);
                ++n;
            }
            this.updateThumbnailSelection();
            return;
        }
        if (object == this.miMovieInfo) {
            this.doMovieInfo();
            return;
        }
        if (object == this.miStrip) {
            this.doStrip();
            return;
        }
        if (object == this.miRemoveBorders) {
            this.doRemoveBorders();
            return;
        }
        if (object == this.miNew) {
            this.doNew();
            return;
        }
        if (object == this.miLoad) {
            this.doOpen();
            return;
        }
        if (object == this.miSave) {
            this.doSave();
            return;
        }
        if (object == this.miExport) {
            this.doExport();
            return;
        }
        if (object == this.miSaveAs) {
            this.doSaveAs();
            return;
        }
        if (object == this.miClose) {
            this.doNew();
            return;
        }
        if (object == this.miExit) {
            this.doExit();
            return;
        }
        System.err.println("Kein Listener-methode fuer " + object + "!");
    }

    protected void doFramesRevert(int n, int n2) {
        int n3 = 0;
        while (n3 < (n2 - n) / 2) {
            JaveMovieFrame javeMovieFrame = this.movieFile.getFrame(n + n3);
            this.movieFile.setFrameAt(this.movieFile.getFrame(n2 - n3), n + n3);
            this.movieFile.setFrameAt(javeMovieFrame, n2 - n3);
            ++n3;
        }
        this.buildFrameList();
        this.enableThumbnailCache = false;
        this.refresh();
    }

    protected void doRemoveBorders() {
        Dimension dimension = new Dimension(0, 0);
        int n = this.movieFile.getFrameCount();
        JaveMovieFrame javeMovieFrame = null;
        CharacterPlate characterPlate = null;
        int n2 = 0;
        while (n2 < n) {
            javeMovieFrame = this.movieFile.getFrame(n2);
            characterPlate = new CharacterPlate(javeMovieFrame.getContent());
            if (characterPlate.getWidth() > dimension.width) {
                dimension.width = characterPlate.getWidth();
            }
            if (characterPlate.getHeight() > dimension.height) {
                dimension.height = characterPlate.getHeight();
            }
            ++n2;
        }
        System.err.println("Max. Groesse:" + dimension);
        Insets insets = null;
        int n3 = 0;
        while (n3 < n) {
            javeMovieFrame = this.getFrame(n3);
            CharacterPlate characterPlate2 = new CharacterPlate(javeMovieFrame.getContent());
            Insets insets2 = characterPlate2.getEmptyInsets();
            char[][] cArray = javeMovieFrame.getSelection();
            if (cArray != null) {
                CharacterPlate characterPlate3 = new CharacterPlate(cArray);
                int n4 = javeMovieFrame.getSelectionX();
                int n5 = javeMovieFrame.getSelectionY();
                int n6 = characterPlate3.getWidth();
                int n7 = characterPlate3.getHeight();
                if (n4 < insets2.left) {
                    insets2.left = n4;
                }
                if (n5 < insets2.top) {
                    insets2.top = n5;
                }
                if (characterPlate2.getWidth() - insets2.right < n4 + n6) {
                    insets2.right = characterPlate2.getWidth() - n4 - n6;
                }
                if (characterPlate2.getHeight() - insets2.bottom < n5 + n7) {
                    insets2.bottom = characterPlate2.getHeight() - n5 - n7;
                }
            }
            if (characterPlate2.getWidth() < dimension.width) {
                int n8 = dimension.width - characterPlate2.getWidth();
                insets2.left += n8 / 2;
                insets2.right += n8 - n8 / 2;
            }
            if (characterPlate2.getHeight() < dimension.height) {
                int n9 = dimension.height - characterPlate2.getHeight();
                insets2.top += n9 / 2;
                insets2.bottom += n9 - n9 / 2;
            }
            if (insets == null) {
                insets = insets2;
            } else {
                if (insets2.bottom < insets.bottom) {
                    insets.bottom = insets2.bottom;
                }
                if (insets2.top < insets.top) {
                    insets.top = insets2.top;
                }
                if (insets2.left < insets.left) {
                    insets.left = insets2.left;
                }
                if (insets2.right < insets.right) {
                    insets.right = insets2.right;
                }
            }
            ++n3;
        }
        if (insets == null) {
            return;
        }
        System.err.println("Empty Insets: " + insets);
        if (insets.left == 0 && insets.right == 0 && insets.bottom == 0 && insets.top == 0) {
            new GDialog((Frame)this, "Remove borders", "There are no empty borders to remove.", 3).show();
            return;
        }
        if (insets.left == dimension.width) {
            new GDialog((Frame)this, "Remove borders", "The movie is empty.", 3).show();
            return;
        }
    }

    protected void doStrip() {
        GDialog gDialog = new GDialog((Frame)this, "Strip non-movie information", "This will remove all selections, cursor positions\nand tool information from the current movie file.\nDo you want to continue?", GDialog.YES_NO_CANCEL, 3);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n != 0) {
            return;
        }
        int n2 = this.movieFile.getFrameCount() - 1;
        while (n2 >= 0) {
            JaveMovieFrame javeMovieFrame = this.getFrame(n2);
            char[][] cArray = javeMovieFrame.getSelection();
            if (cArray != null) {
                CharacterPlate characterPlate = new CharacterPlate(cArray);
                CharacterPlate characterPlate2 = new CharacterPlate(javeMovieFrame.getContent());
                characterPlate.pasteIntoForce(characterPlate2, javeMovieFrame.getSelectionX(), javeMovieFrame.getSelectionY());
                javeMovieFrame.setSelection(null);
            }
            javeMovieFrame.setAction(null);
            javeMovieFrame.setTool(null);
            javeMovieFrame.setCursorX(-1);
            javeMovieFrame.setCursorY(-1);
            javeMovieFrame.setSelectionX(-1);
            javeMovieFrame.setSelectionY(-1);
            --n2;
        }
        this.movieFile.setModified(true);
        this.refresh();
    }

    protected void doDeleteFrame() {
        if (this.movieFile.getFrameCount() == 1) {
            new GDialog((Frame)this, "Delete frame", "There is only one frame. It can not be deleted.", 3).show();
            return;
        }
        if (this.currentFrameIndex < 0 || this.currentFrameIndex >= this.movieFile.getFrameCount()) {
            return;
        }
        this.movieFile.deleteFrame(this.currentFrameIndex);
        this.buildFrameList();
        if (this.currentFrameIndex == this.movieFile.getFrameCount()) {
            this.doPrev();
        }
        if (this.movieFile.getFrameCount() == 0) {
            this.setCurrentFrame(0);
        }
        this.refresh();
    }

    protected void doDublicateFrame() {
        JaveMovieFrame javeMovieFrame = this.getCurrentFrame();
        if (javeMovieFrame == null) {
            return;
        }
        JaveMovieFrame javeMovieFrame2 = javeMovieFrame.duplicate();
        this.movieFile.insertFrame(javeMovieFrame2, this.currentFrameIndex + 1);
        this.buildFrameList();
        this.enableThumbnailCache = false;
        this.doNext();
    }

    protected void doMoveFrameLeft() {
        if (this.currentFrameIndex == 0) {
            return;
        }
        this.movieFile.moveFrameLeft(this.currentFrameIndex);
        this.frameList.remove(this.currentFrameIndex - 1);
        this.frameList.remove(this.currentFrameIndex - 1);
        this.addToFrameList(this.currentFrameIndex - 1);
        this.addToFrameList(this.currentFrameIndex);
        this.enableThumbnailCache = false;
        this.setCurrentFrame(this.currentFrameIndex - 1);
        this.refresh();
    }

    protected void doMoveFrameRight() {
        if (this.currentFrameIndex >= this.movieFile.getFrameCount() - 1) {
            return;
        }
        this.movieFile.moveFrameRight(this.currentFrameIndex);
        this.frameList.remove(this.currentFrameIndex);
        this.frameList.remove(this.currentFrameIndex);
        this.addToFrameList(this.currentFrameIndex);
        this.addToFrameList(this.currentFrameIndex + 1);
        this.enableThumbnailCache = false;
        this.setCurrentFrame(this.currentFrameIndex + 1);
        this.refresh();
    }

    protected void doFrameCopy() {
    }

    protected void doFrameCut() {
    }

    protected void doFramePaste() {
    }

    protected void doNew() {
        if (!this.doClose()) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentListener(this);
            this.jave.close(this.document);
            this.document = null;
        }
        JaveMovieFile javeMovieFile = this.createNewMovieFile();
        this.jave.doNew();
        JaveMovieFrame javeMovieFrame = new JaveMovieFrame();
        javeMovieFrame.setDuration(66);
        CharacterPlate characterPlate = this.jave.plate.getDocument().getContent();
        javeMovieFrame.setContent(JaveAsciiPacker.encode(characterPlate));
        javeMovieFrame.setBackground(JaveGlobalRessources.colorPlateBackground);
        javeMovieFrame.setForeground(JaveGlobalRessources.colorText);
        if (this.jave.plate.hasSelection()) {
            Selection selection = this.jave.plate.getSelection();
            javeMovieFrame.setSelection(JaveAsciiPacker.encode(selection.getContent()));
            javeMovieFrame.setSelectionX(selection.getLocation().x);
            javeMovieFrame.setSelectionY(selection.getLocation().y);
        } else {
            javeMovieFrame.setSelection(null);
        }
        javeMovieFile.add(javeMovieFrame);
        this.setMovieFile(javeMovieFile);
    }

    protected void doOpen() {
        if (!this.doClose()) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Open JavE Movie", 0);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.setFile("*.jmov");
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        this.open(string2, string);
    }

    protected boolean open(String string, String string2) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        File file = new File(string + string2);
        JaveMovieFile javeMovieFile = new JaveMovieFile(string + string2);
        try {
            javeMovieFile.load();
        }
        catch (Exception exception) {
            new GErrorDialog((Frame)this, TITLE, "Error loading file", exception).show();
            return false;
        }
        javeMovieFile.setModified(false);
        this.setMovieFile(javeMovieFile);
        this.currentDirectory = string;
        JaveGlobalRessources.getRecentFileList().add(file);
        return true;
    }

    public void setMovieFile(JaveMovieFile javeMovieFile) {
        this.movieFile = javeMovieFile;
        this.buildFrameList();
        this.enableThumbnailCache = false;
        this.setCurrentFrame(0);
        this.refresh();
        this.updateFrameTitle();
    }

    protected boolean doSave() {
        if (this.movieFile.getFileName() == null) {
            return this.doSaveAs();
        }
        try {
            this.movieFile.save();
            JaveGlobalRessources.getRecentFileList().add(new File(this.movieFile.getFileName()));
            this.updateFrameTitle();
            return true;
        }
        catch (Exception exception) {
            new GErrorDialog((Frame)this, TITLE, "Error saving file", exception).show();
            return false;
        }
    }

    protected boolean doSaveAs() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save JavE Movie File", 1);
        fileDialog.setFile("*.jmov");
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return false;
        }
        this.currentDirectory = string2;
        this.movieFile.setFileName(string2 + string);
        return this.doSave();
    }

    protected void doExport() {
        JMOVExporter jMOVExporter = new JMOVExporter();
        if (!jMOVExporter.showOptionsDialogs(this, TITLE)) {
            return;
        }
        jMOVExporter.setEstimatedFileCount(this.movieFile.getFrameCount());
        jMOVExporter.setTitle(this.movieFile.getTitle());
        GProgressDialog gProgressDialog = new GProgressDialog((Frame)this, TITLE, "Exporting " + this.movieFile.getFrameCount() + " frames", true);
        JaveMovieExportThread javeMovieExportThread = new JaveMovieExportThread(this, this.movieFile, jMOVExporter, gProgressDialog);
        gProgressDialog.addCancelListener(javeMovieExportThread);
        gProgressDialog.show();
        javeMovieExportThread.start();
    }

    protected boolean doClose() {
        if (!this.movieFile.isModified()) {
            return true;
        }
        String string = "The movie has been modified.\nDo you want to save changes?";
        GDialog gDialog = new GDialog((Frame)this, TITLE, string, GDialog.YES_NO_CANCEL, 2);
        gDialog.show();
        int n = gDialog.getAnswer();
        if (n == -1 || n == 2) {
            return false;
        }
        if (n == 0) {
            return this.doSave();
        }
        return true;
    }

    protected boolean doExit() {
        if (!this.doClose()) {
            return false;
        }
        if (this.jave == null) {
            System.exit(0);
        } else {
            this.dispose();
        }
        if (this.document != null) {
            this.document.setMovieDocument(false);
            this.document = null;
        }
        return true;
    }

    protected JaveMovieFrame getCurrentFrame() {
        if (this.currentFrameIndex < 0 || this.currentFrameIndex >= this.movieFile.getFrameCount()) {
            return null;
        }
        return this.getFrame(this.currentFrameIndex);
    }

    public static void main(String[] stringArray) {
        JaveMovieEditor javeMovieEditor = new JaveMovieEditor(null);
        javeMovieEditor.open("e:\\test\\sw\\", "sw1.jmov");
    }

    public static final void convertAsciimationToJMOV(String string, String string2) {
        try {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (n2 < string3.length()) {
                    n2 = string3.length();
                }
                if (bl) continue;
                if (n > 0 && string3.length() > 0 && string3.charAt(0) >= '0' && string3.charAt(0) <= '9') {
                    bl = true;
                    continue;
                }
                ++n;
            }
            bufferedReader.close();
            if (--n < 1) {
                throw new RuntimeException("File " + file.getAbsolutePath() + " is of unsupported format!");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            File file2 = new File(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            bufferedWriter.write("*:JavE 5.0 MovieEditor - Asciimation to JMOV Converter");
            bufferedWriter.newLine();
            bufferedWriter.write("#: Original file: " + file.getName());
            bufferedWriter.newLine();
            bufferedWriter.write("C:#000000 #FFFFFF");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            int n3 = -1;
            string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() < 1 || string3.charAt(0) == '\u00ff') break;
                int n4 = Integer.parseInt(string3);
                String[] stringArray = new String[n];
                int n5 = 0;
                while (n5 < n) {
                    stringArray[n5] = bufferedReader.readLine();
                    ++n5;
                }
                while (stringArray[0].length() < n2) {
                    stringArray[0] = stringArray[0] + " ";
                }
                CharacterPlate characterPlate = new CharacterPlate(stringArray);
                bufferedWriter.write("J:");
                bufferedWriter.write(JaveAsciiPacker.encodeOptimized(characterPlate));
                bufferedWriter.newLine();
                int n6 = 66 * n4;
                if (n6 != n3) {
                    bufferedWriter.write("+:");
                    bufferedWriter.write(String.valueOf(n6));
                    bufferedWriter.newLine();
                    n3 = n6;
                }
                bufferedWriter.newLine();
            }
            bufferedReader.close();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.doExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
            if (object == this.thumbCenter) {
                this.popupMenuFrame.show(this.thumbCenter, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
            if (object == this.frameList) {
                this.popupMenuFrames.show(this.frameList, mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }
        if (!mouseEvent.isMetaDown()) {
            if (object == this.thumbCenter) {
                boolean bl = !this.frameList.isIndexSelected(this.currentFrameIndex);
                this.thumbCenter.setSelected(bl);
                if (bl) {
                    this.frameList.select(this.currentFrameIndex);
                } else {
                    this.frameList.deselect(this.currentFrameIndex);
                }
                return;
            }
            if (object == this.thumbLeft) {
                boolean bl = !this.frameList.isIndexSelected(this.currentFrameIndex - 1);
                this.thumbLeft.setSelected(bl);
                if (bl) {
                    this.frameList.select(this.currentFrameIndex - 1);
                } else {
                    this.frameList.deselect(this.currentFrameIndex - 1);
                }
                return;
            }
            if (object == this.thumbLeft2) {
                boolean bl = !this.frameList.isIndexSelected(this.currentFrameIndex - 2);
                this.thumbLeft2.setSelected(bl);
                if (bl) {
                    this.frameList.select(this.currentFrameIndex - 2);
                } else {
                    this.frameList.deselect(this.currentFrameIndex - 2);
                }
                return;
            }
            if (object == this.thumbRight) {
                boolean bl = !this.frameList.isIndexSelected(this.currentFrameIndex + 1);
                this.thumbRight.setSelected(bl);
                if (bl) {
                    this.frameList.select(this.currentFrameIndex + 1);
                } else {
                    this.frameList.deselect(this.currentFrameIndex + 1);
                }
                return;
            }
            if (object == this.thumbRight2) {
                boolean bl = !this.frameList.isIndexSelected(this.currentFrameIndex + 2);
                this.thumbRight2.setSelected(bl);
                if (bl) {
                    this.frameList.select(this.currentFrameIndex + 2);
                } else {
                    this.frameList.deselect(this.currentFrameIndex + 2);
                }
                return;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

