/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.Tooltips;
import de.jave.internet.InternetTools;
import de.jave.io.CodeBaseTool;
import de.jave.io.IOTools;
import de.jave.jave.JaveImages;
import de.jave.util.Inifile;
import de.jave.util.RecentFileList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;

public class JaveGlobalRessources {
    public static boolean debug = false;
    public static boolean cursorBlink = true;
    public static String codeBase = CodeBaseTool.getCodeBase();
    public static Cursor cursorSelection;
    public static Cursor cursorSelectionMinus;
    public static Cursor cursorSelectionPlus;
    public static Cursor cursorText;
    public static final Font FONT_BOLD;
    public static final Font FONT_ITALIC;
    public static final Font FONT_SMALL;
    public static final Font FONT_DEFAULT;
    public static final Font FONT_SMALL_FIXEDWIDTH;
    public static final int DEFAULT_EDITOR_WIDTH = 787;
    public static final int DEFAULT_EDITOR_HEIGHT = 537;
    public static final int DEFAULT_EDITOR_LOCATION_X = 0;
    public static final int DEFAULT_EDITOR_LOCATION_Y = 10;
    public static final int DEFAULT_OPTIONS_LOCATION_X = 600;
    public static final int DEFAULT_OPTIONS_LOCATION_Y = 90;
    public static int cursorBlinkPause;
    protected static final String[] imageNames;
    protected static final String[] cursorDescriptions;
    protected static final Point[] cursorHotspots;
    public static MediaTracker tracker;
    public static Tooltips tooltips;
    protected static final String DOCS_BASE_DIR;
    protected static final String ONLINE_DOCS_BASE_DIR = "http://www.jave.de/docs/";
    protected static Inifile inifile;
    protected static RecentFileList recentFileList;
    protected static final Color DARK_YELLOW;
    protected static final Color GRAY_64;
    protected static final Color GRAY_128;
    public static final int UNDO_BUFFER_SIZE = 524288;
    public static final Color COLOR_CHARFIELD_BACK;
    public static final String[] STR_COLOR_SCHEMES;
    public static final String[] COLOR_SCHEME_HEX;
    public static final int BLACK_ON_WHITE = 0;
    public static final int WHITE_ON_BLACK = 1;
    public static final int BLACK_ON_GRAY = 2;
    protected static final Color[] COLOR_SELECTION_BACKGROUND;
    protected static final Color[] COLOR_SELECTION_TEXT;
    protected static final Color[] COLOR_PLATE_LINES;
    protected static final Color[] COLOR_PLATE_EMPTY;
    protected static final Color[] COLOR_PLATE_BACKGROUND;
    protected static final Color[] COLOR_PLATE_SHADOW;
    protected static final Color[] COLOR_TOOL_PREVIEW;
    protected static final Color[] COLOR_TOOL_PREVIEW_DELETE;
    protected static final Color[] COLOR_TOOL_HELPING;
    protected static final Color[] COLOR_WATERMARK;
    protected static final Color[] COLOR_WATERMARK_FILL;
    protected static final Color[] COLOR_TEXT;
    protected static final Color[] COLOR_CURSOR;
    protected static final Color[] COLOR_CURSOR_INVERTED;
    protected static final Color[] COLOR_CURSOR_BLOCK;
    protected static final Color[] COLOR_TOOL_REGION;
    protected static final Color[] COLOR_TOOL;
    protected static final Color[] COLOR_TOOL_DARKER;
    public static Color colorSelectionBackground;
    public static Color colorSelectionText;
    public static Color colorPlateLines;
    public static Color colorPlateEmpty;
    public static Color colorPlateShadow;
    public static Color colorPlateBackground;
    public static Color colorToolHelping;
    public static Color colorToolPreview;
    public static Color colorToolPreviewDelete;
    public static Color colorText;
    public static Color colorCursor;
    public static Color colorToolRegion;
    public static Color colorTool;
    public static Color colorToolDarker;
    public static Color colorWatermarkFill;
    public static Color colorWatermark;
    public static Color colorCursorInverted;
    public static Color colorCursorBlock;
    protected static int colorScheme;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$awt$Point;
    static /* synthetic */ Class class$java$lang$String;

    public static int getEditorWidth() {
        return JaveGlobalRessources.getInifile().getInt("editor", "width", 787);
    }

    public static int getEditorHeight() {
        return JaveGlobalRessources.getInifile().getInt("editor", "height", 537);
    }

    public static int getEditorLocationX() {
        return JaveGlobalRessources.getInifile().getInt("editor", "xpos", 0);
    }

    public static int getEditorLocationY() {
        return JaveGlobalRessources.getInifile().getInt("editor", "ypos", 10);
    }

    public static int getOptionsDialogLocationX() {
        return JaveGlobalRessources.getInifile().getInt("editor", "xpos_options", 600);
    }

    public static int getOptionsDialogLocationY() {
        return JaveGlobalRessources.getInifile().getInt("editor", "ypos_options", 90);
    }

    public static void init(Frame frame) {
        tracker = new MediaTracker(frame);
        cursorSelectionPlus = cursorSelection = new Cursor(1);
        cursorSelectionMinus = cursorSelection;
        cursorText = new Cursor(2);
        try {
            Toolkit toolkit = frame.getToolkit();
            Method method = toolkit.getClass().getDeclaredMethod("getBestCursorSize", Integer.TYPE, Integer.TYPE);
            Dimension dimension = (Dimension)method.invoke((Object)toolkit, new Integer(32), new Integer(32));
            if (dimension == null || dimension.width == 0 || dimension.height == 0) {
                return;
            }
            int n = 1;
            int n2 = 32;
            if (dimension.width < 32) {
                n2 = 16;
                n = 0;
            } else if (dimension.width >= 64) {
                n2 = 64;
                n = 2;
            }
            int n3 = 16;
            method = toolkit.getClass().getDeclaredMethod("getMaximumCursorColors", null);
            if ((Integer)method.invoke((Object)toolkit, null) < 16) {
                n3 = 2;
            }
            Image[] imageArray = new Image[4];
            int n4 = 0;
            while (n4 < imageArray.length) {
                imageArray[n4] = JaveImages.getImage(imageNames[n4] + n3 + "_" + n2, "images");
                tracker.addImage(imageArray[n4], 0);
                ++n4;
            }
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Cursor[] cursorArray = new Cursor[imageArray.length];
            int n5 = 0;
            while (n5 < imageArray.length) {
                if (imageArray[n5] != null) {
                    try {
                        method = toolkit.getClass().getDeclaredMethod("createCustomCursor", class$java$awt$Image == null ? JaveGlobalRessources.class$("java.awt.Image") : class$java$awt$Image, class$java$awt$Point == null ? JaveGlobalRessources.class$("java.awt.Point") : class$java$awt$Point, class$java$lang$String == null ? JaveGlobalRessources.class$("java.lang.String") : class$java$lang$String);
                        cursorArray[n5] = (Cursor)method.invoke((Object)toolkit, imageArray[n5], cursorHotspots[n * 4 + n5], cursorDescriptions[n5]);
                    }
                    catch (Exception exception) {
                        System.err.println("Unable to create custom cursor.");
                    }
                }
                ++n5;
            }
            cursorSelection = cursorArray[0];
            cursorSelectionPlus = cursorArray[1];
            cursorSelectionMinus = cursorArray[2];
            cursorText = cursorArray[3];
        }
        catch (Exception exception) {
            System.err.println("No custom cursors allowed on this system - using system cursors instead.");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println(noSuchMethodError);
        }
    }

    public static MediaTracker getMediaTracker() {
        return tracker;
    }

    public static final void openDocumentation(String string) {
        File file = new File(DOCS_BASE_DIR + string);
        if (!file.exists()) {
            System.err.println("No documentation found! " + file);
        }
        InternetTools.launchBrowser(IOTools.toURLString(file));
    }

    public static final void openOnlineDocumentation(String string) {
        InternetTools.launchBrowser(ONLINE_DOCS_BASE_DIR + string);
    }

    private static void loadInifile() {
        inifile = new Inifile(codeBase + "/jave.ini");
        inifile.load();
        recentFileList = inifile.getRecentFileList();
    }

    public static void saveInifile() {
        inifile.save();
    }

    public static Inifile getInifile() {
        if (inifile == null) {
            JaveGlobalRessources.loadInifile();
        }
        return inifile;
    }

    public static RecentFileList getRecentFileList() {
        if (inifile == null) {
            JaveGlobalRessources.loadInifile();
        }
        return recentFileList;
    }

    public static Dimension getDefaultDocumentDimension() {
        return new Dimension(JaveGlobalRessources.getInifile().getInt("Editor", "default_width", 71), JaveGlobalRessources.getInifile().getInt("Editor", "default_height", 30));
    }

    public static int getColorScheme() {
        return colorScheme;
    }

    public static void setColorScheme(int n) {
        colorScheme = n;
        colorSelectionBackground = COLOR_SELECTION_BACKGROUND[n];
        colorSelectionText = COLOR_SELECTION_TEXT[n];
        colorPlateLines = COLOR_PLATE_LINES[n];
        colorPlateEmpty = COLOR_PLATE_EMPTY[n];
        colorPlateBackground = COLOR_PLATE_BACKGROUND[n];
        colorPlateShadow = COLOR_PLATE_SHADOW[n];
        colorText = COLOR_TEXT[n];
        colorCursor = COLOR_CURSOR[n];
        colorToolHelping = COLOR_TOOL_HELPING[n];
        colorToolPreview = COLOR_TOOL_PREVIEW[n];
        colorToolPreviewDelete = COLOR_TOOL_PREVIEW_DELETE[n];
        colorToolRegion = COLOR_TOOL_REGION[n];
        colorTool = COLOR_TOOL[n];
        colorToolDarker = COLOR_TOOL_DARKER[n];
        colorWatermarkFill = COLOR_WATERMARK_FILL[n];
        colorWatermark = COLOR_WATERMARK[n];
        colorCursorInverted = COLOR_CURSOR_INVERTED[n];
        colorCursorBlock = COLOR_CURSOR_BLOCK[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FONT_BOLD = new Font("Courier", 1, 13);
        FONT_ITALIC = new Font("Dialog", 2, 12);
        FONT_SMALL = new Font("Dialog", 0, 10);
        FONT_DEFAULT = new Font("Courier", 0, 13);
        FONT_SMALL_FIXEDWIDTH = new Font("Courier", 0, 11);
        cursorBlinkPause = 450;
        imageNames = new String[]{"cursor_selection_", "cursor_selection_plus_", "cursor_selection_minus_", "cursor_text_"};
        cursorDescriptions = new String[]{"crosshair cursor selection", "crosshair cursor selection plus", "crosshair cursor selection minus", "text cursor"};
        cursorHotspots = new Point[]{new Point(7, 8), new Point(7, 8), new Point(7, 8), new Point(5, 7), new Point(9, 16), new Point(9, 16), new Point(9, 16), new Point(5, 8), new Point(9, 16), new Point(9, 16), new Point(9, 16), new Point(5, 8)};
        tooltips = new Tooltips();
        DOCS_BASE_DIR = codeBase + "/docs/";
        DARK_YELLOW = new Color(192, 192, 0);
        GRAY_64 = new Color(64, 64, 64);
        GRAY_128 = new Color(128, 128, 128);
        COLOR_CHARFIELD_BACK = new Color(131, 187, 186);
        STR_COLOR_SCHEMES = new String[]{"black on white", "white on black", "black on gray"};
        COLOR_SCHEME_HEX = new String[]{"#FFFFFF #000000", "#000000 #FFFFFF", "#C0C0C0 #000000"};
        COLOR_SELECTION_BACKGROUND = new Color[]{new Color(230, 230, 230), new Color(32, 32, 32), new Color(205, 205, 205)};
        COLOR_SELECTION_TEXT = new Color[]{Color.gray, Color.gray, Color.gray};
        COLOR_PLATE_LINES = new Color[]{new Color(224, 224, 224), new Color(32, 32, 32), new Color(178, 178, 178)};
        COLOR_PLATE_EMPTY = new Color[]{GRAY_128, GRAY_128, GRAY_128};
        COLOR_PLATE_BACKGROUND = new Color[]{Color.white, Color.black, new Color(192, 192, 192)};
        COLOR_PLATE_SHADOW = new Color[]{Color.black, Color.darkGray, Color.black};
        COLOR_TOOL_PREVIEW = new Color[]{new Color(0, 0, 160), new Color(160, 160, 255), new Color(0, 0, 192)};
        COLOR_TOOL_PREVIEW_DELETE = new Color[]{new Color(160, 160, 255), new Color(0, 0, 192), new Color(160, 160, 255)};
        COLOR_TOOL_HELPING = new Color[]{new Color(96, 96, 96), new Color(128, 128, 128), new Color(160, 160, 160)};
        COLOR_WATERMARK = new Color[]{new Color(0, 0, 192), new Color(0, 0, 192), new Color(0, 0, 192)};
        COLOR_WATERMARK_FILL = new Color[]{new Color(192, 192, 255), new Color(192, 192, 255), new Color(192, 192, 255)};
        COLOR_TEXT = new Color[]{Color.black, Color.white, Color.black};
        COLOR_CURSOR = new Color[]{Color.black, Color.white, Color.black};
        COLOR_CURSOR_INVERTED = new Color[]{Color.white, Color.black, Color.white};
        COLOR_CURSOR_BLOCK = new Color[]{GRAY_64, GRAY_64, GRAY_64};
        COLOR_TOOL_REGION = new Color[]{Color.blue, Color.blue, Color.blue};
        COLOR_TOOL = new Color[]{Color.gray, Color.darkGray, Color.gray};
        COLOR_TOOL_DARKER = new Color[]{DARK_YELLOW, DARK_YELLOW, DARK_YELLOW};
        colorSelectionBackground = COLOR_SELECTION_BACKGROUND[0];
        colorSelectionText = COLOR_SELECTION_TEXT[0];
        colorPlateLines = COLOR_PLATE_LINES[0];
        colorPlateEmpty = COLOR_PLATE_EMPTY[0];
        colorPlateShadow = COLOR_PLATE_SHADOW[0];
        colorPlateBackground = COLOR_PLATE_BACKGROUND[0];
        colorToolHelping = COLOR_TOOL_HELPING[0];
        colorToolPreview = COLOR_TOOL_PREVIEW[0];
        colorToolPreviewDelete = COLOR_TOOL_PREVIEW_DELETE[0];
        colorText = COLOR_TEXT[0];
        colorCursor = COLOR_CURSOR[0];
        colorToolRegion = COLOR_TOOL_REGION[0];
        colorTool = COLOR_TOOL[0];
        colorToolDarker = COLOR_TOOL_DARKER[0];
        colorWatermarkFill = COLOR_WATERMARK_FILL[0];
        colorWatermark = COLOR_WATERMARK[0];
        colorCursorInverted = COLOR_CURSOR_INVERTED[0];
        colorCursorBlock = COLOR_CURSOR_BLOCK[0];
        colorScheme = 0;
    }
}

