/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GBorderedPanel;
import de.jave.gui.GDialog;
import de.jave.jave.ColorChooserPanel;
import de.jave.jave.ColorEvent;
import de.jave.jave.ColorListener;
import de.jave.jave.JaveGlobalRessources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;

public class JaveColorChooser
extends Panel
implements ColorListener {
    protected static final String DEMO_TEXT = "  Do you like                 What for?\nthese colors?               ,\n             `  ~..      OO\n                .>>.    ,||.\n                 ||      dd";
    protected TextArea taDemo;
    protected ColorChooserPanel colorChooserForeground;
    protected ColorChooserPanel colorChooserBackground;

    public JaveColorChooser() {
        this.setLayout(new BorderLayout());
        this.colorChooserForeground = new ColorChooserPanel();
        this.colorChooserForeground.addColorListener(this);
        this.colorChooserBackground = new ColorChooserPanel();
        this.colorChooserBackground.addColorListener(this);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Foreground");
        gBorderedPanel.add(this.colorChooserForeground);
        GBorderedPanel gBorderedPanel2 = new GBorderedPanel("Background");
        gBorderedPanel2.add(this.colorChooserBackground);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0));
        panel.add(gBorderedPanel);
        panel.add(gBorderedPanel2);
        this.taDemo = new TextArea(DEMO_TEXT, 5, 60, 3);
        this.taDemo.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        GBorderedPanel gBorderedPanel3 = new GBorderedPanel("Preview:", -1);
        gBorderedPanel3.add(this.taDemo);
        this.add((Component)panel, "Center");
        this.add((Component)gBorderedPanel3, "South");
        this.updateColors();
    }

    public void setSelectedForegroundColor(Color color) {
        this.colorChooserForeground.setSelectedColor(color);
    }

    public void setSelectedBackgroundColor(Color color) {
        this.colorChooserBackground.setSelectedColor(color);
    }

    public void setSelectedColors(Color color, Color color2) {
        this.setSelectedForegroundColor(color);
        this.setSelectedBackgroundColor(color2);
    }

    public Color getSelectedForegroundColor() {
        return this.colorChooserForeground.getSelectedColor();
    }

    public Color getSelectedBackgroundColor() {
        return this.colorChooserBackground.getSelectedColor();
    }

    public void colorChanged(ColorEvent colorEvent) {
        this.updateColors();
    }

    protected void updateColors() {
        this.taDemo.setForeground(this.colorChooserForeground.getSelectedColor());
        this.taDemo.setBackground(this.colorChooserBackground.getSelectedColor());
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("test");
        frame.pack();
        frame.show();
        JaveColorChooser javeColorChooser = new JaveColorChooser();
        javeColorChooser.setSelectedColors(Color.black, Color.white);
        GDialog gDialog = new GDialog(frame, "Choose colors", (Component)javeColorChooser, GDialog.OK_CANCEL);
        gDialog.show();
    }
}

