/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import java.util.Vector;

public class FillAlgorithm {
    protected static final int MATCH_EQUAL = 0;
    protected static final int MATCH_ANY_4 = 1;
    protected static final int MATCH_ANY_8 = 2;
    protected static final String[] STR_MATCH_MODE = new String[]{"Equal character", "Any character", "Any character + diagonal"};
    public static final int LINEAR_GRADIENT = 0;
    public static final int SUNBURST_GRADIENT = 1;
    public static final int RADIAL_GRADIENT = 2;
    protected static final String[] STR_GRADIENT_STYLE = new String[]{"Linear", "Sunburst", "Radial"};
    protected static final char MARK = '\u0002';
    protected static CharacterPlate plate;
    protected static int plateWidth;
    protected static int plateHeight;
    protected static int matchMode;
    protected static char prevChar;
    protected static int boundsMinX;
    protected static int boundsMinY;
    protected static int boundsMaxX;
    protected static int boundsMaxY;
    static final double RADIUS_CORRECT_FACTOR = 3.5;
    static final double LINEAR_CORRECT_FACTOR = 3.5;
    protected static Vector spans;
    protected static final double[][] BAYER_MATRIX4;
    protected static final double[][] BAYER_MATRIX2;

    protected static void addSpan(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        spans.addElement(nArray);
    }

    protected static int[] getSpan() {
        int[] nArray = (int[])spans.elementAt(spans.size() - 1);
        spans.removeElementAt(spans.size() - 1);
        return nArray;
    }

    protected static boolean matches(int n, int n2) {
        char c;
        if (n < 0 || n2 < 0 || n >= plateWidth || n2 >= plateHeight) {
            return false;
        }
        if (matchMode == 0 && plate.get(n, n2) != prevChar) {
            return false;
        }
        return matchMode == 0 || (c = plate.get(n, n2)) != ' ' && c != '\u0002';
    }

    public static void fill(int n, int n2) {
        spans = new Vector();
        if (!FillAlgorithm.matches(n, n2)) {
            return;
        }
        FillAlgorithm.addSpan(n, n, n2);
        int n3 = 0;
        if (matchMode == 2) {
            n3 = 1;
        }
        while (spans.size() > 0) {
            int n4;
            int n5;
            int n6;
            int[] nArray = FillAlgorithm.getSpan();
            int n7 = nArray[0];
            int n8 = nArray[1];
            int n9 = nArray[2];
            while (n7 > 0 && FillAlgorithm.matches(n7 - 1, n9)) {
                --n7;
            }
            while (n8 < plateWidth - 1 && FillAlgorithm.matches(n8 + 1, n9)) {
                ++n8;
            }
            int n10 = n7;
            while (n10 <= n8) {
                plate.setForce(n10, n9, '\u0002');
                ++n10;
            }
            if (n7 < boundsMinX) {
                boundsMinX = n7;
            }
            if (n8 > boundsMaxX) {
                boundsMaxX = n8;
            }
            if (n9 < boundsMinY) {
                boundsMinY = n9;
            } else if (n9 > boundsMaxY) {
                boundsMaxY = n9;
            }
            if (n9 > 0) {
                n6 = -1;
                n5 = -1;
                n4 = n7 - n3;
                while (n4 <= n8 + n3) {
                    if (FillAlgorithm.matches(n4, n9 - 1)) {
                        if (n6 == -1) {
                            n6 = n4;
                            n5 = n4;
                        } else {
                            ++n5;
                        }
                    } else {
                        if (n6 != -1) {
                            FillAlgorithm.addSpan(n6, n5, n9 - 1);
                        }
                        n6 = -1;
                        n5 = -1;
                    }
                    ++n4;
                }
                if (n6 != -1) {
                    FillAlgorithm.addSpan(n6, n5, n9 - 1);
                }
            }
            if (n9 >= plateHeight - 1) continue;
            n6 = -1;
            n5 = -1;
            n4 = n7 - n3;
            while (n4 <= n8 + n3) {
                if (FillAlgorithm.matches(n4, n9 + 1)) {
                    if (n6 == -1) {
                        n6 = n4;
                        n5 = n4;
                    } else {
                        ++n5;
                    }
                } else {
                    if (n6 != -1) {
                        FillAlgorithm.addSpan(n6, n5, n9 + 1);
                    }
                    n6 = -1;
                    n5 = -1;
                }
                ++n4;
            }
            if (n6 == -1) continue;
            FillAlgorithm.addSpan(n6, n5, n9 + 1);
        }
    }

    public static void fillSolid(CharacterPlate characterPlate, int n, int n2, char c, int n3) {
        matchMode = n3;
        prevChar = characterPlate.get(n, n2);
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        boundsMaxX = n;
        boundsMinX = n;
        boundsMaxY = n2;
        boundsMinY = n2;
        FillAlgorithm.fill(n, n2);
        int n4 = boundsMinX;
        while (n4 <= boundsMaxX) {
            int n5 = boundsMinY;
            while (n5 <= boundsMaxY) {
                if (characterPlate.get(n4, n5) == '\u0002') {
                    characterPlate.setForce(n4, n5, c);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public static void fillPattern(CharacterPlate characterPlate, int n, int n2, char[][] cArray, int n3) {
        if (cArray == null) {
            return;
        }
        matchMode = n3;
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        int n4 = cArray.length;
        if (n4 == 0) {
            return;
        }
        int n5 = cArray[0].length;
        if (n5 == 0) {
            return;
        }
        boundsMinX = n;
        boundsMaxX = n;
        boundsMinY = n2;
        boundsMaxY = n2;
        prevChar = characterPlate.get(n, n2);
        FillAlgorithm.fill(n, n2);
        int n6 = 0;
        while ((n6 + n) % n5 != 0) {
            ++n6;
        }
        int n7 = 0;
        while ((n7 + n2) % n4 != 0) {
            ++n7;
        }
        int n8 = boundsMinX;
        while (n8 <= boundsMaxX) {
            int n9 = boundsMinY;
            while (n9 <= boundsMaxY) {
                if (characterPlate.get(n8, n9) == '\u0002') {
                    characterPlate.setForce(n8, n9, cArray[(n9 + n7) % n4][(n8 + n6) % n5]);
                }
                ++n9;
            }
            ++n8;
        }
    }

    public static void fillGradient(CharacterPlate characterPlate, int n, int n2, int n3, int n4, char[] cArray, int n5, int n6, boolean bl) {
        int n7;
        matchMode = n6;
        plate = characterPlate;
        plateWidth = characterPlate.getWidth();
        plateHeight = characterPlate.getHeight();
        int n8 = cArray.length;
        boundsMinX = n;
        boundsMaxX = n;
        boundsMinY = n2;
        boundsMaxY = n2;
        prevChar = characterPlate.get(n, n2);
        FillAlgorithm.fill(n, n2);
        double d = n3 - n;
        double d2 = (double)(n4 - n2) * 3.5;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = -(d2 /= d3);
        double d5 = d /= d3;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n9 = boundsMinX;
        while (n9 <= boundsMaxX) {
            n7 = boundsMinY;
            while (n7 <= boundsMaxY) {
                if (characterPlate.get(n9, n7) == '\u0002') {
                    double d9 = (double)(n2 - n7) * d4 - (double)(n - n9) * d5;
                    if (d9 < d6) {
                        d6 = d9;
                    } else if (d9 > d7) {
                        d7 = d9;
                    }
                    double d10 = (double)((n9 - n) * (n9 - n)) + 3.5 * (double)(n7 - n2) * (double)(n7 - n2);
                    if (d10 > d8) {
                        d8 = d10;
                    }
                }
                ++n7;
            }
            ++n9;
        }
        d8 = Math.sqrt(d8);
        n7 = boundsMinY;
        while (n7 <= boundsMaxY) {
            int n10 = boundsMinX;
            while (n10 <= boundsMaxX) {
                if (characterPlate.get(n10, n7) == '\u0002') {
                    int n11;
                    double d11;
                    double d12 = 0.0;
                    if (n5 == 0) {
                        double d13 = (double)(n2 - n7) * d4 - (double)(n - n10) * d5;
                        d11 = (d13 - d6) / (d7 - d6);
                        d12 = d11 * (double)n8 - 0.5;
                    } else if (n5 == 1) {
                        double d14 = Math.sqrt(3.5 * (double)(n7 - n2) * (double)(n7 - n2) + (double)((n10 - n) * (n10 - n)));
                        d11 = d14 / d8;
                        d12 = d11 * ((double)n8 - 0.5);
                    } else if (n5 == 2) {
                        double d15 = n10 - n;
                        d11 = (double)(n7 - n2) * 3.5;
                        double d16 = Math.sqrt(d15 * d15 + d11 * d11);
                        double d17 = Math.acos((d15 /= d16) * d + (d11 /= d16) * d2);
                        double d18 = d17 / Math.PI;
                        d12 = d18 * ((double)n8 - 1.0);
                    }
                    if (bl) {
                        d12 += BAYER_MATRIX2[n10 % 2][n7 % 2] - 0.5;
                    }
                    if ((n11 = (int)Math.round(d12)) < 0) {
                        n11 = 0;
                    } else if (n11 >= n8) {
                        n11 = n8 - 1;
                    }
                    char c = cArray[n11];
                    characterPlate.setForce(n10, n7, c);
                }
                ++n10;
            }
            ++n7;
        }
    }

    static {
        BAYER_MATRIX4 = new double[][]{{0.0, 0.5333333333333333, 0.13333333333333333, 0.6666666666666666}, {0.8, 0.26666666666666666, 0.9333333333333333, 0.4}, {0.2, 0.7333333333333333, 0.06666666666666667, 0.6}, {1.0, 0.4666666666666667, 0.8666666666666667, 0.3333333333333333}};
        BAYER_MATRIX2 = new double[][]{{0.6666666666666666, 0.3333333333333333}, {0.0, 1.0}};
    }
}

