/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.BooleanPlate;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.undo.UndoState;
import java.awt.Point;

public class CompressedDocumentState
implements UndoState {
    private String selectionContent;
    private String selectionMask;
    private Point selectionLocation;
    private String content;
    private int scrollX;
    private int scrollY;
    private int cursorX;
    private int cursorY;
    private String toolName;
    private String actionName;
    private int colorScheme;
    private int duration;

    CompressedDocumentState() {
    }

    public CompressedDocumentState(char[][] cArray, Point point, char[][] cArray2, Point point2, BooleanPlate booleanPlate, Point point3, String string, String string2, int n) {
        this.actionName = string2;
        this.toolName = string;
        this.colorScheme = n;
        this.content = JaveAsciiPacker.encode(cArray);
        this.selectionContent = cArray2 == null ? null : JaveAsciiPacker.encode(cArray2);
        this.selectionMask = booleanPlate == null ? null : booleanPlate.toString();
        if (point != null) {
            this.scrollX = point.x;
            this.scrollY = point.y;
        } else {
            this.scrollX = 0;
            this.scrollY = 0;
        }
        this.selectionLocation = point2 == null ? null : new Point(point2.x, point2.y);
        if (point3 != null) {
            this.cursorX = point3.x;
            this.cursorY = point3.y;
        } else {
            this.cursorX = 0;
            this.cursorY = 0;
        }
    }

    public void setTool(String string) {
        this.toolName = string;
    }

    public void setAction(String string) {
        this.actionName = string;
    }

    public String getAction() {
        return this.actionName;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setSelectionContent(String string) {
        this.selectionContent = string;
    }

    public void setDuration(int n) {
        this.duration = n;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setSelectionMask(String string) {
        this.selectionMask = string;
    }

    public void setColorScheme(int n) {
        this.colorScheme = n;
    }

    public int getColorScheme() {
        return this.colorScheme;
    }

    public void setScrollX(int n) {
        this.scrollX = n;
    }

    public void setScrollY(int n) {
        this.scrollY = n;
    }

    public void setCursorX(int n) {
        this.cursorX = n;
    }

    public void setCursorY(int n) {
        this.cursorY = n;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public void setSelectionLocation(int n, int n2) {
        this.selectionLocation = new Point(n, n2);
    }

    public int getEstimatedMemorySize() {
        int n = 0;
        if (this.content != null) {
            n += this.content.length();
        }
        if (this.selectionContent != null) {
            n += this.selectionContent.length();
        }
        if (this.toolName != null) {
            n += this.toolName.length();
        }
        if (this.actionName != null) {
            n += this.toolName.length();
        }
        return n + 50;
    }

    public String getUndoActionName() {
        return this.actionName;
    }

    public char[][] getContent() {
        if (this.content == null) {
            return null;
        }
        return JaveAsciiPacker.decode(this.content);
    }

    public Point getScrollOrigin() {
        return new Point(this.scrollX, this.scrollY);
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollX;
    }

    public String getPackedSelectionContent() {
        return this.selectionContent;
    }

    public String getPackedContent() {
        return this.content;
    }

    public boolean hasSelection() {
        return this.selectionContent != null;
    }

    public char[][] getSelectionContent() {
        if (this.selectionContent == null) {
            return null;
        }
        return JaveAsciiPacker.decode(this.selectionContent);
    }

    public Point getSelectionLocation() {
        return this.selectionLocation;
    }

    public boolean hasSelectionMask() {
        return this.selectionMask != null;
    }

    public BooleanPlate getSelectionMask() {
        if (this.selectionMask == null) {
            return null;
        }
        return new BooleanPlate(this.selectionMask);
    }

    public String getToolName() {
        return this.toolName;
    }

    public Point getCursorLocation() {
        return new Point(this.cursorX, this.cursorY);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("J:");
        stringBuffer.append(this.content);
        stringBuffer.append('\n');
        stringBuffer.append("^:");
        stringBuffer.append(this.scrollX);
        stringBuffer.append(' ');
        stringBuffer.append(this.scrollY);
        stringBuffer.append('\n');
        stringBuffer.append("|:");
        stringBuffer.append(this.cursorX);
        stringBuffer.append(' ');
        stringBuffer.append(this.cursorY);
        stringBuffer.append('\n');
        stringBuffer.append("C:");
        stringBuffer.append(JaveGlobalRessources.COLOR_SCHEME_HEX[this.colorScheme]);
        stringBuffer.append('\n');
        if (this.selectionContent != null) {
            stringBuffer.append("S:");
            stringBuffer.append(this.selectionLocation.x);
            stringBuffer.append(' ');
            stringBuffer.append(this.selectionLocation.y);
            stringBuffer.append(' ');
            stringBuffer.append(this.selectionContent);
            stringBuffer.append('\n');
            if (this.selectionMask != null) {
                stringBuffer.append("M:");
                stringBuffer.append(this.selectionMask);
                stringBuffer.append('\n');
            }
        }
        if (this.toolName != null) {
            stringBuffer.append("T:");
            stringBuffer.append(this.toolName);
            stringBuffer.append('\n');
        }
        if (this.actionName != null) {
            stringBuffer.append("A:");
            stringBuffer.append(this.actionName);
            stringBuffer.append('\n');
        }
        stringBuffer.append("+:");
        stringBuffer.append(this.duration);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

