/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.gui.GuiTools;
import de.jave.jave.ColorEvent;
import de.jave.jave.ColorListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class ColorChooserPanel
extends Canvas
implements MouseListener {
    protected static final Color[] COLORS = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.yellow, Color.green, Color.cyan, Color.blue, new Color(128, 0, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 128), Color.magenta, Color.orange, null, null, null, new Color(128, 0, 128), new Color(128, 99, 0), null, null, null, new Color(170, 187, 221), new Color(238, 238, 252), new Color(204, 199, 219), Color.pink, null};
    protected static final int SIZE = 14;
    protected static final int DISTANCE = 1;
    protected static Rectangle[] REGIONS = new Rectangle[COLORS.length];
    protected int selectedIndex;
    protected Vector listeners;
    protected Color[] colors;

    public ColorChooserPanel() {
        this.addMouseListener(this);
        this.listeners = new Vector();
        this.colors = new Color[COLORS.length];
        System.arraycopy(COLORS, 0, this.colors, 0, COLORS.length);
    }

    public void addColorListener(ColorListener colorListener) {
        this.listeners.addElement(colorListener);
    }

    public void removeColorListener(ColorListener colorListener) {
        this.listeners.removeElement(colorListener);
    }

    protected void fireColorEvent(ColorEvent colorEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ColorListener)enumeration.nextElement()).colorChanged(colorEvent);
        }
    }

    public Dimension getPreferredSize() {
        int n = this.colors.length / 5 + 1;
        int n2 = 5;
        return new Dimension(n * 14 + (n - 1) * 1, n2 * 14 + (n2 - 1) * 1);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this.colors.length) {
            if (this.colors[n] != null) {
                graphics.setColor(this.colors[n]);
                graphics.fillRect(ColorChooserPanel.REGIONS[n].x, ColorChooserPanel.REGIONS[n].y, ColorChooserPanel.REGIONS[n].width, ColorChooserPanel.REGIONS[n].height);
                GuiTools.drawSmall3dRectangleDown(graphics, ColorChooserPanel.REGIONS[n].x, ColorChooserPanel.REGIONS[n].y, ColorChooserPanel.REGIONS[n].width, ColorChooserPanel.REGIONS[n].height);
                if (n == this.selectedIndex) {
                    GfxTools.drawDottedRectangle(graphics, Color.black, Color.white, ColorChooserPanel.REGIONS[n].x + 1, ColorChooserPanel.REGIONS[n].y + 1, ColorChooserPanel.REGIONS[n].width - 3, ColorChooserPanel.REGIONS[n].height - 3);
                }
            }
            ++n;
        }
    }

    public Color getSelectedColor() {
        return this.colors[this.selectedIndex];
    }

    public void setSelectedColor(Color color) {
        int n = 0;
        while (n < this.colors.length) {
            if (this.colors[n] != null && this.colors[n].equals(color)) {
                this.setSelectedColorIndex(n);
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.colors.length) {
            if (this.colors[n2] == null) {
                this.colors[n2] = color;
                this.setSelectedColorIndex(n2);
                return;
            }
            ++n2;
        }
    }

    protected void setSelectedColorIndex(int n) {
        if (this.selectedIndex == n) {
            return;
        }
        this.selectedIndex = n;
        this.repaint();
        this.fireColorEvent(new ColorEvent(this, this.getSelectedColor()));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 0;
        while (n3 < REGIONS.length) {
            if (REGIONS[n3] != null && REGIONS[n3].contains(n, n2) && this.colors[n3] != null) {
                this.setSelectedColorIndex(n3);
                return;
            }
            ++n3;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        int n = 0;
        while (n < COLORS.length) {
            int n2 = n / 5;
            int n3 = n % 5;
            int n4 = n2 * 14;
            if (n2 > 0) {
                n4 += 1 * (n2 - 1);
            }
            int n5 = n3 * 14;
            if (n3 > 0) {
                n5 += 1 * (n3 - 1);
            }
            ColorChooserPanel.REGIONS[n] = new Rectangle(n4, n5, 14, 14);
            ++n;
        }
    }
}

