/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.ClipartGroup;
import de.jave.jave.JaveGlobalRessources;
import de.jave.util.Toolbox;
import java.io.File;
import java.util.Vector;

public class ClipartManager {
    protected static final String BASE_DIR = JaveGlobalRessources.codeBase + "/clipart/";
    protected Vector groups;

    public ClipartManager() {
        this.loadGroups();
    }

    protected void loadGroups() {
        File file = new File(BASE_DIR);
        if (!file.exists()) {
            System.err.println("The folder " + file + " does not exist!");
            return;
        }
        String[] stringArray = file.list();
        this.groups = new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".jcf")) {
                try {
                    ClipartGroup clipartGroup = new ClipartGroup(stringArray[n]);
                    clipartGroup.load();
                    this.groups.addElement(clipartGroup);
                }
                catch (Exception exception) {
                    System.err.println("Corrupt Clipart file: " + new File(file, stringArray[n]));
                    System.err.println(exception);
                }
            }
            ++n;
        }
    }

    public String[] getGroupNames() {
        String[] stringArray = new String[this.groups.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((ClipartGroup)this.groups.elementAt(n)).getName();
            ++n;
        }
        Toolbox.quickSortIgnoreCase(stringArray);
        return stringArray;
    }

    public boolean hasGroupName(String string) {
        int n = 0;
        while (n < this.groups.size()) {
            if (((ClipartGroup)this.groups.elementAt(n)).getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ClipartGroup getGroup(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this.groups.size()) {
            if (string.equals(((ClipartGroup)this.groups.elementAt(n)).getName())) {
                return (ClipartGroup)this.groups.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ClipartManager clipartManager = new ClipartManager();
        String[] stringArray2 = clipartManager.getGroupNames();
    }
}

