/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.AscTrisBlock;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGame;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.PixelPlate;
import de.jave.jave.RectangleAlgorithm;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class AscTris
extends JaveGame
implements Runnable {
    protected static final String TITLE = "Asc-Tris 2.0";
    protected AscTrisBlock currentBlock;
    protected AscTrisBlock nextBlock;
    protected static final int[] PAUSE_FOR_LEVEL = new int[]{800, 700, 600, 500, 410, 370, 335, 310, 290};
    protected static final int MAX_LEVEL = 9;
    protected static final int LINES_FOR_LEVEL = 6;
    protected static final int[] SCORE_FOR_LINES = new int[]{40, 100, 300, 1200};
    protected static final int START_POS_X = 12;
    protected static final int START_POS_Y = 0;
    protected static final int SCORE_X = 44;
    protected static final int SCORE_Y = 3;
    protected static final int LEVEL_X = 44;
    protected static final int LEVEL_Y = 2;
    protected static final int X0 = 3;
    protected static final int Y0 = 0;
    protected static final int X1 = 32;
    protected static final int Y1 = 31;
    protected static final int PLATE_WIDTH = 64;
    protected static final int PLATE_HEIGHT = 33;
    protected static final int PREVIEW_POS_X = 41;
    protected static final int PREVIEW_POS_Y = 24;
    protected boolean shallStop;
    protected Thread thread;
    protected boolean paused = false;
    protected int score;
    protected int level;
    int dropStop;
    protected Object synchy = new Object();
    protected CharacterPlate tmpBuffer;

    public AscTris(Jave jave) {
        super(jave);
        this.startGame();
    }

    public Dimension getPreferredSize() {
        return new Dimension(64, 33);
    }

    protected String getTitle() {
        return TITLE;
    }

    protected int getPreferredColorScheme() {
        return 1;
    }

    public void startGame() {
        this.shallStop = true;
        this.paused = false;
        while (this.thread != null) {
            this.thread.interrupt();
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        PixelPlate pixelPlate = new PixelPlate(0, 0, 64, 33);
        pixelPlate.setMode(1);
        LineAlgorithm.drawLine(pixelPlate, 2.0, 0.0, 2.0, 32.0, 0);
        LineAlgorithm.drawLine(pixelPlate, 33.0, 0.0, 33.0, 32.0, 0);
        LineAlgorithm.drawLine(pixelPlate, 2.0, 32.0, 33.0, 32.0, 0);
        this.plate.clear();
        pixelPlate.pasteResultInto(this.plate);
        this.plate.paste("~~~~~~~~~~~~~~", 36, 1);
        this.plate.paste("Score:", 37, 3);
        this.plate.paste("Level:", 37, 2);
        this.plate.paste("~~~~~~~~~~~~~~", 36, 4);
        this.plate.paste("Next:", 35, 23);
        this.plate.paste("  left: Cursor Left\n right: Cursor Right\n  drop: Space\nrotate: Cursor Up\n pause: P\n  quit: Q\nstart new game: S", 35, 6);
        this.plate.paste(".-------.\n|       |\n|       |\n|       |\n|       |\n| _____ |\n||_   _||\n|  | |  |\n|  | |  |\n|  |_|  |\n| ____  |\n||  _ \\ |\n|| |_)/ |\n|| ,-.\\ |\n||_| |_\\|\n'   _   |\n   | |  |\n   | |  |\n   | |  |\n.  |_|  |\n|       |\n| .----.|\n|/   __/|\n|\\___  \\|\n|/     /|\n|`----' |\n|       |\n|   _   |\n| .\\_/. |\n| ||a|| |\n| `/_\\' |\n|       |\n`-------'", 55, 0);
        this.plate.paste(",---------------\n| .-. .-.  .-.\n| .-| `-. (   <>\n| `-^ `-'  `-'\n`---------------", 39, 15);
        this.shallStop = false;
        this.thread = new Thread(this);
        this.thread.start();
        this.requestFocus();
    }

    protected void keyTyped(KeyEvent keyEvent, int n, char c) {
        if (this.paused) {
            this.plate.delete(4, 11, 30, 14);
            this.tmpBuffer.pasteInto(this.plate, 4, 11);
            this.repaint();
            this.paused = false;
            return;
        }
        if (c == 'p' && this.thread != null && !this.shallStop) {
            this.paused = true;
            this.tmpBuffer = this.plate.getCopy(4, 11, 27, 4);
            RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(4, 11, 27, 4), RectangleAlgorithm.getCharsForStyle(0));
            this.plate.paste("       * Paused *        ", 5, 12);
            this.plate.paste(" Hit any key to continue ", 5, 13);
            this.repaint();
            return;
        }
        if (c == 's') {
            this.startGame();
            return;
        }
        if (c == 'q') {
            this.shallStop = true;
            this.thread = null;
            this.quit();
            return;
        }
    }

    protected void keyPressed(KeyEvent keyEvent, int n, char c) {
        if (this.thread == null || this.shallStop || this.paused) {
            return;
        }
        if (c == ' ') {
            this.drop();
            return;
        }
        if (n == 37) {
            this.moveLeft();
            return;
        }
        if (n == 39) {
            this.moveRight();
            return;
        }
        if (n == 40) {
            this.down();
            return;
        }
        if (n == 38) {
            this.rotateLeft();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.currentBlock = new AscTrisBlock();
        this.currentBlock.xPos = 12;
        this.currentBlock.yPos = 0;
        this.currentBlock.pasteInto(this.plate);
        this.nextBlock = new AscTrisBlock();
        this.nextBlock.xPos = 41;
        this.nextBlock.yPos = 24;
        this.nextBlock.pasteInto(this.plate);
        this.dropStop = 1;
        this.setLevel(1);
        this.resetScore();
        int n = 0;
        long l = System.currentTimeMillis();
        while (!this.shallStop) {
            long l2 = (long)PAUSE_FOR_LEVEL[this.level - 1] - (System.currentTimeMillis() - l);
            if (l2 > 0L) {
                try {
                    Thread.currentThread();
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            while (!(this.enabled && !this.paused || this.shallStop)) {
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            l = System.currentTimeMillis();
            if (this.shallStop) break;
            Object object = this.synchy;
            synchronized (object) {
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveDown();
                if (this.currentBlock.fits(this.plate)) {
                    this.currentBlock.pasteInto(this.plate);
                    --this.dropStop;
                } else {
                    int n2;
                    this.dropStop = 1;
                    this.currentBlock.moveUp();
                    this.currentBlock.pasteInto(this.plate);
                    Thread.currentThread();
                    Thread.yield();
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 <= 31) {
                        n2 = 1;
                        int n5 = 3;
                        while (n5 <= 32 && n2 != 0) {
                            if (this.plate.get(n5, n4) == ' ') {
                                n2 = 0;
                            }
                            ++n5;
                        }
                        if (n2 != 0) {
                            ++n3;
                            ++n;
                            this.fadeLine(n4);
                            int n6 = n4 - 1;
                            while (n6 >= 0) {
                                int n7 = 3;
                                while (n7 <= 32) {
                                    this.plate.setForce(n7, n6 + 2, this.plate.get(n7, n6));
                                    ++n7;
                                }
                                --n6;
                            }
                        }
                        n4 += 2;
                    }
                    if (n3 > 0) {
                        if (n3 - 1 >= SCORE_FOR_LINES.length) {
                            n3 = SCORE_FOR_LINES.length;
                        }
                        this.addScore(this.level * SCORE_FOR_LINES[n3 - 1]);
                    }
                    if ((n2 = n / 6) <= 9 && n2 > this.level) {
                        this.setLevel(n2);
                    }
                    this.nextBlock.removeFrom(this.plate);
                    this.currentBlock = this.nextBlock;
                    this.currentBlock.xPos = 12;
                    this.currentBlock.yPos = 0;
                    while (this.currentBlock.isInside()) {
                        this.currentBlock.moveUp();
                    }
                    this.currentBlock.moveDown();
                    if (!this.currentBlock.fits(this.plate)) {
                        RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(10, 12, 17, 3), RectangleAlgorithm.getCharsForStyle(0));
                        this.plate.paste(" * Game Over * ", 11, 13);
                        this.shallStop = true;
                        this.thread = null;
                        this.repaint();
                    } else {
                        this.currentBlock.pasteInto(this.plate);
                        this.nextBlock = new AscTrisBlock();
                        this.nextBlock.xPos = 41;
                        this.nextBlock.yPos = 24;
                        this.nextBlock.pasteInto(this.plate);
                    }
                }
                this.repaint();
            }
        }
        this.document.setModified(false);
        this.thread = null;
    }

    protected void fadeLine(int n) {
        int n2 = 0;
        while (n2 < 6) {
            int n3 = 3;
            while (n3 <= 32) {
                int n4 = 0;
                while (n4 <= 1) {
                    int n5 = " :=8OSXZBEW#M".indexOf(this.plate.get(n3, n + n4));
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    this.plate.setForce(n3, n + n4, " :=8OSXZBEW#M".charAt(n5 /= 2));
                    ++n4;
                }
                ++n3;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.repaint();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotateLeft() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.rotateLeft();
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveRight();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveLeft();
                }
            }
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveLeft();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveRight();
                }
            }
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.rotateRight();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.rotateLeft();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.rotateRight();
                this.currentBlock.pasteInto(this.plate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rotateRight() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.rotateRight();
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveRight();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveLeft();
                }
            }
            if (!this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveLeft();
                if (!this.currentBlock.fits(this.plate)) {
                    this.currentBlock.moveRight();
                }
            }
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.rotateLeft();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.rotateRight();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.rotateLeft();
                this.currentBlock.pasteInto(this.plate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveLeft() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.moveLeft();
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveRight();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveLeft();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.moveRight();
                this.currentBlock.pasteInto(this.plate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveRight() {
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            this.currentBlock.moveRight();
            if (this.currentBlock.fits(this.plate)) {
                this.currentBlock.moveLeft();
                this.currentBlock.removeFrom(this.plate);
                this.currentBlock.moveRight();
                this.currentBlock.pasteInto(this.plate);
                this.repaint();
            } else {
                this.currentBlock.moveLeft();
                this.currentBlock.pasteInto(this.plate);
            }
        }
    }

    protected void down() {
        this.thread.interrupt();
        this.addScore(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drop() {
        if (this.dropStop > 0) {
            return;
        }
        Object object = this.synchy;
        synchronized (object) {
            this.currentBlock.removeFrom(this.plate);
            int n = 0;
            do {
                this.currentBlock.moveDown();
                ++n;
            } while (this.currentBlock.fits(this.plate));
            this.currentBlock.moveUp();
            this.addScore(--n);
            this.repaint();
        }
        this.thread.interrupt();
    }

    protected void addScore(int n) {
        this.setScore(this.score + n);
    }

    protected void resetScore() {
        this.setScore(0);
    }

    protected void setScore(int n) {
        this.score = n;
        this.plate.paste(this.score + "   ", 44, 3);
        this.repaint();
    }

    protected void setLevel(int n) {
        this.level = n;
        this.plate.paste(this.level + "   ", 44, 2);
        this.repaint();
    }
}

