/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.jave.ArcAgorithm;
import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class ArcToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point point2;
    protected Point point3;
    protected Point movingPoint;

    public ArcToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Arc Generic";
    }

    public String getIconName() {
        return "arc_generic";
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        if (this.point1 == null) {
            this.movingPoint = this.point1 = point;
            this.point2 = null;
            this.point3 = null;
        } else if (this.point2 == null) {
            this.movingPoint = this.point2 = point;
            this.point3 = null;
        } else if (this.point3 == null) {
            this.movingPoint = this.point3 = point;
            this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
            GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
            this.markPlate.setCharacter(this.getMouseChar());
        }
        this.repaintCursor();
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.movingPoint == null) {
            return;
        }
        this.movingPoint.x = point.x;
        this.movingPoint.y = point.y;
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.point1 == null || this.point2 == null || this.point3 == null) {
            return;
        }
        this.movingPoint = null;
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
        if (this.markPlate != null) {
            this.setMixMode(this.getMixMode());
            this.markPlate.convert();
            this.markPlate.pasteResultInto(this.plate.getContent());
            this.saveCurrentState("draw arc");
            this.repaintAll();
            this.markPlate = null;
        }
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27 && this.point1 != null) {
            this.point1 = null;
            this.point2 = null;
            this.point3 = null;
            this.movingPoint = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    protected static final double getAngle(double d, double d2) {
        if (d == 0.0) {
            if (d2 > 0.0) {
                return 270.0;
            }
            return 90.0;
        }
        double d3 = Math.atan(d2 / d);
        if (d > 0.0) {
            return (360.0 - d3 * 180.0 / Math.PI) % 360.0;
        }
        return 180.0 - d3 * 180.0 / Math.PI;
    }

    public void paintCursorFeature(Graphics graphics) {
        boolean bl;
        Rectangle rectangle;
        Point point;
        Point point2;
        if (this.point1 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        graphics.drawRect(this.point1.x - 2, this.point1.y - 2, 5, 5);
        if (this.point2 == null) {
            return;
        }
        graphics.drawRect(this.point2.x - 2, this.point2.y - 2, 5, 5);
        if (this.point3 == null) {
            return;
        }
        Point2d point2d = ArcAgorithm.getCenter(this.point1, this.point2, this.point3);
        if (point2d == null) {
            int n;
            int n2 = this.point1.x < this.point2.x ? this.point1.x : this.point2.x;
            int n3 = this.point1.y < this.point2.y ? this.point1.y : this.point2.y;
            int n4 = this.point1.x > this.point2.x ? this.point1.x : this.point2.x;
            int n5 = n = this.point1.y > this.point2.y ? this.point1.y : this.point2.y;
            if (this.point3.x >= n2 && this.point3.x <= n4 && this.point3.y >= n3 && this.point3.y <= n) {
                graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                this.markPlate.clear();
                Point2d point2d2 = this.plate.getRealLocationForScreenPoint(this.point1);
                Point2d point2d3 = this.plate.getRealLocationForScreenPoint(this.point2);
                this.markPlate.drawLine(point2d2, point2d3);
                this.markPlate.convert();
                this.markPlate.paint(graphics, this.plate, this.debug);
                return;
            }
            return;
        }
        double d = Math.sqrt(Math.pow((double)this.point1.x - point2d.x, 2.0) + Math.pow((double)this.point1.y - point2d.y, 2.0));
        int n = (int)Math.round(d);
        double d2 = ArcToolGeneric.getAngle((double)this.point1.x - point2d.x, (double)this.point1.y - point2d.y);
        double d3 = ArcToolGeneric.getAngle((double)this.point2.x - point2d.x, (double)this.point2.y - point2d.y);
        double d4 = ArcToolGeneric.getAngle((double)this.point3.x - point2d.x, (double)this.point3.y - point2d.y);
        double d5 = (d3 - d2) / 180.0 * Math.PI;
        double d6 = Math.abs(d * Math.cos(d5 / 2.0));
        if (d - d6 < 1.0) {
            int n6;
            int n7 = this.point1.x < this.point2.x ? this.point1.x : this.point2.x;
            int n8 = this.point1.y < this.point2.y ? this.point1.y : this.point2.y;
            int n9 = this.point1.x > this.point2.x ? this.point1.x : this.point2.x;
            int n10 = n6 = this.point1.y > this.point2.y ? this.point1.y : this.point2.y;
            if (this.point3.x >= n7 && this.point3.x <= n9 && this.point3.y >= n8 && this.point3.y <= n6) {
                graphics.drawLine(this.point1.x, this.point1.y, this.point2.x, this.point2.y);
                this.markPlate.clear();
                Point2d point2d4 = this.plate.getRealLocationForScreenPoint(this.point1);
                Point2d point2d5 = this.plate.getRealLocationForScreenPoint(this.point2);
                this.markPlate.drawLine(point2d4, point2d5);
                this.markPlate.convert();
                this.markPlate.paint(graphics, this.plate, this.debug);
                return;
            }
            d5 = (d4 - d3) / 180.0 * Math.PI;
            d6 = Math.abs(d * Math.cos(d5 / 2.0));
            if (d - d6 < 0.5) {
                return;
            }
        }
        if (GfxTools.clipLine(point2 = new Point((int)point2d.x, (int)point2d.y), point = new Point(this.point1.x, this.point1.y), rectangle = graphics.getClipBounds())) {
            GfxTools.drawBrokenLine(graphics, point2.x, point2.y, point.x, point.y);
        }
        if (GfxTools.clipLine(point2 = new Point((int)point2d.x, (int)point2d.y), point = new Point(this.point2.x, this.point2.y), rectangle)) {
            GfxTools.drawBrokenLine(graphics, point2.x, point2.y, point.x, point.y);
        }
        if (d3 < d2) {
            d3 += 360.0;
        }
        if (d4 < d2) {
            d4 += 360.0;
        }
        this.markPlate.clear();
        Point2d point2d6 = this.plate.getRealLocationForScreenPoint((int)point2d.x, (int)point2d.y);
        Point2d point2d7 = this.plate.getRealLocationForScreenPoint((int)point2d.x + n, (int)point2d.y + n);
        double d7 = point2d7.x - point2d6.x;
        double d8 = point2d7.y - point2d6.y;
        boolean bl2 = bl = d4 <= d3 && d4 >= d2;
        if (bl) {
            GfxTools.drawArc(graphics, (int)point2d.x, (int)point2d.y, n, d2, d3 - d2);
            this.markPlate.drawArc(point2d6, d7, d8, d2, d3 - d2);
        } else {
            GfxTools.drawArc(graphics, (int)point2d.x, (int)point2d.y, n, d3, 360.0 - (d3 - d2));
            this.markPlate.drawArc(point2d6, d7, d8, d3, 360.0 - (d3 - d2));
        }
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, this.debug);
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }

    public void putAside(boolean bl) {
        this.point1 = null;
        this.point2 = null;
        this.point3 = null;
    }
}

