/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gui.GChoice;
import de.jave.gui.GChoiceTextField;
import de.jave.gui.VFlowLayout;
import de.jave.image.GGreyscaleImage;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2AsciiAlgorithm1;
import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class Image2AsciiAlgorithmJavE
extends Image2AsciiAlgorithm
implements ItemListener,
TextListener {
    protected GChoiceTextField tfNotUse;
    protected GChoice chTable;
    protected GChoice chQuality;
    protected Panel panel;
    protected static final String[] NOT_USE = new String[]{"<>_()[]{}/~-", "<>_()[]{}/~-[]\\@|#", ""};

    public Component getAdjustmentComponent() {
        if (this.panel == null) {
            this.tfNotUse = new GChoiceTextField("Do not use:", NOT_USE[0], 18);
            int n = 0;
            while (n < NOT_USE.length) {
                this.tfNotUse.add(NOT_USE[n]);
                ++n;
            }
            this.tfNotUse.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            this.tfNotUse.addTextListener(this);
            if (!AsciiGreyscaleTable.isInitialized()) {
                AsciiGreyscaleTable.init();
            }
            this.chTable = AsciiGreyscaleTable.createComponent();
            this.panel = new Panel();
            this.panel.setLayout(new VFlowLayout());
            this.panel.add(this.chTable);
            this.panel.add(this.tfNotUse);
            this.chTable.addItemListener(this);
        }
        return this.panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    public void textValueChanged(TextEvent textEvent) {
        this.adjustmentChanged();
    }

    public String getAlgorithmName() {
        return "JavE Algorithm (4/1)";
    }

    public int getVerticalPixelsPerChar() {
        return 8;
    }

    public int getHorizontalPixelsPerChar() {
        return 2;
    }

    public boolean requiresBWImage() {
        return false;
    }

    protected String getNotUse() {
        if (this.tfNotUse == null) {
            if (this.specialCharacters != null) {
                return this.specialCharacters;
            }
            return "";
        }
        return this.tfNotUse.getText();
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        int n;
        int n2;
        AsciiGreyscaleTable asciiGreyscaleTable = AsciiGreyscaleTable.getDefaultTable();
        asciiGreyscaleTable = this.chTable != null ? AsciiGreyscaleTable.getTable(this.chTable.getSelectedItem()) : this.greyscaleTable;
        int n3 = valueRaster.getWidth();
        int n4 = valueRaster.getHeight();
        CharacterPlate characterPlate = null;
        String string = this.getNotUse();
        asciiGreyscaleTable.setDoNotUse4(string);
        characterPlate = new CharacterPlate(n3 /= 2, n4 /= 8);
        GGreyscaleImage gGreyscaleImage = new GGreyscaleImage(n3, n4);
        int n5 = 0;
        while (n5 < n4) {
            Thread.yield();
            if (this.shallStop) {
                return null;
            }
            int n6 = n5 * 8;
            n2 = 0;
            while (n2 < n3) {
                n = n2 * 2;
                int n7 = (0 * valueRaster.getValueAt(n, n6) + 1 * valueRaster.getValueAt(n, n6 + 1) + 1 * valueRaster.getValueAt(n, n6 + 2) + 1 * valueRaster.getValueAt(n, n6 + 3)) / 3;
                int n8 = (1 * valueRaster.getValueAt(n, n6 + 4) + 1 * valueRaster.getValueAt(n, n6 + 5) + 1 * valueRaster.getValueAt(n, n6 + 6) + 0 * valueRaster.getValueAt(n, n6 + 7)) / 3;
                int n9 = (0 * valueRaster.getValueAt(n + 1, n6) + 1 * valueRaster.getValueAt(n + 1, n6 + 1) + 1 * valueRaster.getValueAt(n + 1, n6 + 2) + 1 * valueRaster.getValueAt(n + 1, n6 + 3)) / 3;
                int n10 = (1 * valueRaster.getValueAt(n + 1, n6 + 4) + 1 * valueRaster.getValueAt(n + 1, n6 + 5) + 1 * valueRaster.getValueAt(n + 1, n6 + 6) + 0 * valueRaster.getValueAt(n + 1, n6 + 7)) / 3;
                int n11 = (n7 + n9 + n8 + n10) / 4;
                gGreyscaleImage.set(n2, n5, n11);
                int n12 = 5;
                if (n7 <= n12 + n11 && n7 >= n11 - n12 && n9 <= n12 + n11 && n9 >= n11 - n12 && n8 <= n12 + n11 && n8 >= n11 - n12 && n10 <= n12 + n11 && n10 >= n11 - n12) {
                    characterPlate.setForce(n2, n5, '\u0000');
                } else {
                    characterPlate.setForce(n2, n5, asciiGreyscaleTable.getCharForBrightness(n7, n9, n8, n10));
                }
                ++n2;
            }
            this.progress(0.3 + 0.7 * (double)n5 / (double)n4);
            ++n5;
        }
        CharacterPlate characterPlate2 = Image2AsciiAlgorithm1.convert(gGreyscaleImage, asciiGreyscaleTable, true, string, this);
        if (characterPlate2 == null) {
            return null;
        }
        n2 = 0;
        while (n2 < n4) {
            Thread.yield();
            if (this.shallStop) {
                return null;
            }
            n = 0;
            while (n < n3) {
                if (characterPlate.get(n, n2) == '\u0000') {
                    characterPlate.setForce(n, n2, characterPlate2.get(n, n2));
                }
                ++n;
            }
            ++n2;
        }
        return characterPlate;
    }
}

