/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GBlackWhiteImage;
import de.jave.image.GGreyscaleImage;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.CharacterPlate;
import de.jave.jave.Filter;
import de.jave.jave.PixelPlate;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Image2AsciiAlgorithmEdgeDetect
extends Image2AsciiAlgorithm
implements ItemListener {
    protected Checkbox cbHires;

    public String getAlgorithmName() {
        return "Edge Detection";
    }

    public Component getAdjustmentComponent() {
        this.cbHires = new Checkbox("hi resolution", true);
        this.cbHires.addItemListener(this);
        return this.cbHires;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    protected boolean isHires() {
        if (this.cbHires != null) {
            return this.cbHires.getState();
        }
        return true;
    }

    public int getVerticalPixelsPerChar() {
        if (this.isHires()) {
            return 4;
        }
        return 1;
    }

    public int getHorizontalPixelsPerChar() {
        if (this.isHires()) {
            return 3;
        }
        return 1;
    }

    public boolean requiresBWImage() {
        return false;
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        if (!(valueRaster instanceof GGreyscaleImage)) {
            throw new RuntimeException("ValueRaster must be GGreyscalePixel in converter!");
        }
        int n = valueRaster.getWidth();
        int n2 = valueRaster.getHeight();
        GGreyscaleImage gGreyscaleImage = (GGreyscaleImage)valueRaster;
        GGreyscaleImage gGreyscaleImage2 = gGreyscaleImage.filterLaplace();
        gGreyscaleImage2.invert();
        GBlackWhiteImage gBlackWhiteImage = null;
        gBlackWhiteImage = gGreyscaleImage2.threshold(160, 210);
        gBlackWhiteImage.edgeReduction();
        GBlackWhiteImage gBlackWhiteImage2 = (GBlackWhiteImage)gBlackWhiteImage.getClone();
        gBlackWhiteImage2.edgeDespecle();
        int n3 = gBlackWhiteImage2.getWidth();
        int n4 = gBlackWhiteImage2.getHeight();
        if (this.isHires()) {
            PixelPlate.init();
            PixelPlate pixelPlate = new PixelPlate(0, 0, n3 / 3, n4 / 4);
            pixelPlate.setMode(0);
            int[][] nArray = gBlackWhiteImage2.getPixels();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < n3) {
                    if (nArray[n6][n5] < 128) {
                        pixelPlate.set(n6, n5);
                    }
                    ++n6;
                }
                ++n5;
            }
            pixelPlate.convert();
            char[][] cArray = pixelPlate.getResult().getContent();
            int n7 = 0;
            while (n7 < cArray.length) {
                int n8 = 0;
                while (n8 < cArray[0].length) {
                    if (cArray[n7][n8] == '\u0000') {
                        cArray[n7][n8] = 32;
                    }
                    ++n8;
                }
                ++n7;
            }
            return new CharacterPlate(cArray);
        }
        int[][] nArray = gBlackWhiteImage2.getPixels();
        char[][] cArray = new char[n4][n3];
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                cArray[n9][n10] = nArray[n10][n9] < 128 ? 35 : 32;
                ++n10;
            }
            ++n9;
        }
        Filter.init();
        Filter.filter(new CharacterPlate(cArray), 0);
        return new CharacterPlate(cArray);
    }
}

