/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.braille.BrailleDisplay;
import de.jave.braille.BrailleTable;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class Image2AsciiAlgorithmBraille
extends Image2AsciiAlgorithm
implements ItemListener {
    protected BrailleDisplay brailleDisplay;
    protected Panel adjustmentPanel;
    protected Choice chMode;

    public void setBrailleDisplay(BrailleDisplay brailleDisplay) {
        this.brailleDisplay = brailleDisplay;
    }

    public Component getAdjustmentComponent() {
        if (this.adjustmentPanel == null) {
            this.adjustmentPanel = new Panel();
            this.adjustmentPanel.setLayout(new BorderLayout());
            this.chMode = new Choice();
            int n = 0;
            while (n < BrailleTable.STR_TABLE.length) {
                this.chMode.addItem(BrailleTable.STR_TABLE[n]);
                ++n;
            }
            this.chMode.addItemListener(this);
            this.adjustmentPanel.add((Component)new Label("Braille Table:", 2), "West");
            this.adjustmentPanel.add((Component)this.chMode, "Center");
        }
        return this.adjustmentPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    public String getAlgorithmName() {
        return "Braille";
    }

    public int getVerticalPixelsPerChar() {
        return 4;
    }

    public int getHorizontalPixelsPerChar() {
        return 2;
    }

    public boolean requiresBWImage() {
        return true;
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        int n = 0;
        if (this.chMode != null) {
            n = this.chMode.getSelectedIndex();
        }
        int n2 = valueRaster.getWidth() / 2;
        int n3 = valueRaster.getHeight() / 4;
        CharacterPlate characterPlate = new CharacterPlate(n2, n3);
        int n4 = 0;
        while (n4 < n3) {
            Thread.yield();
            if (this.shallStop) {
                return null;
            }
            int n5 = 0;
            while (n5 < n2) {
                Thread.yield();
                if (this.shallStop) {
                    return null;
                }
                int n6 = 1 - valueRaster.getValueAt(n5 * 2, n4 * 4);
                int n7 = 1 - valueRaster.getValueAt(n5 * 2, n4 * 4 + 1);
                int n8 = 1 - valueRaster.getValueAt(n5 * 2, n4 * 4 + 2);
                int n9 = 1 - valueRaster.getValueAt(n5 * 2 + 1, n4 * 4);
                int n10 = 1 - valueRaster.getValueAt(n5 * 2 + 1, n4 * 4 + 1);
                int n11 = 1 - valueRaster.getValueAt(n5 * 2 + 1, n4 * 4 + 2);
                int n12 = 1 - valueRaster.getValueAt(n5 * 2, n4 * 4 + 3);
                int n13 = 1 - valueRaster.getValueAt(n5 * 2 + 1, n4 * 4 + 3);
                int n14 = n6 + 2 * n7 + 4 * n8 + 8 * n9 + 16 * n10 + 32 * n11 + 64 * n12 + 128 * n13;
                char c = (char)BrailleTable.getCodeForPattern(n14, n);
                while (Image2AsciiAlgorithmBraille.isNotDisplayable(c)) {
                    if (n13 == 1) {
                        n13 = 0;
                        n14 -= 128;
                    } else if (n12 == 1) {
                        n12 = 0;
                        n14 -= 64;
                    } else if (n11 == 1) {
                        n11 = 0;
                        n14 -= 32;
                    } else if (n10 == 1) {
                        n10 = 0;
                        n14 -= 16;
                    } else if (n9 == 1) {
                        n9 = 0;
                        n14 -= 8;
                    } else if (n8 == 1) {
                        n8 = 0;
                        n14 -= 4;
                    } else if (n7 == 1) {
                        n7 = 0;
                        n14 -= 2;
                    } else if (n6 == 1) {
                        n6 = 0;
                        --n14;
                    } else {
                        throw new RuntimeException("Fatal Error!");
                    }
                    c = (char)BrailleTable.getCodeForPattern(n14, n);
                }
                characterPlate.setForce(n5, n4, c);
                ++n5;
            }
            this.progress(0.3 + 0.7 * (double)n4 / (double)n3);
            ++n4;
        }
        String string = characterPlate.toString();
        if (this.brailleDisplay == null) {
            this.brailleDisplay = new BrailleDisplay(string);
            Frame frame = new Frame("Braille Display");
            frame.setLayout(new BorderLayout());
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(this.brailleDisplay);
            frame.add(scrollPane);
            frame.pack();
            frame.show();
        } else {
            this.brailleDisplay.setText(string);
        }
        this.brailleDisplay.setMode(n);
        if (this.shallStop) {
            return null;
        }
        return characterPlate;
    }

    public static final boolean isNotDisplayable(char c) {
        return c < ' ' || c == '\u007f' || c == '\u0080' || c >= '\u0082' && c <= '\u008c' || c == '\u008e' || c >= '\u0091' && c <= '\u009c' || c == '\u009e' || c == '\u0095';
    }
}

