/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.gui.GChoice;
import de.jave.gui.GChoiceTextField;
import de.jave.gui.VFlowLayout;
import de.jave.image.ValueRaster;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.jave.AsciiGreyscaleTable;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class Image2AsciiAlgorithm1
extends Image2AsciiAlgorithm
implements ItemListener,
TextListener {
    protected Panel panel;
    protected GChoice chTable;
    protected Checkbox cbDithering;
    protected GChoiceTextField tfNotUse;
    protected static final String[] NOT_USE = new String[]{"<>_()[]{}/~-", "<>_()[]{}/~-[]\\@|#", ""};

    public String getAlgorithmName() {
        return "1 Pixel per Character";
    }

    public int getVerticalPixelsPerChar() {
        return 1;
    }

    public int getHorizontalPixelsPerChar() {
        return 1;
    }

    public boolean requiresBWImage() {
        return false;
    }

    public Component getAdjustmentComponent() {
        if (this.panel == null) {
            if (!AsciiGreyscaleTable.isInitialized()) {
                AsciiGreyscaleTable.init();
            }
            this.chTable = AsciiGreyscaleTable.createComponent();
            this.chTable.addItemListener(this);
            this.tfNotUse = new GChoiceTextField("Do not use:", NOT_USE[0], 18);
            int n = 0;
            while (n < NOT_USE.length) {
                this.tfNotUse.add(NOT_USE[n]);
                ++n;
            }
            this.tfNotUse.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            this.tfNotUse.addTextListener(this);
            this.cbDithering = new Checkbox("error correction", true);
            this.cbDithering.addItemListener(this);
            this.panel = new Panel();
            this.panel.setLayout(new VFlowLayout());
            this.panel.add(this.chTable);
            this.panel.add(this.tfNotUse);
            this.panel.add(this.cbDithering);
        }
        return this.panel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.adjustmentChanged();
    }

    protected String getNotUse() {
        if (this.tfNotUse == null) {
            if (this.specialCharacters != null) {
                return this.specialCharacters;
            }
            return "";
        }
        return this.tfNotUse.getText();
    }

    public CharacterPlate convert(ValueRaster valueRaster) {
        String string = this.getNotUse();
        AsciiGreyscaleTable asciiGreyscaleTable = AsciiGreyscaleTable.getDefaultTable();
        asciiGreyscaleTable = this.chTable != null ? AsciiGreyscaleTable.getTable(this.chTable.getSelectedItem()) : this.greyscaleTable;
        boolean bl = this.cbDithering != null && this.cbDithering.getState();
        return Image2AsciiAlgorithm1.convert(valueRaster, asciiGreyscaleTable, bl, string, this);
    }

    public static final CharacterPlate convert(ValueRaster valueRaster, AsciiGreyscaleTable asciiGreyscaleTable, boolean bl, String string, Image2AsciiAlgorithm image2AsciiAlgorithm) {
        asciiGreyscaleTable.setDoNotUse(string);
        int n = valueRaster.getWidth();
        int n2 = valueRaster.getHeight();
        CharacterPlate characterPlate = new CharacterPlate(n, n2);
        if (bl) {
            int[][] nArray = new int[n + 4][3];
            int n3 = 0;
            while (n3 < n2) {
                Thread.yield();
                if (image2AsciiAlgorithm != null && image2AsciiAlgorithm.shallStop) {
                    return null;
                }
                int n4 = n3 % 3;
                int n5 = (n3 + 1) % 3;
                int n6 = (n3 + 2) % 3;
                int n7 = 0;
                while (n7 < n) {
                    double d = 0.0;
                    d += 0.023809523809523808 * (double)nArray[n7][n4];
                    d += 0.047619047619047616 * (double)nArray[n7 + 1][n4];
                    d += 0.09523809523809523 * (double)nArray[n7 + 2][n4];
                    d += 0.047619047619047616 * (double)nArray[n7 + 3][n4];
                    d += 0.023809523809523808 * (double)nArray[n7 + 4][n4];
                    d += 0.047619047619047616 * (double)nArray[n7][n5];
                    d += 0.09523809523809523 * (double)nArray[n7 + 1][n5];
                    d += 0.19047619047619047 * (double)nArray[n7 + 2][n5];
                    d += 0.09523809523809523 * (double)nArray[n7 + 3][n5];
                    d += 0.047619047619047616 * (double)nArray[n7 + 4][n5];
                    d += 0.09523809523809523 * (double)nArray[n7][n6];
                    int n8 = (int)((double)valueRaster.getValueAt(n7, n3) - (d += 0.19047619047619047 * (double)nArray[n7 + 1][n6]));
                    char c = asciiGreyscaleTable.getCharForBrightness(n8);
                    characterPlate.setForce(n7, n3, c);
                    nArray[n7 + 2][n6] = asciiGreyscaleTable.getBrightnessForChar(c) - n8;
                    ++n7;
                }
                if (image2AsciiAlgorithm != null) {
                    image2AsciiAlgorithm.progress(0.3 + 0.7 * (double)n3 / (double)n2);
                }
                ++n3;
            }
        } else {
            int n9 = 0;
            while (n9 < n2) {
                Thread.yield();
                if (image2AsciiAlgorithm != null && image2AsciiAlgorithm.shallStop) {
                    return null;
                }
                int n10 = 0;
                while (n10 < n) {
                    int n11 = valueRaster.getValueAt(n10, n9);
                    characterPlate.setForce(n10, n9, asciiGreyscaleTable.getCharForBrightness(n11));
                    ++n10;
                }
                if (image2AsciiAlgorithm != null) {
                    image2AsciiAlgorithm.progress(0.3 + 0.7 * (double)n9 / (double)n2);
                }
                ++n9;
            }
        }
        return characterPlate;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.adjustmentChanged();
    }
}

