/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;

class TooltipWindow
extends Window {
    protected static final Color COLOR_BACKGROUND = new Color(255, 255, 225);
    protected static final Color COLOR_FOREGROUND = Color.black;
    protected String tipText = null;
    protected Component tipComponent = null;

    TooltipWindow(Frame frame) {
        super(frame);
    }

    synchronized void setTip(Object object) {
        if (this.tipComponent != null) {
            this.remove(this.tipComponent);
        }
        if (object instanceof String) {
            this.tipText = (String)object;
            this.tipComponent = null;
            this.validate();
        } else {
            this.tipText = null;
            this.tipComponent = (Component)object;
            this.add(this.tipComponent);
            this.validate();
        }
    }

    public Dimension getPreferredSize() {
        if (this.tipComponent != null) {
            return this.tipComponent.getPreferredSize();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.tipText) + 5;
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 1;
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        if (this.tipText != null) {
            Dimension dimension = this.getSize();
            graphics.setColor(COLOR_BACKGROUND);
            graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(COLOR_FOREGROUND);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.drawString(this.tipText, 2, dimension.height - fontMetrics.getMaxDescent() - 1);
        } else {
            super.paint(graphics);
        }
    }
}

