/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GGridLayout;
import de.jave.gui.GSlider;
import de.jave.gui.GUpDownArrangement;
import gebhard.uielements.DoubleTextField;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import gebhard.uielements.NumberTextField;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class GSliderArrangement
extends Panel
implements Adjustable,
NumberListener,
AdjustmentListener {
    protected GSlider slider;
    protected NumberTextField numberTextField;
    protected Label label;
    protected GUpDownArrangement upDownArrangement;
    protected int minValue;
    protected int maxValue;
    protected int defaultValue;
    protected int step;
    protected int divide;
    transient AdjustmentListener adjustmentListener;

    public GSliderArrangement(String string, int n, int n2, int n3, int n4, int n5) {
        this.minValue = n;
        this.maxValue = n2;
        this.defaultValue = n3;
        this.step = n4;
        this.divide = n5;
        this.label = new Label(string, 2);
        this.numberTextField = n5 == 1 ? new IntegerTextField(n3, n, n2, n4) : new DoubleTextField((double)n3 / (double)n5, (double)n / (double)n5, (double)n2 / (double)n5, (double)n4 / (double)n5);
        this.slider = new GSlider(n3, n, n2, n4);
        this.slider.addAdjustmentListener(this);
        this.numberTextField.addNumberListener(this);
        this.upDownArrangement = new GUpDownArrangement(this.numberTextField);
        this.setLayout(new GGridLayout(1, 0));
        this.add(this.label);
        this.add(this.slider);
        this.add(this.upDownArrangement);
    }

    public void setDefault() {
        this.reset();
    }

    public void reset() {
        this.setValue(this.defaultValue);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.numberTextField.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.label.setEnabled(bl);
        this.upDownArrangement.setEnabled(bl);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public int getValue() {
        if (this.divide == 1) {
            return ((IntegerTextField)this.numberTextField).getValue();
        }
        return (int)(((DoubleTextField)this.numberTextField).getValue() * (double)this.divide);
    }

    public double getDValue() {
        if (this.divide == 1) {
            return ((IntegerTextField)this.numberTextField).getValue();
        }
        return ((DoubleTextField)this.numberTextField).getValue();
    }

    public void setValue(int n) {
        this.slider.setValue(n);
        if (this.divide == 1) {
            ((IntegerTextField)this.numberTextField).setValue(n);
        } else {
            ((DoubleTextField)this.numberTextField).setValue((double)n / (double)this.divide);
        }
    }

    public int getOrientation() {
        return 0;
    }

    public void setMinimum(int n) {
        this.minValue = n;
        this.slider.setMinimum(n);
        if (this.divide == 1) {
            ((IntegerTextField)this.numberTextField).setMinimum(n);
        } else {
            ((DoubleTextField)this.numberTextField).setMinimum((double)n / (double)this.divide);
        }
    }

    public void setMaximum(int n) {
        this.maxValue = n;
        this.slider.setMaximum(n);
        if (this.divide == 1) {
            ((IntegerTextField)this.numberTextField).setMaximum(n);
        } else {
            ((DoubleTextField)this.numberTextField).setMaximum((double)n / (double)this.divide);
        }
    }

    public int getMinimum() {
        return this.minValue;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setUnitIncrement(int n) {
    }

    public void setBlockIncrement(int n) {
    }

    public int getUnitIncrement() {
        return 1;
    }

    public int getBlockIncrement() {
        return 1;
    }

    public void setVisibleAmount(int n) {
    }

    public int getVisibleAmount() {
        return 1;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.slider.getValue();
        if (this.divide == 1) {
            ((IntegerTextField)this.numberTextField).setValue(n);
        } else {
            ((DoubleTextField)this.numberTextField).setValue((double)n / (double)this.divide);
        }
    }

    public void numberChanged(NumberEvent numberEvent) {
        int n = 0;
        n = this.divide == 1 ? ((IntegerTextField)this.numberTextField).getValue() : (int)(((DoubleTextField)this.numberTextField).getValue() * (double)this.divide);
        this.slider.setValue(n);
        this.processAdjustmentEvent(new AdjustmentEvent(this, 0, 601, n));
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setLayout(new GridLayout(0, 1));
        GSliderArrangement gSliderArrangement = new GSliderArrangement("Integer", 0, 10, 5, 1, 1);
        frame.add(gSliderArrangement);
        GSliderArrangement gSliderArrangement2 = new GSliderArrangement("Double", 0, 10, 5, 1, 10);
        frame.add(gSliderArrangement2);
        gSliderArrangement.setEnabled(false);
        frame.pack();
        frame.show();
    }
}

