/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxTools;
import de.jave.gui.SystemExitWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class GSlider
extends Canvas
implements Adjustable,
KeyListener,
FocusListener,
MouseListener,
MouseMotionListener {
    protected int value;
    protected int min;
    protected int max;
    protected int step;
    transient AdjustmentListener adjustmentListener;
    private boolean focus = false;
    public static final int DEFAULT_VALUE = 0;
    public static final int DEFAULT_MIN = -100;
    public static final int DEFAULT_MAX = 100;
    public static final int DEFAULT_STEP = 1;
    protected boolean mouseSlides;
    protected int oldX;
    protected int oldXValue;

    public GSlider() {
        this(0);
    }

    public GSlider(int n) {
        this(n, -100, 100);
    }

    public GSlider(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public GSlider(int n, int n2, int n3, int n4) {
        this.value = n;
        this.min = n2;
        this.max = n3;
        this.step = n4;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mouseSlides = false;
    }

    public void setValue(int n) {
        if (n < this.min) {
            n = this.min;
        }
        if (n > this.max) {
            n = this.max;
        }
        if (this.value == n) {
            return;
        }
        int n2 = this.computeSliderXFromValue(this.value);
        int n3 = this.computeSliderXFromValue(n);
        this.value = n;
        if (n2 != n3) {
            this.repaint();
        }
        this.processAdjustmentEvent(new AdjustmentEvent(this, 0, 601, this.value));
    }

    public int getValue() {
        return this.value;
    }

    protected void processAdjustmentEvent(AdjustmentEvent adjustmentEvent) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    public int getOrientation() {
        return 0;
    }

    public void setMinimum(int n) {
        this.min = n;
        this.repaint();
    }

    public void setMaximum(int n) {
        this.max = n;
        this.repaint();
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setUnitIncrement(int n) {
    }

    public void setBlockIncrement(int n) {
    }

    public int getUnitIncrement() {
        return 1;
    }

    public int getBlockIncrement() {
        return 1;
    }

    public void setVisibleAmount(int n) {
    }

    public int getVisibleAmount() {
        return 1;
    }

    public void inc() {
        this.setValue(this.getValue() + this.step);
    }

    public void dec() {
        this.setValue(this.getValue() - this.step);
    }

    public synchronized void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, adjustmentListener);
    }

    public synchronized void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, adjustmentListener);
    }

    public Dimension getPreferredSize() {
        return new Dimension(99, 35);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        boolean bl = this.isEnabled();
        int n = 10;
        int n2 = 87;
        int n3 = 23;
        if (bl) {
            graphics.setColor(SystemColor.controlDkShadow);
        } else {
            graphics.setColor(SystemColor.controlShadow);
        }
        graphics.drawLine(n, n3, n2, n3);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n - 1, n3 + 2, n2 + 2, n3 + 2);
        graphics.drawLine(n2 + 2, n3 - 1, n2 + 2, n3 + 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n - 1, n3 + 1, n - 1, n3);
        graphics.drawLine(n - 1, n3 - 1, n2 + 1, n3 - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n, n3 + 1, n2, n3 + 1);
        graphics.drawLine(n2 + 1, n3, n2 + 1, n3 + 1);
        if (bl) {
            graphics.setColor(SystemColor.controlText);
            GSlider.drawScale(graphics, 0, 0);
        } else {
            graphics.setColor(SystemColor.controlLtHighlight);
            GSlider.drawScale(graphics, 1, 1);
            graphics.setColor(SystemColor.controlShadow);
            GSlider.drawScale(graphics, 0, 0);
        }
        int n4 = this.computeSliderXFromValue(this.value);
        n = n4 - 5;
        n2 = n4 + 5;
        int n5 = 12;
        int n6 = n5 + 5;
        int n7 = 31;
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n4, n5, n2, n6);
        graphics.drawLine(n2, n6, n2, n7);
        graphics.drawLine(n, n7, n2, n7);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n4 - 1, n5 + 1, n, n6);
        graphics.drawLine(n, n6, n, n7 - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n4, n5 + 1, n2 - 1, n6);
        graphics.drawLine(n2 - 1, n6, n2 - 1, n7 - 1);
        graphics.drawLine(n + 1, n7 - 1, n2 - 1, n7 - 1);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n4 - 1, n5 + 2, n + 1, n6);
        graphics.drawLine(n + 1, n6, n + 1, n7 - 2);
        graphics.setColor(SystemColor.control);
        int[] nArray = new int[]{n4, n2 - 2, n2 - 2, n + 2, n + 2};
        int[] nArray2 = new int[]{n5 + 2, n6, n7 - 2, n7 - 2, n6};
        graphics.fillPolygon(nArray, nArray2, nArray.length);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
        if (this.focus) {
            graphics.setColor(Color.black);
            GfxTools.drawDottedRectangle(graphics, 1, 1, dimension.width - 3, dimension.height - 3);
        }
    }

    protected static final void drawScale(Graphics graphics, int n, int n2) {
        int n3 = 10 + n2;
        int n4 = 0;
        while (n4 <= 10) {
            int n5 = n4 * 7 + 14 + n;
            if (n4 % 5 == 0) {
                graphics.drawLine(n5, n3, n5, n3 - 4);
            } else {
                graphics.drawLine(n5, n3, n5, n3 - 3);
            }
            ++n4;
        }
    }

    protected int computeSliderXFromValue(int n) {
        return 14 + 70 * (n - this.min) / (this.max - this.min);
    }

    protected int computeValueFromSliderX(int n) {
        return (n - 14) * (this.max - this.min) / 70 + this.min;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        Point point = mouseEvent.getPoint();
        if (point.y > 31 || point.y < 13) {
            return;
        }
        int n = this.computeSliderXFromValue(this.value);
        if (point.x > n + 5 || point.x < n - 5) {
            return;
        }
        this.mouseSlides = true;
        this.oldX = point.x;
        this.oldXValue = this.computeSliderXFromValue(this.value);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseSlides = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mouseSlides) {
            return;
        }
        int n = mouseEvent.getPoint().x;
        int n2 = n - this.oldX;
        if (n2 == 0) {
            return;
        }
        int n3 = this.oldXValue + n2;
        int n4 = this.computeValueFromSliderX(n3);
        this.setValue(n4);
        this.oldXValue = n3;
        this.oldX = n;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 39 || n == 38) {
            this.inc();
            return;
        }
        if (n == 37 || n == 40) {
            this.dec();
            return;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addWindowListener(SystemExitWindowListener.instance());
        frame.setLayout(new FlowLayout());
        frame.add(new GSlider());
        frame.add(new GSlider(0, -10, 10, 2));
        frame.pack();
        frame.show();
        frame.validate();
    }
}

