/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class GChoiceTextFieldButton
extends Canvas
implements MouseListener {
    protected boolean pressed = false;
    protected PopupMenu menu;

    public GChoiceTextFieldButton(PopupMenu popupMenu) {
        this.menu = popupMenu;
        this.enableEvents(16L);
    }

    public Dimension getPreferredSize() {
        return new Dimension(20, 21);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width / 2 - 1;
        int n2 = dimension.height / 2 - 1;
        if (!this.isEnabled()) {
            graphics.setColor(SystemColor.controlLtHighlight);
            GChoiceTextFieldButton.drawArrow(graphics, n + 1, n2 + 1);
            graphics.setColor(SystemColor.controlShadow);
            GChoiceTextFieldButton.drawArrow(graphics, n, n2);
        } else if (this.pressed) {
            graphics.setColor(this.getForeground());
            GChoiceTextFieldButton.drawArrow(graphics, n + 1, n2 + 1);
        } else {
            graphics.setColor(this.getForeground());
            GChoiceTextFieldButton.drawArrow(graphics, n, n2);
        }
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 1, 0, dimension.height - 2);
        graphics.drawLine(2, dimension.height - 4, dimension.width - 4, dimension.height - 4);
        graphics.drawLine(dimension.width - 4, dimension.height - 5, dimension.width - 4, 3);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(1, 1, dimension.width - 3, 1);
        graphics.drawLine(dimension.width - 3, 2, dimension.width - 3, dimension.height - 3);
        graphics.drawLine(dimension.width - 4, dimension.height - 3, 1, dimension.height - 3);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(1, 2, dimension.width - 4, 2);
        graphics.drawLine(1, 3, 1, dimension.height - 4);
        graphics.drawLine(0, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, 1, dimension.width - 2, dimension.height - 3);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 2, dimension.height - 1, 0, dimension.height - 1);
        graphics.drawLine(2, 3, dimension.width - 5, 3);
        graphics.drawLine(2, 4, 2, dimension.height - 5);
    }

    protected static final void drawArrow(Graphics graphics, int n, int n2) {
        graphics.drawLine(n - 3, n2 - 1, n + 3, n2 - 1);
        graphics.drawLine(n - 2, n2, n + 2, n2);
        graphics.drawLine(n - 1, n2 + 1, n + 1, n2 + 1);
        graphics.drawLine(n, n2 + 2, n, n2 + 2);
    }

    public void showPopup() {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(this.menu.getFont());
        int n2 = this.menu.getItemCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = fontMetrics.stringWidth(this.menu.getItem(n4).getLabel());
            if (n > n3) {
                n3 = n;
            }
            ++n4;
        }
        n = -n3 - 10;
        int n5 = this.getSize().height - 2;
        this.menu.show(this, n, n5);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || (mouseEvent.getModifiers() & 0x1F5) > 0) {
            this.showPopup();
        }
        super.processMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

