/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxTools;
import de.jave.gui.GuiTools;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public abstract class GButton
extends Canvas
implements MouseListener,
FocusListener,
KeyListener {
    transient ActionListener actionListener;
    protected Dimension preferredSize = null;
    public String name;
    protected static final Dimension DEFAULT_SIZE = new Dimension(24, 23);
    protected boolean lockable = false;
    protected boolean unlockable = true;
    protected boolean pressed = false;
    protected boolean locked = false;
    protected boolean pressedByKey;
    protected boolean focus = false;
    protected boolean focusTraversable = true;
    protected boolean isEnabled = true;
    protected boolean mouseOver = false;
    public static final int MODE_3D_TRADITIONAL = 0;
    public static final int MODE_3D_MODERN = 1;
    protected int mode3D = 0;

    public GButton() {
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setEnabled(true);
    }

    public void set3DMode(int n) {
        this.mode3D = n;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (!this.isEnabled) {
            if (this.mode3D == 0) {
                GuiTools.draw3dRectangleUp(graphics, 0, 0, dimension.width, dimension.height);
            }
            return;
        }
        if (this.pressed || this.lockable && this.locked) {
            if (this.mode3D == 0) {
                GuiTools.draw3dRectangleDown(graphics, 0, 0, dimension.width, dimension.height);
            } else if (this.mode3D == 1) {
                GuiTools.drawSmall3dRectangleDown(graphics, 0, 0, dimension.width, dimension.height);
            }
        } else if (this.mode3D == 0) {
            GuiTools.draw3dRectangleUp(graphics, 0, 0, dimension.width, dimension.height);
        } else if (this.mode3D == 1 && this.mouseOver) {
            GuiTools.drawSmall3dRectangleUp(graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled != bl) {
            this.isEnabled = bl;
            this.repaint();
        }
    }

    public void enable(boolean bl) {
        this.setEnabled(bl);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isReallyEnabled() {
        return this.isEnabled;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.isFocusTraversable()) {
            this.focus = true;
            this.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public void setFocusTraversable(boolean bl) {
        this.focusTraversable = bl;
    }

    public boolean isFocusTraversable() {
        return this.focusTraversable;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void drawFocus(Graphics graphics, Dimension dimension) {
        if (this.focus) {
            graphics.setColor(Color.black);
            GfxTools.drawDottedRectangle(graphics, 3, 3, dimension.width - 7, dimension.height - 7);
        }
    }

    public Dimension getPreferredSize() {
        return this.preferredSize != null ? this.preferredSize : DEFAULT_SIZE;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setLocked() {
        this.setLocked(true);
    }

    public void setLocked(boolean bl) {
        if (this.locked != bl) {
            this.pressed = false;
            this.pressedByKey = false;
            this.locked = bl;
            this.repaint();
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLockable(boolean bl) {
        this.lockable = bl;
    }

    public void setUnlockable(boolean bl) {
        this.unlockable = bl;
    }

    public void setToggleButton(boolean bl) {
        this.setLockable(bl);
        this.setUnlockable(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        ActionEvent actionEvent;
        if (!this.pressed) {
            return;
        }
        if (this.lockable && this.locked && !this.unlockable) {
            return;
        }
        if (this.lockable && this.locked) {
            this.pressed = false;
            actionEvent = new ActionEvent(this, 1001, this.name + "OFF");
            this.setLocked(false);
        } else if (this.lockable && !this.locked) {
            actionEvent = new ActionEvent(this, 1001, this.name + "ON");
            this.setLocked(true);
        } else {
            actionEvent = new ActionEvent(this, 1001, this.name);
            this.pressed = false;
            this.repaint();
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isFocusTraversable()) {
            this.requestFocus();
        }
        if (!this.isEnabled) {
            return;
        }
        this.pressed = true;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        if (this.mode3D == 1) {
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.pressed && !this.pressedByKey) {
            this.pressed = false;
            this.repaint();
            return;
        }
        this.mouseOver = false;
        if (this.mode3D == 1) {
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.isEnabled && keyEvent.getKeyChar() == ' ' && !this.pressed) {
            this.pressed = true;
            this.pressedByKey = true;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        ActionEvent actionEvent;
        if (!this.pressed || !this.pressedByKey) {
            return;
        }
        this.pressedByKey = false;
        if (this.lockable && this.locked && !this.unlockable) {
            return;
        }
        if (this.lockable && this.locked) {
            this.pressed = false;
            actionEvent = new ActionEvent(this, 1001, this.name + "OFF");
            this.setLocked(false);
        } else if (this.lockable && !this.locked) {
            actionEvent = new ActionEvent(this, 1001, this.name + "ON");
            this.setLocked(true);
        } else {
            actionEvent = new ActionEvent(this, 1001, this.name);
            this.pressed = false;
            this.repaint();
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }
}

