/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gfx.GfxTools;
import de.jave.gui.GSmallTextButton;
import de.jave.gui.GTextButton;
import de.jave.gui.SystemExitWindowListener;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class CharField
extends Canvas
implements KeyListener,
FocusListener,
MouseListener {
    protected static final int PREFERRED_WIDTH = 16;
    protected static final int PREFERRED_HEIGHT = 20;
    protected char ch;
    transient TextListener textListener;
    private boolean focus = false;
    private boolean editable = true;
    protected String historyString;
    protected int historyIndex = -1;
    protected int HISTORY_MAX_LENGTH = 50;

    public CharField() {
        this(' ');
    }

    public CharField(char c) {
        this.ch = c;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.historyAdd(c);
    }

    public void setChar(char c) {
        if (this.ch == c) {
            return;
        }
        this.ch = c;
        this.repaint();
    }

    public char getChar() {
        return this.ch;
    }

    public void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    public Dimension getPreferredSize() {
        return new Dimension(16, 20);
    }

    public Dimension getMinimumSize() {
        return new Dimension(16, 20);
    }

    public Dimension getMaximumSize() {
        return new Dimension(16, 20);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.darkGray);
        graphics.drawLine(0, 0, dimension.width - 1, 0);
        graphics.drawLine(0, 1, 0, dimension.height - 1);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(1, dimension.height - 2, dimension.width - 2, dimension.height - 2);
        graphics.drawLine(dimension.width - 2, dimension.height - 3, dimension.width - 2, 1);
        graphics.setColor(Color.white);
        graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 2, dimension.width - 1, 0);
        graphics.setColor(Color.black);
        graphics.drawLine(1, 1, dimension.width - 3, 1);
        graphics.drawLine(1, 2, 1, dimension.height - 3);
        if (this.isEnabled()) {
            graphics.setColor(SystemColor.controlText);
            this.draw(graphics, dimension, 0, 0);
        } else {
            graphics.setColor(SystemColor.controlLtHighlight);
            this.draw(graphics, dimension, 1, 1);
            graphics.setColor(SystemColor.controlShadow);
            this.draw(graphics, dimension, 0, 0);
        }
        if (this.focus) {
            graphics.setColor(Color.black);
            GfxTools.drawDottedRectangle(graphics, 3, 3, dimension.width - 7, dimension.height - 7);
        }
    }

    protected final void draw(Graphics graphics, Dimension dimension, int n, int n2) {
        if (this.ch == '\u00a0') {
            graphics.drawLine(n + 2, n2 + 2, n + dimension.width - 3, n2 + dimension.height - 3);
            graphics.drawLine(n + dimension.width - 3, n2 + 2, n + 2, n2 + dimension.height - 3);
        } else {
            graphics.drawString(String.valueOf(this.ch), n + 5 + (dimension.width - 16) / 2, n2 + 15);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.editable) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            return;
        }
        if (n == 39 || n == 40) {
            this.historyForward();
            return;
        }
        if (n == 37 || n == 38) {
            this.historyBackward();
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c < ' ' || c > '\u00ff' || c > '~' && c < '\u0091') {
            return;
        }
        if (c == ' ' && keyEvent.isShiftDown()) {
            c = '\u00a0';
        }
        if (this.ch != c) {
            this.ch = c;
            this.historyAdd(this.ch);
            this.repaint();
            if (this.textListener != null) {
                this.textListener.textValueChanged(new TextEvent(this, 900));
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected synchronized void historyForward() {
        if (this.historyString.length() <= this.historyIndex + 1) {
            return;
        }
        ++this.historyIndex;
        this.setChar(this.historyString.charAt(this.historyIndex));
    }

    protected synchronized void historyBackward() {
        if (this.historyIndex < 1) {
            return;
        }
        --this.historyIndex;
        this.setChar(this.historyString.charAt(this.historyIndex));
    }

    protected synchronized void historyAdd(char c) {
        if (this.historyString == null || this.historyIndex == -1) {
            this.historyString = String.valueOf(c);
            this.historyIndex = 0;
            return;
        }
        if (this.historyString.charAt(this.historyIndex) == c) {
            return;
        }
        this.historyString = this.historyString.substring(0, this.historyIndex + 1) + String.valueOf(c);
        ++this.historyIndex;
        if (this.historyIndex + 1 > this.HISTORY_MAX_LENGTH) {
            this.historyString = this.historyString.substring(1);
            --this.historyIndex;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.focus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.focus = false;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.addWindowListener(SystemExitWindowListener.instance());
        frame.setLayout(new FlowLayout());
        CharField charField = new CharField('X');
        charField.setBackground(new Color(131, 187, 186));
        frame.add(charField);
        frame.add(new CharField('O'));
        frame.add(new GTextButton("GTextButton"));
        frame.add(new GSmallTextButton("GSmallTextButton"));
        frame.pack();
        frame.show();
        frame.validate();
    }
}

