/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gfx;

import de.jave.gfx.DepthComparable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class GfxTools {
    protected static final int TOP = 8;
    protected static final int BOTTOM = 4;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 1;

    private GfxTools() {
    }

    public static double distance(Point point, Point point2) {
        return Math.sqrt(Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0));
    }

    public static double distance2(Point point, Point point2) {
        return Math.pow(point.x - point2.x, 2.0) + Math.pow(point.y - point2.y, 2.0);
    }

    public static void drawDottedRectangle(Graphics graphics, Color color, Color color2, Rectangle rectangle) {
        GfxTools.drawDottedRectangle(graphics, color, color2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawDottedRectangle(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(color2);
        GfxTools.drawDottedRectangle(graphics, n, n2, n3, n4);
    }

    public static void drawDottedRectangle(Graphics graphics, Rectangle rectangle) {
        GfxTools.drawDottedRectangle(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawDottedRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        GfxTools.drawBrokenHorizontalLine(graphics, n, n + n3, n2, 1, 0);
        GfxTools.drawBrokenHorizontalLine(graphics, n, n + n3, n2 + n4, 1, 0);
        GfxTools.drawBrokenVerticalLine(graphics, n, n2, n2 + n4, 1, 0);
        GfxTools.drawBrokenVerticalLine(graphics, n + n3, n2, n2 + n4, 1, 0);
    }

    public static void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        GfxTools.drawBrokenLine(graphics, n, n2, n3, n4, 1);
    }

    public static void drawDottedLine(Graphics graphics, Point point, Point point2) {
        GfxTools.drawBrokenLine(graphics, point, point2, 1);
    }

    public static void drawBrokenLine(Graphics graphics, Point point, Point point2, int n) {
        GfxTools.drawBrokenLine(graphics, point.x, point.y, point2.x, point2.y, n);
    }

    public static void drawBrokenLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GfxTools.drawBrokenLine(graphics, n, n2, n3, n4, n5, 0);
    }

    public static void drawBrokenLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 == n2) {
            GfxTools.drawBrokenHorizontalLine(graphics, n, n3, n2, n5, n6);
            return;
        }
        if (n3 == n) {
            GfxTools.drawBrokenVerticalLine(graphics, n, n2, n4, n5, n6);
            return;
        }
        double d = Math.sqrt(Math.pow(n - n3, 2.0) + Math.pow(n2 - n4, 2.0));
        double d2 = (double)(n3 - n) / d * (double)n5;
        double d3 = (double)(n4 - n2) / d * (double)n5;
        double d4 = d2;
        double d5 = d3;
        if (d4 > 0.0) {
            d4 -= 1.0;
        }
        if (d5 > 0.0) {
            d5 -= 1.0;
        }
        if (d4 < 0.0) {
            d4 += 1.0;
        }
        if (d5 < 0.0) {
            d5 += 1.0;
        }
        double d6 = d * d;
        double d7 = (double)n6 / (double)n5;
        while (Math.pow(d7 * d2 + d4, 2.0) + Math.pow(d7 * d3 + d5, 2.0) <= d6) {
            graphics.drawLine(n + (int)(d7 * d2), n2 + (int)(d7 * d3), n + (int)(d7 * d2 + d4), n2 + (int)(d7 * d3 + d5));
            d7 += 2.0;
        }
    }

    public static void drawBrokenHorizontalLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        n7 = n;
        while (n7 <= n2) {
            int n8 = (n7 + n4 * 2 - n5) % (n4 * 2);
            if (n8 < n4) {
                ++n6;
            } else if (n6 > 0) {
                graphics.drawLine(n7 - n6, n3, n7 - 1, n3);
                n6 = 0;
            }
            ++n7;
        }
        if (n6 > 0) {
            graphics.drawLine(n7 - n6, n3, n7 - 1, n3);
        }
    }

    public static void drawBrokenVerticalLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        n7 = n2;
        while (n7 <= n3) {
            int n8 = (n7 + n4 * 2 - n5) % (n4 * 2);
            if (n8 < n4) {
                ++n6;
            } else if (n6 > 0) {
                graphics.drawLine(n, n7 - n6, n, n7 - 1);
                n6 = 0;
            }
            ++n7;
        }
        if (n6 > 0) {
            graphics.drawLine(n, n7 - n6, n, n7 - 1);
        }
    }

    public static void drawBrokenRectangle(Graphics graphics, Color color, Color color2, Rectangle rectangle) {
        GfxTools.drawBrokenRectangle(graphics, color, color2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawBrokenRectangle(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4) {
        GfxTools.drawBrokenRectangle(graphics, color, color2, n, n2, n3, n4, 0);
    }

    public static void drawBrokenRectangle(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(color);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(color2);
        GfxTools.drawBrokenRectangle(graphics, n, n2, n3, n4, n5);
    }

    public static void drawBrokenRectangle(Graphics graphics, Rectangle rectangle) {
        GfxTools.drawBrokenRectangle(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void drawBrokenRectangle(Graphics graphics, int n, int n2, int n3, int n4) {
        GfxTools.drawBrokenRectangle(graphics, n, n2, n3, n4, 0);
    }

    public static void drawBrokenRectangle(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GfxTools.drawBrokenHorizontalLine(graphics, n, n + n3, n2, 3, n5);
        GfxTools.drawBrokenHorizontalLine(graphics, n, n + n3, n2 + n4, 3, n5);
        GfxTools.drawBrokenVerticalLine(graphics, n, n2, n2 + n4, 3, n5);
        GfxTools.drawBrokenVerticalLine(graphics, n + n3, n2, n2 + n4, 3, n5);
    }

    public static void drawBrokenLine(Graphics graphics, Point point, Point point2) {
        GfxTools.drawBrokenLine(graphics, point, point2, 3);
    }

    public static void drawBrokenLine(Graphics graphics, int n, int n2, int n3, int n4) {
        GfxTools.drawBrokenLine(graphics, n, n2, n3, n4, 3);
    }

    public static void paintArrow(Graphics graphics, Point point, Point point2) {
        GfxTools.paintArrow(graphics, point.x, point.y, point2.x, point2.y);
    }

    public static void paintArrow(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n - n3;
        double d2 = n2 - n4;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = -(d2 /= d3) * 3.0;
        double d5 = (d /= d3) * 3.0;
        graphics.drawLine(n3, n4, n3 + (int)((d *= 8.0) + d4), n4 + (int)((d2 *= 8.0) + d5));
        graphics.drawLine(n3, n4, n3 + (int)(d - d4), n4 + (int)(d2 - d5));
    }

    public static void paintArrowFilled(Graphics graphics, Point point, Point point2) {
        GfxTools.paintArrowFilled(graphics, point.x, point.y, point2.x, point2.y);
    }

    public static void paintArrowFilled(Graphics graphics, int n, int n2, int n3, int n4) {
        double d = n - n3;
        double d2 = n2 - n4;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = -(d2 /= d3) * 4.0;
        double d5 = (d /= d3) * 4.0;
        Polygon polygon = new Polygon();
        polygon.addPoint(n3, n4);
        polygon.addPoint(n3 + (int)((d *= 10.0) + d4), n4 + (int)((d2 *= 10.0) + d5));
        polygon.addPoint(n3 + (int)(d - d4), n4 + (int)(d2 - d5));
        graphics.fillPolygon(polygon);
    }

    public static void paintArrowInheritance(Graphics graphics, Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = -(d2 /= d3) * 7.0;
        double d5 = (d /= d3) * 7.0;
        int n = (int)((d *= 14.0) + d4) + point2.x;
        int n2 = (int)((d2 *= 14.0) + d5) + point2.y;
        int n3 = (int)(d - d4) + point2.x;
        int n4 = (int)(d2 - d5) + point2.y;
        graphics.drawLine(point2.x, point2.y, n, n2);
        graphics.drawLine(point2.x, point2.y, n3, n4);
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(point2.x + (int)d, point2.y + (int)d2, point.x, point.y);
    }

    public static void paintArrowImplementation(Graphics graphics, Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = -(d2 /= d3) * 7.0;
        double d5 = (d /= d3) * 7.0;
        graphics.drawLine(point2.x, point2.y, (int)((d *= 14.0) + d4) + point2.x, (int)((d2 *= 14.0) + d5) + point2.y);
        graphics.drawLine(point2.x, point2.y, (int)(d - d4) + point2.x, (int)(d2 - d5) + point2.y);
        GfxTools.drawBrokenLine(graphics, new Point(point2.x + (int)(d / 7.0), point2.y + (int)(d2 / 7.0)), point, 5);
    }

    public static void quickSortDepth(Vector vector) {
        GfxTools.qSort(vector, 0, vector.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void qSort(Vector var0, int var1_1, int var2_2) {
        block5: {
            var3_3 = var1_1;
            var4_4 = var2_2;
            if (var2_2 <= var1_1) break block5;
            var5_5 = (DepthComparable)var0.elementAt((var1_1 + var2_2) / 2);
            ** GOTO lbl19
            {
                ++var3_3;
                do {
                    if (var3_3 < var2_2 && ((DepthComparable)var0.elementAt(var3_3)).compareDepthTo(var5_5) > 0) continue block0;
                    while (var4_4 > var1_1 && ((DepthComparable)var0.elementAt(var4_4)).compareDepthTo(var5_5) < 0) {
                        --var4_4;
                    }
                    if (var3_3 > var4_4) continue;
                    var6_6 = (DepthComparable)var0.elementAt(var3_3);
                    var0.setElementAt(var0.elementAt(var4_4), var3_3);
                    var0.setElementAt(var6_6, var4_4);
                    var6_6 = null;
                    ++var3_3;
                    --var4_4;
lbl19:
                    // 3 sources

                } while (var3_3 <= var4_4);
            }
            if (var1_1 < var4_4) {
                GfxTools.qSort(var0, var1_1, var4_4);
            }
            if (var3_3 < var2_2) {
                GfxTools.qSort(var0, var3_3, var2_2);
            }
        }
    }

    public static final boolean clipLine(Point point, Point point2, Rectangle rectangle) {
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = GfxTools.computeOutCode(point, n3, n4, n, n2);
        int n6 = GfxTools.computeOutCode(point2, n3, n4, n, n2);
        int n7 = 0;
        int n8 = 0;
        while (n5 != 0 || n6 != 0) {
            int n9;
            if ((n5 & n6) != 0) {
                return false;
            }
            int n10 = n9 = n5 != 0 ? n5 : n6;
            if ((n9 & 8) > 0) {
                n7 = point.x + (point2.x - point.x) * (n - point.y) / (point2.y - point.y);
                n8 = n;
            } else if ((n9 & 4) > 0) {
                n7 = point.x + (point2.x - point.x) * (n2 - point.y) / (point2.y - point.y);
                n8 = n2;
            } else if ((n9 & 1) > 0) {
                n8 = point.y + (point2.y - point.y) * (n4 - point.x) / (point2.x - point.x);
                n7 = n4;
            } else if ((n9 & 2) > 0) {
                n8 = point.y + (point2.y - point.y) * (n3 - point.x) / (point2.x - point.x);
                n7 = n3;
            }
            if (n9 == n5) {
                point.x = n7;
                point.y = n8;
                n5 = GfxTools.computeOutCode(point, n3, n4, n, n2);
                continue;
            }
            point2.x = n7;
            point2.y = n8;
            n6 = GfxTools.computeOutCode(point2, n3, n4, n, n2);
        }
        return true;
    }

    protected static final int computeOutCode(Point point, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (point.y < n3) {
            n5 = 8;
        } else if (point.y > n4) {
            n5 = 4;
        }
        if (point.x < n) {
            n5 += 2;
        } else if (point.x > n2) {
            ++n5;
        }
        return n5;
    }

    public static final void drawArc(Graphics graphics, int n, int n2, int n3, double d, double d2) {
        GfxTools.drawArc(graphics, n, n2, n3, n3, d, d2);
    }

    public static final void drawArc(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        double d3;
        double d4;
        if ((double)n3 == 0.0 || (double)n4 == 0.0) {
            GfxTools.set(graphics, n, n2, n, n, n2, n2);
            return;
        }
        if (d2 < 0.0) {
            d += d2;
            d2 = -d2;
        }
        if ((d %= 360.0) + d2 >= 270.0 && d <= 360.0 || d + d2 >= 630.0 && d <= 720.0) {
            d4 = d - 270.0;
            d3 = (d + d2) % 360.0;
            d3 = d3 < 270.0 ? 90.0 : (d3 %= 270.0);
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d4 > 90.0) {
                d4 = 90.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                GfxTools.drawArcSE(graphics, n, n2, n3, n4, 0.0, d3);
                GfxTools.drawArcSE(graphics, n, n2, n3, n4, d4, 90.0);
            } else {
                GfxTools.drawArcSE(graphics, n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 180.0 && d <= 270.0 || d + d2 >= 540.0 && d <= 630.0) {
            d4 = d - 180.0;
            d3 = (d + d2) % 360.0;
            d3 = d3 < 180.0 ? 90.0 : (d3 %= 180.0);
            if (d4 < 0.0 || d4 > 90.0) {
                d4 = 0.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                GfxTools.drawArcSW(graphics, n, n2, n3, n4, 0.0, d3);
                GfxTools.drawArcSW(graphics, n, n2, n3, n4, d4, 90.0);
            } else {
                GfxTools.drawArcSW(graphics, n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 90.0 && d <= 180.0 || d + d2 >= 450.0 && d <= 540.0) {
            d4 = d - 90.0;
            if (d < 90.0) {
                d4 = 0.0;
            } else if (d > 180.0) {
                d4 = 0.0;
            }
            d3 = (d + d2) % 360.0;
            d3 = d3 > 180.0 ? 90.0 : (d3 < 90.0 ? 90.0 : (d3 %= 90.0));
            if (d3 < d4) {
                GfxTools.drawArcNW(graphics, n, n2, n3, n4, 0.0, d3);
                GfxTools.drawArcNW(graphics, n, n2, n3, n4, d4, 90.0);
            } else {
                GfxTools.drawArcNW(graphics, n, n2, n3, n4, d4, d3);
            }
        }
        if (d + d2 >= 0.0 && d <= 90.0 || d + d2 >= 360.0 && d <= 450.0) {
            d4 = d;
            d3 = (d + d2) % 360.0;
            if (d4 > 90.0) {
                d4 = 0.0;
            }
            if (d3 > 90.0) {
                d3 = 90.0;
            }
            if (d3 < d4) {
                GfxTools.drawArcNE(graphics, n, n2, n3, n4, 0.0, d3);
                GfxTools.drawArcNE(graphics, n, n2, n3, n4, d4, 90.0);
            } else {
                GfxTools.drawArcNE(graphics, n, n2, n3, n4, d4, d3);
            }
        }
    }

    protected static final void drawArcSE(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n;
        int n6 = n + n3;
        int n7 = n2;
        int n8 = n2 + n4;
        if (d > 0.0) {
            n5 = n + (int)((double)n3 * Math.sin(d / 180.0 * Math.PI));
            n8 = n2 + (int)((double)n4 * Math.cos(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n6 = n + (int)((double)n3 * Math.sin(d2 / 180.0 * Math.PI));
            n7 = n2 + (int)((double)n4 * Math.cos(d2 / 180.0 * Math.PI));
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x > n5) {
            n5 = rectangle.x;
        }
        if (rectangle.x + rectangle.width < n6) {
            n6 = rectangle.x + rectangle.width;
        }
        if (rectangle.y > n7) {
            n7 = rectangle.y;
        }
        if (rectangle.y + rectangle.height < n8) {
            n8 = rectangle.y + rectangle.height;
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        GfxTools.set(graphics, n + n9, n2 + n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    GfxTools.set(graphics, n + n9, n2 + n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
            GfxTools.set(graphics, n + n9, n2, n5, n6, n7, n8);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        GfxTools.set(graphics, n + n16, n2 + n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    GfxTools.set(graphics, n + n16, n2 + n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            GfxTools.set(graphics, n, n2 + n15, n5, n6, n7, n8);
        }
    }

    protected static final void drawArcSW(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n - n3;
        int n6 = n;
        int n7 = n2;
        int n8 = n2 + n4;
        if (d > 0.0) {
            n5 = n - (int)((double)n3 * Math.cos(d / 180.0 * Math.PI));
            n7 = n2 + (int)((double)n4 * Math.sin(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n6 = n - (int)((double)n3 * Math.cos(d2 / 180.0 * Math.PI));
            n8 = n2 + (int)((double)n4 * Math.sin(d2 / 180.0 * Math.PI));
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x > n5) {
            n5 = rectangle.x;
        }
        if (rectangle.x + rectangle.width < n6) {
            n6 = rectangle.x + rectangle.width;
        }
        if (rectangle.y > n7) {
            n7 = rectangle.y;
        }
        if (rectangle.y + rectangle.height < n8) {
            n8 = rectangle.y + rectangle.height;
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        GfxTools.set(graphics, n - n9, n2 + n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    GfxTools.set(graphics, n - n9, n2 + n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
            GfxTools.set(graphics, n - n9, n2, n5, n6, n7, n8);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        GfxTools.set(graphics, n - n16, n2 + n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    GfxTools.set(graphics, n - n16, n2 + n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            GfxTools.set(graphics, n, n2 + n15, n5, n6, n7, n8);
        }
    }

    protected static final void drawArcNW(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n - n3;
        int n6 = n;
        int n7 = n2 - n4;
        int n8 = n2;
        if (d > 0.0) {
            n6 = n - (int)((double)n3 * Math.sin(d / 180.0 * Math.PI));
            n7 = n2 - (int)((double)n4 * Math.cos(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n5 = n - (int)((double)n3 * Math.sin(d2 / 180.0 * Math.PI));
            n8 = n2 - (int)((double)n4 * Math.cos(d2 / 180.0 * Math.PI));
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x > n5) {
            n5 = rectangle.x;
        }
        if (rectangle.x + rectangle.width < n6) {
            n6 = rectangle.x + rectangle.width;
        }
        if (rectangle.y > n7) {
            n7 = rectangle.y;
        }
        if (rectangle.y + rectangle.height < n8) {
            n8 = rectangle.y + rectangle.height;
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        GfxTools.set(graphics, n - n9, n2 - n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    GfxTools.set(graphics, n - n9, n2 - n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        GfxTools.set(graphics, n - n16, n2 - n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    GfxTools.set(graphics, n - n16, n2 - n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            GfxTools.set(graphics, n, n2 - n15, n5, n6, n7, n8);
        }
    }

    protected static final void drawArcNE(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2) {
        int n5 = n;
        int n6 = n + n3;
        int n7 = n2 - n4;
        int n8 = n2;
        if (d > 0.0) {
            n6 = n + (int)((double)n3 * Math.cos(d / 180.0 * Math.PI));
            n8 = n2 - (int)((double)n4 * Math.sin(d / 180.0 * Math.PI));
        }
        if (d2 < 90.0) {
            n5 = n + (int)((double)n3 * Math.cos(d2 / 180.0 * Math.PI));
            n7 = n2 - (int)((double)n4 * Math.sin(d2 / 180.0 * Math.PI));
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.x > n5) {
            n5 = rectangle.x;
        }
        if (rectangle.x + rectangle.width < n6) {
            n6 = rectangle.x + rectangle.width;
        }
        if (rectangle.y > n7) {
            n7 = rectangle.y;
        }
        if (rectangle.y + rectangle.height < n8) {
            n8 = rectangle.y + rectangle.height;
        }
        if (n6 < n5 || n8 < n7) {
            return;
        }
        if (n4 <= n3) {
            int n9 = 0;
            int n10 = n4;
            int n11 = 0;
            int n12 = n3 * n3;
            int n13 = -n12 / 2;
            int n14 = n12 / n4;
            do {
                if (n13 <= 0) {
                    do {
                        GfxTools.set(graphics, n + n9, n2 - n10, n5, n6, n7, n8);
                        ++n9;
                    } while ((n13 += (n11 += n4)) <= 0);
                } else {
                    GfxTools.set(graphics, n + n9, n2 - n10, n5, n6, n7, n8);
                }
                n13 -= (n12 -= n14);
            } while (--n10 != 0);
        } else {
            int n15 = 0;
            int n16 = n3;
            int n17 = 0;
            int n18 = n4 * n4;
            int n19 = -n18 / 2;
            int n20 = n18 / n3;
            do {
                if (n19 <= 0) {
                    do {
                        GfxTools.set(graphics, n + n16, n2 - n15, n5, n6, n7, n8);
                        ++n15;
                    } while ((n19 += (n17 += n3)) <= 0);
                } else {
                    GfxTools.set(graphics, n + n16, n2 - n15, n5, n6, n7, n8);
                }
                n19 -= (n18 -= n20);
            } while (--n16 != 0);
            GfxTools.set(graphics, n, n2 - n15, n5, n6, n7, n8);
        }
    }

    protected static final void set(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n3 && n2 < n5 || n2 > n6 && n > n4 || n < n3 - 1 || n > n4 + 1 || n2 < n5 - 1 || n2 > n6 + 1) {
            return;
        }
        graphics.drawLine(n, n2, n, n2);
    }
}

