/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.FIGCharacter;
import de.jave.figlet.FIGDriver;
import de.jave.figlet.FIGFileManager;
import de.jave.figlet.FIGLayout;
import de.jave.figlet.Tools;
import de.jave.io.IOTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FIGFont {
    public static final String SIGNATURE = "flf2a";
    public static final String FILEENDING = ".flf";
    public static final char HARDBLANK = '\u007f';
    public String name;
    public FIGCharacter[] chr;
    private String comments;
    private char hardblank;
    private int height;
    public int baseline;
    private int max_length;
    public int old_layout;
    private int comment_lines;
    private int printDirection;
    public int full_layout;
    private int codetagCount;
    private char endOfLine;
    private int maxindex = 0;
    private short[] mapArray;
    private Hashtable mapTable;
    public FIGLayout layout;

    FIGFont(String string) {
        this.name = string;
    }

    public boolean load() {
        try {
            URL uRL = FIGFileManager.getURLForFont(this.name);
            BufferedReader bufferedReader = IOTools.openPossiblyZipped(uRL);
            return this.load(bufferedReader);
        }
        catch (IOException iOException) {
            FIGDriver.warning("Error loading FIGLetfont: " + iOException);
            return false;
        }
    }

    public static FIGFont load(String string, File file) {
        try {
            FIGFont fIGFont = new FIGFont(string);
            URL uRL = FIGFileManager.getURLForFont(file);
            BufferedReader bufferedReader = IOTools.openPossiblyZipped(uRL);
            if (fIGFont.load(bufferedReader)) {
                return fIGFont;
            }
        }
        catch (IOException iOException) {
            FIGDriver.warning("Error loading FIGLetfont: " + iOException);
            return null;
        }
        return null;
    }

    protected boolean load(BufferedReader bufferedReader) throws IOException {
        int n;
        String string = bufferedReader.readLine();
        if (!this.extractOptions(string)) {
            return false;
        }
        if (this.comment_lines == 0) {
            this.comments = "- no comments -";
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            n = 0;
            while (n < this.comment_lines) {
                stringBuffer.append(bufferedReader.readLine());
                if (n < this.comment_lines - 1) {
                    stringBuffer.append('\n');
                }
                ++n;
            }
            this.comments = stringBuffer.toString();
        }
        this.endOfLine = (char)124;
        this.mapArray = new short[256];
        int n2 = 0;
        while (n2 <= 31) {
            this.mapArray[n2] = -1;
            ++n2;
        }
        n = 32;
        while (n <= 126) {
            this.mapArray[n] = (short)(n - 32);
            ++n;
        }
        int n3 = 127;
        while (n3 <= 255) {
            this.mapArray[n3] = -1;
            ++n3;
        }
        this.mapArray[196] = 95;
        this.mapArray[214] = 96;
        this.mapArray[220] = 97;
        this.mapArray[228] = 98;
        this.mapArray[246] = 99;
        this.mapArray[252] = 100;
        this.mapArray[223] = 101;
        this.mapTable = new Hashtable();
        this.chr = new FIGCharacter[this.codetagCount + 102];
        int n4 = 0;
        while (n4 < this.codetagCount + 102) {
            if (!this.loadCharacter(bufferedReader, n4)) {
                FIGCharacter[] fIGCharacterArray = new FIGCharacter[n4];
                System.arraycopy(this.chr, 0, fIGCharacterArray, 0, n4 - 1);
                this.chr = fIGCharacterArray;
                break;
            }
            ++n4;
        }
        bufferedReader.close();
        return true;
    }

    private boolean loadCharacter(BufferedReader bufferedReader, int n) throws IOException {
        int n2;
        int n3;
        Object object;
        if (n > 101) {
            object = bufferedReader.readLine();
            if (object == null || ((String)object).equals("")) {
                return false;
            }
            n3 = 0;
            if (((String)object).charAt(0) == '-') {
                n3 = 1;
                object = ((String)object).substring(1);
            }
            int n4 = 0;
            if (((String)object).charAt(0) == '0') {
                if (((String)object).length() < 2) {
                    n4 = 0;
                } else if (((String)object).charAt(1) == 'x' || ((String)object).charAt(1) == 'X') {
                    n2 = ((String)object).indexOf(" ");
                    if (n2 == -1) {
                        n2 = ((String)object).length();
                    }
                    n4 = Integer.parseInt(((String)object).substring(2, n2), 16);
                } else {
                    n2 = ((String)object).indexOf(" ");
                    if (n2 == -1) {
                        n2 = ((String)object).length();
                    }
                    n4 = Integer.parseInt(((String)object).substring(1, n2), 8);
                }
            } else {
                n2 = ((String)object).indexOf(" ");
                if (n2 == -1) {
                    n2 = ((String)object).length();
                }
                n4 = Integer.parseInt(((String)object).substring(0, n2));
            }
            if (n3 != 0) {
                n4 = -n4;
            }
            if (n4 >= 0 && n4 <= 255) {
                this.mapArray[n4] = (short)n;
            } else {
                this.mapTable.put(new Integer(n4), new Integer(n));
            }
        }
        object = new String[this.height];
        n3 = 0;
        while (n3 < this.height) {
            String string = bufferedReader.readLine();
            if (string == null || string.length() < 1) {
                System.out.println("Warning! Unexpected end of FIGlet font file or wrong file format!");
                return false;
            }
            n2 = string.charAt(string.length() - 1);
            int n5 = 1;
            if (string.length() > 1 && string.charAt(string.length() - 2) == n2) {
                ++n5;
            }
            object[n3] = string.substring(0, string.length() - n5).replace(this.hardblank, '\u007f');
            ++n3;
        }
        this.chr[n] = new FIGCharacter((String[])object);
        return true;
    }

    private boolean extractOptions(String string) {
        if (string.length() < 15) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (!string2.startsWith(SIGNATURE)) {
            System.err.println("WARNING: File does not seem to be correct");
            System.err.println(" wrong header format:" + string);
            System.err.println(" FIGFonts must start with: 'flf2a'");
        }
        this.hardblank = string2.charAt(5);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.height = Tools.toInt(string2);
        if (this.height < 1) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.baseline = Tools.toInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.max_length = Tools.toInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.old_layout = Tools.toInt(string2);
        this.layout = new FIGLayout(this.old_layout, -1);
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        string2 = stringTokenizer.nextToken();
        this.comment_lines = Tools.toInt(string2);
        this.printDirection = 0;
        this.codetagCount = 102;
        this.full_layout = -1;
        if (!stringTokenizer.hasMoreTokens()) {
            return true;
        }
        string2 = stringTokenizer.nextToken();
        this.printDirection = Tools.toInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            return true;
        }
        string2 = stringTokenizer.nextToken();
        this.full_layout = Tools.toInt(string2);
        this.layout = new FIGLayout(this.old_layout, this.full_layout);
        if (!stringTokenizer.hasMoreTokens()) {
            return true;
        }
        string2 = stringTokenizer.nextToken();
        this.codetagCount = Tools.toInt(string2);
        return true;
    }

    public void printComments() {
        System.out.print(this.comments);
    }

    public String getComments() {
        return this.comments;
    }

    public void invertPrintDirection() {
        this.printDirection = 1 - this.printDirection;
    }

    public int getMode() {
        return this.old_layout;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPrintDirection() {
        return this.printDirection;
    }

    public boolean isPrintDirectionInverted() {
        return this.printDirection == 1;
    }

    public int getMaxlength() {
        return this.max_length;
    }

    public int getUnderLength() {
        return this.height - this.baseline;
    }

    public char getHardblank() {
        return this.hardblank;
    }

    public FIGCharacter getFIGCharacter(int n) {
        int n2 = this.mapChar(n);
        if (n2 == -1) {
            System.err.println("Warning: Character '" + n + "' not available in this font " + this.name);
            return this.chr[0];
        }
        return this.chr[n2];
    }

    public int mapChar(int n) {
        int n2 = -1;
        if (n >= 0 && n <= 255) {
            n2 = this.mapArray[n];
        } else {
            Integer n3 = (Integer)this.mapTable.get(new Integer(n));
            if (n3 != null) {
                n2 = n3;
            }
        }
        if (n2 != -1 && this.chr[n2] == null) {
            return -1;
        }
        return n2;
    }

    public String getInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nHeight:   " + this.height);
        stringBuffer.append("\nBaseline: " + this.baseline);
        stringBuffer.append("\nMaximum length:  " + this.max_length);
        stringBuffer.append("\nPrint direction: " + this.printDirection);
        stringBuffer.append("\nCodetag count:   " + this.codetagCount);
        return stringBuffer.toString();
    }

    public String[] getInfos() {
        String[] stringArray = new String[]{"Height:", String.valueOf(this.height), "Baseline:", String.valueOf(this.baseline), "Maximum length:", String.valueOf(this.max_length), "Print direction:", String.valueOf(this.printDirection), "Codetag count:", String.valueOf(this.codetagCount)};
        return stringArray;
    }

    public void print() {
        System.out.println("FIGLet Font >" + this.name + "<");
        System.out.println(" height     = " + this.height);
        System.out.println(" baseline   = " + this.baseline);
        System.out.println(" max_length = " + this.max_length);
        System.out.println(" old_layout = " + this.old_layout);
        System.out.println(" comment_lines  = " + this.comment_lines);
        System.out.println(" printDirection = " + this.printDirection);
        System.out.println(" full_layout    = " + this.full_layout);
        System.out.println(" codetagCount   = " + this.codetagCount);
        System.out.println(" hardblank  = " + this.hardblank);
        int n = 0;
        while (n < this.chr.length) {
            if (this.chr[n] != null) {
                this.chr[n].print();
            }
            ++n;
        }
    }
}

