/*
 * Decompiled with CFR 0.152.
 */
package de.jave.text;

import de.jave.text.FastStringIndexOutOfBoundsException;

public class FastString {
    char[] chars;
    int offset;
    int length;

    public FastString() {
        this.chars = new char[200];
        this.length = 0;
        this.offset = 0;
    }

    public FastString(int n) {
        this.chars = new char[n];
        this.length = 0;
        this.offset = 0;
    }

    public FastString(char c) {
        this.chars = new char[20];
        this.chars[0] = c;
        this.offset = 0;
        this.length = 1;
    }

    public FastString(String string) {
        this.length = string.length();
        this.chars = new char[this.length * 2];
        this.offset = 0;
        string.getChars(0, string.length(), this.chars, this.offset);
    }

    public FastString(String string, int n) {
        if (string.length() > n) {
            n = string.length();
        }
        this.length = string.length();
        this.chars = new char[n];
        this.offset = 0;
        string.getChars(0, string.length(), this.chars, this.offset);
    }

    public FastString(char[] cArray) {
        this.offset = 0;
        this.length = cArray.length;
        this.chars = new char[this.length];
        System.arraycopy(cArray, 0, this.chars, 0, this.length);
    }

    public FastString(FastString fastString) {
        this.offset = 0;
        this.length = fastString.length;
        this.chars = new char[this.length * 2];
        System.arraycopy(fastString.chars, fastString.offset, this.chars, 0, this.length);
    }

    public FastString add(FastString fastString) {
        FastString fastString2 = new FastString((this.length + fastString.length) * 2);
        fastString2.offset = 0;
        fastString2.length = this.length + fastString.length;
        System.arraycopy(this.chars, this.offset, fastString2.chars, 0, this.length);
        System.arraycopy(fastString.chars, fastString.offset, fastString2.chars, this.length, fastString.length);
        return fastString2;
    }

    public FastString add(char c, FastString fastString) {
        FastString fastString2 = new FastString((this.length + fastString.length + 1) * 2);
        fastString2.offset = 0;
        fastString2.length = this.length + fastString.length + 1;
        System.arraycopy(this.chars, this.offset, fastString2.chars, 0, this.length);
        fastString2.chars[this.length] = c;
        System.arraycopy(fastString.chars, fastString.offset, fastString2.chars, this.length + 1, fastString.length);
        return fastString2;
    }

    public char charAt(int n) {
        if (n < 0 || n > this.length - 1) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        return this.chars[n + this.offset];
    }

    public void setChar(int n, char c) {
        if (n < 0 || n > this.length - 1) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        this.chars[this.offset + n] = c;
    }

    public boolean equals(FastString fastString) {
        if (fastString.length != this.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            if (this.chars[this.offset + n] != fastString.chars[fastString.offset + n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void replace(char c, char c2) {
        int n = 0;
        while (n < this.length) {
            if (this.chars[this.offset + n] == c) {
                this.chars[this.offset + n] = c2;
            }
            ++n;
        }
    }

    public void trimRight() {
        while (this.length > 0 && this.chars[this.offset + this.length - 1] <= ' ') {
            --this.length;
        }
    }

    public void trimLeft() {
        while (this.length > 0 && this.chars[this.offset] <= ' ') {
            ++this.offset;
            --this.length;
        }
    }

    public void trim() {
        this.trimLeft();
        this.trimRight();
    }

    public boolean startsWith(FastString fastString) {
        if (fastString.length > this.length) {
            return false;
        }
        int n = 0;
        while (n < fastString.length) {
            if (this.chars[this.offset + n] != fastString.chars[fastString.offset + n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string.length() > this.length) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (this.chars[this.offset + n] != string.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean endsWith(FastString fastString) {
        if (fastString.length > this.length) {
            return false;
        }
        int n = 0;
        while (n < fastString.length) {
            if (this.chars[this.offset + this.length - n] != fastString.chars[fastString.offset + fastString.length - n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean endsWith(String string) {
        int n = string.length();
        if (n > this.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.chars[this.offset + this.length - n2] != string.charAt(n - n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int length() {
        return this.length;
    }

    public void append(FastString fastString) {
        if (this.chars.length < this.offset + this.length + fastString.length) {
            char[] cArray = new char[this.chars.length + fastString.chars.length];
            System.arraycopy(this.chars, this.offset, cArray, this.offset, this.length);
            this.chars = cArray;
        }
        System.arraycopy(fastString.chars, fastString.offset, this.chars, this.offset + this.length, fastString.length);
        this.length += fastString.length;
    }

    public void append(String string) {
        if (this.chars.length < this.offset + this.length + string.length()) {
            char[] cArray = new char[this.chars.length + string.length()];
            System.arraycopy(this.chars, this.offset, cArray, this.offset, this.length);
            this.chars = cArray;
        }
        string.getChars(0, string.length(), this.chars, this.offset + this.length);
        this.length += string.length();
    }

    public void append(char c) {
        if (this.chars.length < this.offset + this.length + 1) {
            char[] cArray = new char[this.chars.length + 10];
            System.arraycopy(this.chars, this.offset, cArray, this.offset, this.length);
            this.chars = cArray;
        }
        this.chars[this.offset + this.length] = c;
        ++this.length;
    }

    public void appendFront(FastString fastString) {
        if (this.offset < fastString.length) {
            char[] cArray = new char[this.chars.length + fastString.chars.length];
            System.arraycopy(this.chars, this.offset, cArray, this.offset + fastString.length + fastString.offset, this.length);
            this.chars = cArray;
            this.offset = this.offset + fastString.length + fastString.offset;
        }
        System.arraycopy(fastString.chars, fastString.offset, this.chars, this.offset - fastString.length, fastString.length);
        this.length += fastString.length;
        this.offset -= fastString.length;
    }

    public void crop(int n) {
        if (n > this.length || n < 0) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        this.offset += n;
        this.length -= n;
    }

    public void crop(int n, int n2) {
        if (n > this.length || n < 0) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length || n2 < n) {
            throw new FastStringIndexOutOfBoundsException(n2);
        }
        this.offset += n;
        this.length = n2 - n;
    }

    public FastString substring(int n, int n2) {
        if (n > this.length || n < 0) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        if (n2 > this.length || n2 < n) {
            throw new FastStringIndexOutOfBoundsException(n2);
        }
        FastString fastString = new FastString(this);
        fastString.crop(n, n2);
        return fastString;
    }

    public FastString substring(int n) {
        if (n > this.length || n < 0) {
            throw new FastStringIndexOutOfBoundsException(n);
        }
        FastString fastString = new FastString(this);
        fastString.crop(n);
        return fastString;
    }

    public String toString() {
        return new String(this.chars, this.offset, this.length);
    }

    public void print() {
        System.out.print(this.toString());
    }

    public void println() {
        System.out.println(this.toString());
    }

    public static void main(String[] stringArray) {
        FastString fastString = new FastString('\u00c4');
        FastString fastString2 = new FastString(fastString);
        FastString fastString3 = fastString2.add('#', new FastString("sindso"));
        fastString3.appendFront(new FastString("upsi"));
        String string = fastString3.toString();
        fastString3.println();
        System.out.println(string.length() + "Zeichen:");
        int n = 0;
        while (n < string.length()) {
            System.out.println(" " + string.charAt(n) + " " + string.charAt(n));
            ++n;
        }
    }
}

