/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.CharacterPlate;
import de.jave.jave.Jave;
import de.jave.jave.JaveGame;
import de.jave.jave.RectangleAlgorithm;
import de.jave.util.Toolbox;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class Labyrinth
extends JaveGame {
    protected int width = 5;
    protected int height = 5;
    protected char[][] field;
    protected static final char WALL = ' ';
    protected static final char WAY = '.';
    protected static final char START = 'O';
    protected static final char EXIT = '*';
    protected static final int SOLUTION_POS_X = 31;
    protected static final int SOLUTION_POS_Y = 3;
    protected static final int PLATE_WIDTH = 45;
    protected static final int PLATE_HEIGHT = 21;
    protected int direction;
    protected Point position;
    protected static final int[] DX = new int[]{1, 0, -1, 0};
    protected static final int[] DY = new int[]{0, 1, 0, -1};
    protected static final int RIGHT = 0;
    protected static final int DOWN = 1;
    protected static final int LEFT = 2;
    protected static final int UP = 3;
    protected static final String[] DIRECTION_STR = new String[]{"RIGHT", "DOWN", "LEFT", "UP"};
    protected static final char[] DIRECTION_CHAR = new char[]{'>', 'V', '<', '^'};
    protected static final String BACKGROUND = "\\                         /\n  \\                     /  \n    \\                 /    \n      \\             /      \n        \\         /        \n          \\     /          \n            \\ /            \n            / \\            \n          /     \\          \n        /         \\        \n      /             \\      \n    /                 \\    \n  /                     \\  \n/                         \\\n";
    protected static final String EXIT_1 = "=========================\n. \\ EXIT ______ EXIT /  .\n.  `.   '------'   .`   .\n.    \\   .---..   /     .\n.  '' `-(_.-. `\\-` ''   .\n.  ''    .--' |'   ''   .\n.  ''   : ,-. |'   ''   .\n.  ''  J: `-' |'ve ''   .\n.  '' .-`.__:_,`-. ''   .\n.    /   ______   \\     .\n.  .'   '------'   `.   .\n=========================";
    protected static final String EXIT_2 = "===============\n...............\n..exit...exit..\n......\\-/......\n.....J|a|VE....\n..... /-\\......\n...............\n===============";
    protected static final String EXIT_3 = "============\n.exit..exit.\n....\\-/.....\n...J|a|VE...\n... /-\\.....\n============";
    protected static final String EXIT_4 = "========\n.e....e.\n...]a[..\n========";

    public Labyrinth(Jave jave) {
        super(jave);
        this.startGame();
    }

    public Dimension getPreferredSize() {
        return new Dimension(45, 21);
    }

    public String getTitle() {
        return "Labyrinth 1.0";
    }

    public int getPreferredColorScheme() {
        return 2;
    }

    protected void startGame() {
        this.create();
        this.position = new Point(0, 1);
        this.direction = 0;
        this.plate.clear();
        this.plate.paste("Use cursor keys to navigate", 7, 17);
        RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(0, 0, 29, 16), RectangleAlgorithm.getCharsForStyle(0));
        this.drawCurrentView();
        this.requestFocus();
    }

    protected void create() {
        boolean bl;
        this.field = new char[this.height * 2 + 1][this.width * 2 + 1];
        int n = 0;
        while (n < this.height * 2 + 1) {
            int n2 = 0;
            while (n2 < this.width * 2 + 1) {
                this.field[n][n2] = 32;
                ++n2;
            }
            ++n;
        }
        this.field[1][1] = 46;
        do {
            bl = true;
            int n3 = 0;
            while (n3 < this.height) {
                int n4 = 0;
                while (n4 < this.width) {
                    if (this.field[n3 * 2 + 1][n4 * 2 + 1] == '.') {
                        this.dig(n4, n3);
                    } else {
                        bl = false;
                    }
                    ++n4;
                }
                ++n3;
            }
        } while (!bl);
        this.field[1][0] = 79;
        this.field[this.height * 2 - 1][this.width * 2 - 1] = 42;
    }

    protected void dig(int n, int n2) {
        int n3 = Toolbox.random(0, 3);
        int n4 = n * 2 + 1;
        int n5 = n2 * 2 + 1;
        int n6 = 0;
        while (n6 < 4) {
            switch ((n6 + n3) % 4) {
                case 0: {
                    if (n2 <= 0 || this.field[n5 - 2][n4] != ' ') break;
                    this.field[n5 - 1][n4] = 46;
                    this.field[n5 - 2][n4] = 46;
                    this.dig(n, n2 - 1);
                    return;
                }
                case 1: {
                    if (n <= 0 || this.field[n5][n4 - 2] != ' ') break;
                    this.field[n5][n4 - 1] = 46;
                    this.field[n5][n4 - 2] = 46;
                    this.dig(n - 1, n2);
                    return;
                }
                case 2: {
                    if (n2 >= this.height - 1 || this.field[n5 + 2][n4] != ' ') break;
                    this.field[n5 + 1][n4] = 46;
                    this.field[n5 + 2][n4] = 46;
                    this.dig(n, n2 + 1);
                    return;
                }
                case 3: {
                    if (n >= this.width - 1 || this.field[n5][n4 + 2] != ' ') break;
                    this.field[n5][n4 + 1] = 46;
                    this.field[n5][n4 + 2] = 46;
                    this.dig(n + 1, n2);
                    return;
                }
            }
            ++n6;
        }
    }

    public void print() {
        int n = 0;
        while (n < this.height * 2 + 1) {
            System.err.println(this.field[n]);
            ++n;
        }
    }

    protected void turnLeft() {
        this.direction = (this.direction + 3) % 4;
        this.drawCurrentView();
    }

    protected void turnRight() {
        this.direction = (this.direction + 1) % 4;
        this.drawCurrentView();
    }

    protected void moveForward() {
        int n = this.position.x + DX[this.direction];
        int n2 = this.position.y + DY[this.direction];
        if (n > this.width * 2 || n < 0 || n2 > this.height * 2 || n2 < 0 || this.field[n2][n] != '.' && this.field[n2][n] != '*') {
            return;
        }
        this.plate.setForce(31 + this.position.x, 3 + this.position.y, this.field[this.position.y][this.position.x]);
        this.position.x = n;
        this.position.y = n2;
        this.drawCurrentView();
        if (this.field[n2][n] == '*') {
            RectangleAlgorithm.drawRectangle(this.plate, new Rectangle(7, 16, 30, 5), RectangleAlgorithm.getCharsForStyle(0));
            this.plate.paste("    * Congratulations *     ", 8, 17);
            this.plate.paste("  You have found the exit   ", 8, 18);
            this.plate.paste("Press S to start a new game.", 8, 19);
            this.repaint();
        }
    }

    protected void drawCurrentView() {
        int n = this.position.x;
        int n2 = this.position.y;
        int n3 = this.position.x + DX[(this.direction + 3) % 4];
        int n4 = this.position.y + DY[(this.direction + 3) % 4];
        int n5 = this.position.x + DX[(this.direction + 1) % 4];
        int n6 = this.position.y + DY[(this.direction + 1) % 4];
        char[][] cArray = new char[5][3];
        int n7 = 0;
        while (n >= 0 && n2 >= 0 && n < this.width * 2 + 1 && n2 < this.height * 2 + 1 && this.field[n2][n] != ' ') {
            if (n7 < 5) {
                cArray[n7][0] = 32;
                cArray[n7][1] = this.field[n2][n];
                cArray[n7][2] = 32;
            }
            this.plate.setForce(31 + n, 3 + n2, this.field[n2][n]);
            if (n3 >= 0 && n4 >= 0 && n3 < this.width * 2 + 1 && n4 < this.height * 2 + 1) {
                if (n7 < 5) {
                    cArray[n7][0] = this.field[n4][n3];
                }
                this.plate.setForce(31 + n3, 3 + n4, this.field[n4][n3]);
            }
            if (n5 >= 0 && n6 >= 0 && n5 < this.width * 2 + 1 && n6 < this.height * 2 + 1) {
                if (n7 < 5) {
                    cArray[n7][2] = this.field[n6][n5];
                }
                this.plate.setForce(31 + n5, 3 + n6, this.field[n6][n5]);
            }
            n += DX[this.direction];
            n2 += DY[this.direction];
            n3 += DX[this.direction];
            n4 += DY[this.direction];
            n5 += DX[this.direction];
            n6 += DY[this.direction];
            ++n7;
        }
        this.plate.paste("Exit", 31 + this.width * 2 - 1, 3 + this.height * 2 - 1);
        this.plate.setForce(31 + this.position.x, 3 + this.position.y, DIRECTION_CHAR[this.direction]);
        this.plate.fill(1, 1, 27, 14, ' ');
        CharacterPlate characterPlate = new CharacterPlate(BACKGROUND);
        int n8 = 1;
        while (n8 < 5 && (cArray[n8][1] == '.' || cArray[n8][1] == '*')) {
            ++n8;
        }
        boolean bl = cArray[n8 - 1][1] == '*';
        switch (n8) {
            case 5: {
                break;
            }
            case 4: {
                if (bl) {
                    new CharacterPlate(EXIT_4).pasteInto(characterPlate, 10, 5);
                    break;
                }
                characterPlate.fill(10, 5, 7, 4, '=');
                characterPlate.fill(10, 6, 7, 2, '.');
                break;
            }
            case 3: {
                if (bl) {
                    new CharacterPlate(EXIT_3).pasteInto(characterPlate, 8, 4);
                    break;
                }
                characterPlate.fill(8, 4, 11, 6, '=');
                characterPlate.fill(8, 5, 11, 4, '.');
                break;
            }
            case 2: {
                if (bl) {
                    new CharacterPlate(EXIT_2).pasteInto(characterPlate, 6, 3);
                    break;
                }
                characterPlate.fill(6, 3, 15, 8, '=');
                characterPlate.fill(6, 4, 15, 6, '.');
                break;
            }
            case 1: {
                if (bl) {
                    new CharacterPlate(EXIT_1).pasteInto(characterPlate, 2, 1);
                    break;
                }
                characterPlate.fill(2, 1, 23, 12, '=');
                characterPlate.fill(2, 2, 23, 10, '.');
            }
        }
        int n9 = n8 - 1;
        while (n9 >= 0) {
            if (cArray[n9][2] == '.') {
                switch (n9) {
                    case 3: {
                        characterPlate.fill(18, 5, 1, 4, '|');
                        characterPlate.setForce(17, 5, '=');
                        characterPlate.setForce(17, 8, '=');
                        characterPlate.setForce(17, 6, '.');
                        characterPlate.setForce(17, 7, '.');
                        break;
                    }
                    case 2: {
                        characterPlate.fill(20, 4, 1, 6, '|');
                        if (n9 < n8 - 1) {
                            characterPlate.fill(18, 5, 1, 4, '|');
                        }
                        characterPlate.setForce(19, 4, '=');
                        characterPlate.setForce(19, 9, '=');
                        characterPlate.fill(19, 5, 1, 4, '.');
                        break;
                    }
                    case 1: {
                        characterPlate.fill(24, 2, 1, 10, '|');
                        if (n9 < n8 - 1) {
                            characterPlate.fill(20, 4, 1, 6, '|');
                        }
                        characterPlate.fill(21, 3, 3, 1, '=');
                        characterPlate.fill(21, 10, 3, 1, '=');
                        characterPlate.fill(21, 4, 3, 6, '.');
                        characterPlate.setForce(22, 2, ' ');
                        characterPlate.setForce(22, 11, ' ');
                        break;
                    }
                    case 0: {
                        if (n9 < n8 - 1) {
                            characterPlate.fill(24, 2, 1, 10, '|');
                        }
                        characterPlate.setForce(26, 0, ' ');
                        characterPlate.fill(25, 1, 2, 1, '=');
                        characterPlate.fill(25, 2, 2, 10, '.');
                        characterPlate.fill(25, 12, 2, 1, '=');
                        characterPlate.setForce(26, 13, ' ');
                    }
                }
            }
            if (cArray[n9][0] == '.') {
                switch (n9) {
                    case 3: {
                        characterPlate.fill(8, 5, 1, 4, '|');
                        characterPlate.setForce(9, 5, '=');
                        characterPlate.setForce(9, 8, '=');
                        characterPlate.setForce(9, 6, '.');
                        characterPlate.setForce(9, 7, '.');
                        break;
                    }
                    case 2: {
                        characterPlate.fill(6, 4, 1, 6, '|');
                        if (n9 < n8 - 1) {
                            characterPlate.fill(8, 5, 1, 4, '|');
                        }
                        characterPlate.setForce(7, 4, '=');
                        characterPlate.setForce(7, 9, '=');
                        characterPlate.fill(7, 5, 1, 4, '.');
                        break;
                    }
                    case 1: {
                        characterPlate.fill(2, 2, 1, 10, '|');
                        if (n9 < n8 - 1) {
                            characterPlate.fill(6, 4, 1, 6, '|');
                        }
                        characterPlate.fill(3, 3, 3, 1, '=');
                        characterPlate.fill(3, 10, 3, 1, '=');
                        characterPlate.fill(3, 4, 3, 6, '.');
                        characterPlate.setForce(4, 2, ' ');
                        characterPlate.setForce(4, 11, ' ');
                        break;
                    }
                    case 0: {
                        if (n9 < n8 - 1) {
                            characterPlate.fill(2, 2, 1, 10, '|');
                        }
                        characterPlate.setForce(0, 0, ' ');
                        characterPlate.fill(0, 1, 2, 1, '=');
                        characterPlate.fill(0, 2, 2, 10, '.');
                        characterPlate.fill(0, 12, 2, 1, '=');
                        characterPlate.setForce(0, 13, ' ');
                    }
                }
            }
            --n9;
        }
        characterPlate.pasteInto(this.plate, 1, 1);
        this.repaint();
    }

    protected void keyTyped(KeyEvent keyEvent, int n, char c) {
        if (c == 's') {
            this.startGame();
            return;
        }
        if (c == 'q') {
            this.quit();
            return;
        }
    }

    protected void keyPressed(KeyEvent keyEvent, int n, char c) {
        if (n == 37) {
            this.turnLeft();
            return;
        }
        if (n == 39) {
            this.turnRight();
            return;
        }
        if (n == 38) {
            this.moveForward();
            return;
        }
    }

    public static void main(String[] stringArray) {
        Labyrinth labyrinth = new Labyrinth(null);
    }
}

