/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.PixelPlate;
import de.jave.jave.Plate;
import de.jave.jave.Point2d;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class FreehandToolGeneric
extends GenericTool {
    protected Point point1;
    protected Point cursorPosition;

    public FreehandToolGeneric(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public String getName() {
        return "Freehand Generic";
    }

    public String getIconName() {
        return "freehand_generic";
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void mouseMoved(Point point, Point point2, MouseEvent mouseEvent) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        this.point1 = point;
        this.markPlate = new PixelPlate(point2.x - 10, point2.y - 10, 20, 20);
        GenericTool.pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        Point2d point2d = this.plate.getRealLocationForScreenPoint(this.point1);
        this.markPlate.drawLine(point2d, point2d);
        this.repaintCursor();
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.getMixMode());
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.plate.getContent());
        this.point1 = null;
        this.cursorPosition = null;
        this.markPlate = null;
        this.saveCurrentState("freehand");
        this.repaintAll();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (n == 27 && this.point1 != null) {
            this.point1 = null;
            this.markPlate = null;
            this.repaintCursor();
        }
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.markPlate == null || point2 == null) {
            return;
        }
        Point2d point2d = this.plate.getRealLocationForScreenPoint(point);
        Point2d point2d2 = this.plate.getRealLocationForScreenPoint(this.point1);
        if (point2d.x != point2d2.x || point2d.y != point2d2.y) {
            this.markPlate.drawLine(point2d.x, point2d.y, point2d2.x, point2d2.y);
        }
        this.point1 = point;
        this.cursorPosition = point;
        this.repaintCursor();
        this.showCoordinates(point2);
    }

    public void mouseExited(Point point, Point point2, MouseEvent mouseEvent) {
        this.cursorPosition = null;
        this.repaintCursor();
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.cursorPosition != null && this.isFeltpenMode()) {
            int n = (int)(this.getFeltpenPreviewDiameter() * (double)this.plate.charWidth / 2.0);
            graphics.setColor(JaveGlobalRessources.colorTool);
            graphics.drawOval(this.cursorPosition.x - n, this.cursorPosition.y - n, 2 * n, 2 * n);
        }
        if (this.markPlate == null) {
            return;
        }
        this.markPlate.convert();
        this.markPlate.paint(graphics, this.plate, this.debug);
    }
}

