/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gfx.GfxTools;
import de.jave.gui.GChoiceTextField;
import de.jave.gui.GDialog;
import de.jave.gui.GGridLayout;
import de.jave.gui.GGridLayout2;
import de.jave.gui.GTextArea;
import de.jave.gui.GuiTools;
import de.jave.jave.AsciiGradients;
import de.jave.jave.FillAlgorithm;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Pattern;
import de.jave.jave.PatternDialog;
import de.jave.jave.Plate;
import de.jave.jave.Tool;
import de.jave.text.TextTools;
import gebhard.uielements.CardPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class FillTool
extends Tool {
    protected static final int SOLID = 0;
    protected static final int PATTERN = 1;
    protected static final int GRADIENT = 2;
    protected static final String[] STR_MODE = new String[]{"Solid", "Pattern", "Gradient"};
    protected Checkbox cbMix;
    protected static final boolean DEFAULT_MIX = false;
    protected PatternDialog patternDialog;
    protected Choice chMatchMode;
    protected CardPanel cpOptions;
    protected Choice chGradient;
    protected TextArea taPattern;
    protected Button bPattern;
    protected Button bAddPattern;
    protected Point location1;
    protected Point point1;
    protected Point location2;
    protected Point point2;
    protected GChoiceTextField tfGradient;
    protected Checkbox cbDither;
    protected static final String DEFAULT_PATTERN = "\\_/\n/ \\_";

    public FillTool(Plate plate, Jave jave) {
        super(plate, jave);
    }

    public Component createOptionsComponent() {
        this.taPattern = new GTextArea(DEFAULT_PATTERN, 6, 10);
        this.taPattern.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.tfGradient = AsciiGradients.createComponent();
        this.chMatchMode = new Choice();
        int n = 0;
        while (n < FillAlgorithm.STR_MATCH_MODE.length) {
            this.chMatchMode.addItem(FillAlgorithm.STR_MATCH_MODE[n]);
            ++n;
        }
        this.chGradient = new Choice();
        int n2 = 0;
        while (n2 < FillAlgorithm.STR_GRADIENT_STYLE.length) {
            this.chGradient.addItem(FillAlgorithm.STR_GRADIENT_STYLE[n2]);
            ++n2;
        }
        this.cbDither = new Checkbox("dither", true);
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout(0, 1, 2, 2));
        panel.add(this.tfGradient);
        panel.add(this.chGradient);
        panel.add(this.cbDither);
        this.bPattern = new Button("Choose Pattern");
        this.bPattern.addActionListener(this);
        this.bAddPattern = new Button("Add as new pattern");
        this.bAddPattern.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1, 2, 2));
        panel2.add(this.bAddPattern);
        panel2.add(this.bPattern);
        Panel panel3 = new Panel();
        panel3.add(this.taPattern);
        panel3.add(panel2);
        this.cpOptions = new CardPanel();
        this.cpOptions.add(STR_MODE[0], new Label("No options", 1));
        this.cpOptions.add(STR_MODE[1], panel3);
        this.cpOptions.add(STR_MODE[2], panel);
        this.cpOptions.init();
        Panel panel4 = new Panel();
        panel4.add(new Label("Match Mode:", 2));
        panel4.add(this.chMatchMode);
        this.cbMix = new Checkbox("Mix", false);
        this.cbMix.addItemListener(this);
        Panel panel5 = new Panel();
        panel5.setLayout(new GGridLayout2(0, 1, 2, 2));
        panel5.add(this.cpOptions);
        panel5.add(panel4);
        return panel5;
    }

    protected int getCurrentMode() {
        return this.cpOptions.getSelectedItem();
    }

    protected char[][] getPattern() {
        String string = this.taPattern.getText();
        char[][] cArray = TextTools.toCharField(string);
        if (cArray.length == 0 || cArray[0].length == 0) {
            cArray = new char[1][1];
            cArray[0][0] = this.getMouseChar();
        }
        return cArray;
    }

    protected char[] getGradient() {
        String string = this.tfGradient.getText();
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            cArray = new char[]{this.getMouseChar()};
        }
        if (Tool.metaDown) {
            int n = 0;
            while (n < cArray.length / 2) {
                char c = cArray[cArray.length - n - 1];
                cArray[cArray.length - n - 1] = cArray[n];
                cArray[n] = c;
                ++n;
            }
        }
        return cArray;
    }

    public void setPattern(Pattern pattern) {
        this.setPattern(pattern.getCode());
    }

    public void setPattern(String string) {
        this.taPattern.setText(TextTools.toString(JaveAsciiPacker.decode(string)));
    }

    protected void showPatternDialog() {
        if (this.patternDialog == null) {
            this.patternDialog = new PatternDialog((Frame)this.jave, this);
            this.patternDialog.pack();
            GuiTools.centerOnScreen(this.patternDialog);
        }
        this.patternDialog.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bPattern) {
            this.showPatternDialog();
        } else if (object == this.bAddPattern) {
            TextField textField = new TextField("n/a", 15);
            TextField textField2 = new TextField("", 20);
            Panel panel = new Panel();
            panel.setLayout(new GGridLayout2(2, 0, 2, 2));
            panel.add(new Label("Pattern Name:", 2));
            panel.add(textField2);
            panel.add(new Label("Author:", 2));
            panel.add(textField);
            GDialog gDialog = new GDialog((Frame)this.jave, "Add as new pattern", (Component)panel, GDialog.OK_CANCEL);
            gDialog.show();
            int n = gDialog.getAnswer();
            if (n == -1 || n == 1) {
                return;
            }
            String string = textField2.getText();
            String string2 = textField.getText();
            if (string.trim().length() == 0) {
                GDialog gDialog2 = new GDialog((Frame)this.jave, "JavE", "Error adding pattern", "You have not specified a correct name for the new pattern.", 0);
                gDialog2.show();
                return;
            }
            Pattern pattern = new Pattern(string, JaveAsciiPacker.encode(this.getPattern()), string2);
            this.showPatternDialog();
            this.patternDialog.addPattern(pattern);
        }
        super.actionPerformed(actionEvent);
    }

    public String getName() {
        return "Fill";
    }

    public String getIconName() {
        return "fill";
    }

    public void takeToHand() {
        this.setCursor(JaveGlobalRessources.cursorSelection);
    }

    public void putAside(boolean bl) {
    }

    public void mousePressed(Point point, Point point2, MouseEvent mouseEvent) {
        if (point2 == null) {
            return;
        }
        int n = this.getCurrentMode();
        if (n == 0) {
            int n2 = this.chMatchMode.getSelectedIndex();
            this.setMixMode(this.cbMix.getState());
            FillAlgorithm.fillSolid(this.plate.getContent(), point2.x, point2.y, this.getMouseChar(), n2);
            this.plate.saveCurrentState("fill solid");
            this.repaintAll();
            return;
        }
        if (n == 1) {
            int n3 = this.chMatchMode.getSelectedIndex();
            char[][] cArray = this.getPattern();
            this.setMixMode(this.cbMix.getState());
            FillAlgorithm.fillPattern(this.plate.getContent(), point2.x, point2.y, cArray, n3);
            this.plate.saveCurrentState("fill pattern");
            this.repaintAll();
            return;
        }
        if (n == 2 && this.getGradientStyle() == 1) {
            int n4 = this.chMatchMode.getSelectedIndex();
            char[] cArray = this.getGradient();
            this.setMixMode(this.cbMix.getState());
            FillAlgorithm.fillGradient(this.plate.getContent(), point2.x, point2.y, point2.x, point2.y, cArray, 1, n4, this.cbDither.getState());
            this.plate.saveCurrentState("fill gradient");
            this.repaintAll();
            return;
        }
        if (n == 2) {
            this.location1 = point2;
            this.point1 = point;
            this.point2 = point;
            this.repaintCursor();
        }
    }

    public void mouseDragged(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.getCurrentMode() == 2) {
            this.location2 = point2;
            this.point2 = point;
            this.repaintCursor();
        }
    }

    public void mouseReleased(Point point, Point point2, MouseEvent mouseEvent) {
        if (this.getCurrentMode() == 2 || this.getGradientStyle() != 1) {
            this.location2 = point2;
            if (point2 == null || this.location1 == null || this.location1.equals(this.location2)) {
                this.location1 = null;
                this.repaintCursor();
                return;
            }
            int n = this.getGradientStyle();
            int n2 = this.chMatchMode.getSelectedIndex();
            char[] cArray = this.getGradient();
            this.setMixMode(this.cbMix.getState());
            FillAlgorithm.fillGradient(this.plate.getContent(), this.location1.x, this.location1.y, this.location2.x, this.location2.y, cArray, n, n2, this.cbDither.getState());
            this.location1 = null;
            this.location2 = null;
            this.point1 = null;
            this.point2 = null;
            this.plate.saveCurrentState("fill gradient");
            this.repaintAll();
        }
    }

    protected int getGradientStyle() {
        return this.chGradient.getSelectedIndex();
    }

    public void keyPressed(int n, KeyEvent keyEvent) {
        if (this.location1 == null || this.location2 == null) {
            return;
        }
        if (n == 27) {
            this.point1 = null;
            this.point2 = null;
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
            return;
        }
    }

    public void paintCursorFeature(Graphics graphics) {
        if (this.location1 == null || this.location2 == null || this.point1 == null || this.point2 == null) {
            return;
        }
        graphics.setColor(JaveGlobalRessources.colorToolHelping);
        Point point = this.getScreenPointFor(this.location1.x, this.location1.y);
        graphics.drawLine(point.x + this.plate.charWidth / 2, point.y + this.plate.charHeight / 2, this.point2.x, this.point2.y);
        GfxTools.paintArrow(graphics, point.x + this.plate.charWidth / 2, point.y + this.plate.charHeight / 2, this.point2.x, this.point2.y);
    }
}

