/*
 * Decompiled with CFR 0.152.
 */
package de.jave.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class IOTools {
    private IOTools() {
    }

    public static URL toUrl(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = IOTools.toURL(new File(string));
        }
        return uRL;
    }

    public static String toURLString(File file) {
        return IOTools.toURL(file).toExternalForm();
    }

    public static URL toURL(File file) {
        try {
            String string = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                string = string.replace(File.separatorChar, '/');
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if (!string.endsWith("/") && file.isDirectory()) {
                string = string + "/";
            }
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean isZipped(File file) {
        return IOTools.isZipped(IOTools.toURL(file));
    }

    public static boolean isZipped(URL uRL) {
        try {
            DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
            if (dataInputStream.readByte() == 80 && dataInputStream.readByte() == 75 && dataInputStream.readByte() == 3 && dataInputStream.readByte() == 4) {
                return true;
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static BufferedReader openPossiblyZipped(URL uRL) throws IOException {
        BufferedReader bufferedReader = null;
        if (IOTools.isZipped(uRL)) {
            try {
                DataInputStream dataInputStream = new DataInputStream(uRL.openStream());
                ZipInputStream zipInputStream = new ZipInputStream(dataInputStream);
                zipInputStream.getNextEntry();
                bufferedReader = new BufferedReader(new InputStreamReader(zipInputStream));
            }
            catch (ZipException zipException) {
                System.err.println("ZipException " + zipException);
                return null;
            }
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        return bufferedReader;
    }

    public static boolean move(String string, String string2) {
        return IOTools.move(new File(string), new File(string2));
    }

    public static boolean move(File file, File file2) {
        File file3 = new File(new File(file2.getParent()).getAbsolutePath());
        if (!file3.exists() && !file3.mkdirs()) {
            return false;
        }
        return file.renameTo(file2);
    }

    public static boolean copy(String string, String string2) {
        return IOTools.copy(new File(string), new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copy(File file, File file2) {
        block15: {
            int n;
            int n2 = 262144;
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            byte[] byArray = new byte[n2];
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            while ((n = bufferedInputStream.read(byArray)) > -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            Object var8_9 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (Exception exception) {
                    System.out.println("Exception: " + exception.getMessage());
                    exception.printStackTrace();
                    boolean bl = false;
                    Object var8_10 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                        if (filterOutputStream != null) {
                            filterOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    public static final String getDisplayFilename(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = string.lastIndexOf(File.separatorChar);
        if (n2 - n3 + 3 + 3 <= n) {
            return string.substring(0, n - 4 - (n2 - n3)) + "..." + string.substring(n3);
        }
        return string.substring(0, 3) + "..." + string.substring(n2 - 1 - n + 6);
    }

    public static final String getDisplayFilename(File file, int n) {
        return IOTools.getDisplayFilename(file.getAbsolutePath(), n);
    }
}

