/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.braille.BrailleDisplay;
import de.jave.gfx.ImageLoader;
import de.jave.gui.CenterLayout;
import de.jave.gui.GBorderedPanel;
import de.jave.gui.GButton;
import de.jave.gui.GDialog;
import de.jave.gui.GErrorDialog;
import de.jave.gui.GGridLayout;
import de.jave.gui.GGridLayout2;
import de.jave.gui.GProgressDialog;
import de.jave.gui.GSliderArrangement;
import de.jave.gui.GTextArea;
import de.jave.gui.GUpDownArrangement;
import de.jave.gui.GuiTools;
import de.jave.gui.VFlowLayout;
import de.jave.image.GGreyscaleImage;
import de.jave.image.GImage;
import de.jave.image.ImageCanvas2;
import de.jave.image2ascii.BatchConversionThread;
import de.jave.image2ascii.ConversionThread;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.Image2AsciiAlgorithmBraille;
import de.jave.image2ascii.Image2AsciiAlgorithmFactory;
import de.jave.io.IOTools;
import de.jave.jave.CharacterPlate;
import de.jave.jave.JMOVExporter;
import de.jave.jave.JaveImages;
import gebhard.uielements.CardPanel;
import gebhard.uielements.IntegerTextField;
import gebhard.uielements.NumberEvent;
import gebhard.uielements.NumberListener;
import gebhard.uielements.ProgressBar;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.util.Hashtable;

public class Image2Texter
extends Panel
implements ActionListener,
NumberListener,
ItemListener,
AdjustmentListener,
TextListener {
    public static final String TITLE = "Image2Ascii V4.0";
    protected ConversionThread conversionThread;
    protected GGreyscaleImage previewImageRaw;
    protected GGreyscaleImage gImageRaw;
    protected GBorderedPanel pAlgorithmOptions;
    protected Panel panelOutput;
    protected Component brailleComponent;
    protected ProgressBar progressBar;
    protected Choice chAlgorithm;
    protected Choice chRotate;
    protected Choice chDithering;
    protected Image2AsciiAlgorithm[] algorithms;
    protected GTextArea taOutput;
    protected BrailleDisplay brailleDisplay;
    private ImageCanvas2 cSourceImage;
    private ImageCanvas2 cPreviewImage;
    protected IntegerTextField ifWidth;
    protected GSliderArrangement slaSharpen;
    protected GSliderArrangement slaShadow;
    protected GSliderArrangement slaHighlight;
    protected GSliderArrangement slaGamma;
    protected GSliderArrangement slaShape;
    protected TextField tfImageName;
    protected GButton gbLoad;
    protected Button bBatch;
    protected Button bDefault;
    protected Checkbox cbNegative;
    protected Checkbox cbNormalize;
    protected String currentDirectory;
    protected static final Font FONT = new Font("Courier", 0, 10);
    protected static final int RESULT_WIDTH_DEFAULT = 72;
    protected static final int HIGHLIGHT_DEFAULT = 100;
    protected static final int HIGHLIGHT_MIN = 0;
    protected static final int HIGHLIGHT_MAX = 100;
    protected static final int HIGHLIGHT_STEP = 1;
    protected static final int HIGHLIGHT_DIVIDE = 1;
    protected static final int SHADOW_DEFAULT = 0;
    protected static final int SHADOW_MIN = 0;
    protected static final int SHADOW_MAX = 100;
    protected static final int SHADOW_STEP = 1;
    protected static final int SHADOW_DIVIDE = 1;
    protected static final int GAMMA_DEFAULT = 100;
    protected static final int GAMMA_MIN = 1;
    protected static final int GAMMA_MAX = 500;
    protected static final int GAMMA_STEP = 1;
    protected static final int GAMMA_DIVIDE = 100;
    protected static final int SHARPEN_DEFAULT = 0;
    protected static final int SHARPEN_MIN = 0;
    protected static final int SHARPEN_MAX = 100;
    protected static final int SHARPEN_STEP = 1;
    protected static final int SHARPEN_DIVIDE = 100;
    protected static final int SHAPE_DEFAULT = 100;
    protected static final int SHAPE_MIN = 50;
    protected static final int SHAPE_MAX = 150;
    protected static final int SHAPE_STEP = 5;
    protected static final int SHAPE_DIVIDE = 100;
    protected static final int PREVIEW_MAX_WIDTH = 128;
    protected static final int PREVIEW_MAX_HEIGHT = 75;
    protected static final int SOURCE_VIEW_MAX_WIDTH = 128;
    protected static final int SOURCE_VIEW_MAX_HEIGHT = 128;
    protected CharacterPlate resultPlate;

    public Image2Texter() {
        this.init();
        this.convert2Text();
    }

    public void setImage(String string) throws RuntimeException {
        int n;
        int n2;
        double d;
        double d2;
        double d3;
        this.tfImageName.setText(IOTools.getDisplayFilename(string, 25));
        Image image = ImageLoader.loadImage(string, this);
        int n3 = image.getWidth(this);
        int n4 = image.getHeight(this);
        if (n3 <= 0 || n4 <= 0) {
            throw new RuntimeException("Image file damaged or unable to open file.");
        }
        Image image2 = null;
        if (n3 < 128 && n4 < 128) {
            image2 = image;
        } else {
            d3 = 128.0 / (double)n3;
            d2 = 128.0 / (double)n3;
            d = Math.min(d3, d2);
            n2 = (int)(d * (double)n3);
            n = (int)(d * (double)n4);
            image2 = image.getScaledInstance(n2, n, 2);
        }
        this.cSourceImage.setImage(image2);
        d3 = 128.0 / (double)n3;
        d2 = 75.0 / (double)n4;
        d = d3 < d2 ? d3 : d2;
        n2 = (int)((double)n3 * d);
        n = (int)((double)n4 * d);
        Image image3 = null;
        image3 = d >= 1.0 ? image : image.getScaledInstance(n2, n, 2);
        int[] nArray = new int[n2 * n];
        PixelGrabber pixelGrabber = new PixelGrabber(image3, 0, 0, n2, n, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Internal Error: " + interruptedException.toString());
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new RuntimeException("Internal Error: Image fetch aborted or errored.");
        }
        this.previewImageRaw = new GGreyscaleImage(nArray, n2, n);
        int n5 = n3;
        int n6 = n4;
        int[] nArray2 = new int[n5 * n6];
        PixelGrabber pixelGrabber2 = new PixelGrabber(image, 0, 0, n5, n6, nArray2, 0, n5);
        try {
            pixelGrabber2.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Internal Error: " + interruptedException.toString());
            return;
        }
        if ((pixelGrabber2.getStatus() & 0x80) != 0) {
            System.err.println("Internal Error: image fetch aborted or errored");
            return;
        }
        this.gImageRaw = new GGreyscaleImage(nArray2, n5, n6);
        this.convertPreview();
        this.convert2Text();
        this.validate();
    }

    public Image getSourceImage() {
        return this.cSourceImage.getImage();
    }

    protected void convertPreview() {
        if (this.gImageRaw == null) {
            return;
        }
        boolean bl = this.cbNegative.getState();
        boolean bl2 = this.cbNormalize.getState();
        int n = this.slaHighlight.getValue();
        int n2 = this.slaShadow.getValue();
        double d = this.slaGamma.getDValue();
        double d2 = this.slaSharpen.getDValue();
        int n3 = -1;
        if (this.chDithering.isEnabled()) {
            n3 = this.chDithering.getSelectedIndex();
        }
        int n4 = this.chRotate.getSelectedIndex();
        GGreyscaleImage gGreyscaleImage = this.previewImageRaw.convert(bl2, bl, d, n, n2);
        if (d2 > 0.0) {
            gGreyscaleImage = gGreyscaleImage.sharpen(d2);
        }
        GImage gImage = gGreyscaleImage;
        if (n3 != -1) {
            gImage = gGreyscaleImage.dither(n3);
        }
        if (n4 != 0) {
            gImage = gImage.rotate(n4);
        }
        this.cPreviewImage.setImage(gImage);
    }

    protected Panel createPanel1() {
        this.cSourceImage = new ImageCanvas2();
        this.cSourceImage.setWidthLimit(200);
        this.cSourceImage.setHeightLimit(250);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(2, 2));
        Panel panel2 = new Panel();
        panel2.setLayout(new CenterLayout());
        panel2.add(this.cSourceImage);
        panel.add((Component)panel2, "Center");
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 1, 2, 2));
        this.tfImageName = new TextField(25);
        this.tfImageName.setEditable(false);
        this.gbLoad = JaveImages.createButton("open", "open_");
        this.gbLoad.addActionListener(this);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(1, 0, 0));
        panel4.add(new Label("Image:", 2));
        panel4.add(this.tfImageName);
        panel4.add(this.gbLoad);
        panel3.add(panel4);
        this.bBatch = new Button("Batch Conversion");
        this.bBatch.addActionListener(this);
        panel3.add(this.bBatch);
        panel.add((Component)panel3, "South");
        return panel;
    }

    protected Panel createPanel2() {
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout(0, 2, 2, 2));
        panel.add(this.createPanel2a());
        panel.add(this.createPanel2b());
        return panel;
    }

    protected Panel createPanel4() {
        Panel panel = new Panel();
        panel.add(new Label("Text width:"));
        this.ifWidth = new IntegerTextField(72);
        this.ifWidth.addNumberListener(this);
        panel.add(new GUpDownArrangement(this.ifWidth));
        this.slaShape = new GSliderArrangement("Shape factor:", 50, 150, 100, 5, 100);
        this.slaShape.addAdjustmentListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new VFlowLayout());
        panel2.add(panel);
        panel2.add(this.slaShape);
        return panel2;
    }

    protected Panel createPanel3() {
        this.progressBar = new ProgressBar();
        this.algorithms = Image2AsciiAlgorithmFactory.createAlgorithms();
        this.chAlgorithm = new Choice();
        int n = 0;
        while (n < this.algorithms.length) {
            this.algorithms[n].setProgressListener(this.progressBar);
            this.algorithms[n].addActionListener(this);
            this.chAlgorithm.add(this.algorithms[n].getAlgorithmName());
            ++n;
        }
        this.chAlgorithm.addItemListener(this);
        this.pAlgorithmOptions = new GBorderedPanel("Algorithm Options");
        Component component = this.algorithms[0].getAdjustmentComponent();
        if (component != null) {
            this.pAlgorithmOptions.add(component);
        } else {
            this.pAlgorithmOptions.setEnabled(false);
        }
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.add(new Label("Algorithm:"));
        panel2.add(this.chAlgorithm);
        panel.add((Component)panel2, "North");
        panel.add((Component)this.pAlgorithmOptions, "Center");
        return panel;
    }

    private void init() {
        this.taOutput = new GTextArea(15, 80);
        this.taOutput.setEditable(false);
        this.taOutput.setFont(FONT);
        this.taOutput.setBackground(Color.white);
        this.taOutput.setForeground(Color.black);
        CardPanel cardPanel = new CardPanel();
        cardPanel.add("Source image", this.createPanel1());
        cardPanel.add("Image processing", this.createPanel2());
        cardPanel.add("Conversion", this.createPanel3());
        cardPanel.add("Output", this.createPanel4());
        cardPanel.init();
        this.setLayout(new BorderLayout());
        Panel panel = this.createOutputPanel();
        this.add((Component)panel, "Center");
        this.add((Component)cardPanel, "North");
        this.add((Component)this.progressBar, "South");
        Image2AsciiAlgorithm image2AsciiAlgorithm = this.algorithms[this.chAlgorithm.getSelectedIndex()];
        this.chDithering.setEnabled(image2AsciiAlgorithm.requiresBWImage());
    }

    protected Panel createOutputPanel() {
        this.panelOutput = new Panel();
        this.panelOutput.setLayout(new GridLayout(1, 0, 2, 2));
        this.panelOutput.add(this.taOutput);
        GBorderedPanel gBorderedPanel = new GBorderedPanel("Result:", -1);
        gBorderedPanel.setLayout(new GridLayout());
        gBorderedPanel.add(this.panelOutput);
        return gBorderedPanel;
    }

    protected Panel createPanel2a() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 1));
        this.slaHighlight = new GSliderArrangement("Highlight:", 0, 100, 100, 1, 1);
        this.slaHighlight.addAdjustmentListener(this);
        panel.add(this.slaHighlight);
        this.slaShadow = new GSliderArrangement("Shadow:", 0, 100, 0, 1, 1);
        this.slaShadow.addAdjustmentListener(this);
        panel.add(this.slaShadow);
        this.slaGamma = new GSliderArrangement("Gamma:", 1, 500, 100, 1, 100);
        this.slaGamma.addAdjustmentListener(this);
        panel.add(this.slaGamma);
        this.slaSharpen = new GSliderArrangement("Sharpen:", 0, 100, 0, 1, 100);
        this.slaSharpen.addAdjustmentListener(this);
        panel.add(this.slaSharpen);
        this.chRotate = new Choice();
        int n = 0;
        while (n < GGreyscaleImage.ROTATE_STR.length) {
            this.chRotate.addItem(GGreyscaleImage.ROTATE_STR[n]);
            ++n;
        }
        this.chRotate.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.add(new Label("Rotate:", 2));
        panel2.add(this.chRotate);
        panel.add(panel2);
        return panel;
    }

    public Panel createPanel2b() {
        Panel panel = new Panel();
        panel.setLayout(new GGridLayout2(0, 1));
        this.cPreviewImage = new ImageCanvas2();
        panel.add(this.cPreviewImage);
        this.chDithering = new Choice();
        int n = 0;
        while (n < GGreyscaleImage.STR_DITHER_METHODES.length) {
            this.chDithering.add(GGreyscaleImage.STR_DITHER_METHODES[n]);
            ++n;
        }
        this.chDithering.select(0);
        this.chDithering.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)new Label("Dithering:", 2), "West");
        panel2.add((Component)this.chDithering, "Center");
        panel.add(panel2);
        this.cbNegative = new Checkbox("Negative Image", false);
        this.cbNegative.addItemListener(this);
        panel.add(this.cbNegative);
        this.cbNormalize = new Checkbox("Normalize Histogram", true);
        this.cbNormalize.addItemListener(this);
        panel.add(this.cbNormalize);
        this.bDefault = new Button("Default Values");
        this.bDefault.addActionListener(this);
        panel.add(this.bDefault);
        return panel;
    }

    public void textValueChanged(TextEvent textEvent) {
        this.convert2Text();
    }

    public CharacterPlate getResult() {
        return this.resultPlate;
    }

    public void setResult(CharacterPlate characterPlate) {
        this.resultPlate = characterPlate;
        if (characterPlate != null) {
            this.taOutput.setText(characterPlate.toString());
        } else {
            this.taOutput.setText("");
        }
    }

    public void convert2Text() {
        if (this.gImageRaw == null) {
            return;
        }
        double d = this.slaShape.getDValue();
        boolean bl = this.cbNormalize.getState();
        boolean bl2 = this.cbNegative.getState();
        int n = this.slaHighlight.getValue();
        int n2 = this.slaShadow.getValue();
        double d2 = this.slaGamma.getDValue();
        double d3 = this.slaSharpen.getDValue();
        int n3 = this.ifWidth.getValue();
        int n4 = -1;
        if (this.chDithering.isEnabled()) {
            n4 = this.chDithering.getSelectedIndex();
        }
        int n5 = this.chRotate.getSelectedIndex();
        if (this.conversionThread != null) {
            this.conversionThread.breakConversion();
        }
        this.conversionThread = new ConversionThread(this.gImageRaw, n3, d, bl, bl2, n, n2, d2, d3, n4, n5, this.algorithms[this.chAlgorithm.getSelectedIndex()], this);
        this.conversionThread.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Image2AsciiAlgorithm) {
            this.convert2Text();
        } else if (object == this.bDefault) {
            this.setDefaults();
        } else {
            if (object == this.gbLoad) {
                this.load();
                return;
            }
            if (object == this.bBatch) {
                this.batchConvert();
                return;
            }
        }
    }

    protected void batchConvert() {
        int n;
        int n2;
        Object object;
        Frame frame = GuiTools.getParentFrame(this);
        if (frame == null) {
            throw new RuntimeException("No parent -> no filedialog!!");
        }
        if (this.currentDirectory == null) {
            String string = "For Batch Conversion you first have to open a single\nimage file and do all the adjustments.\nThen all the files in the current directory\nare converted using those adjustments.";
            String[] stringArray = new String[]{"Ok"};
            GDialog gDialog = new GDialog(frame, "Image2Ascii", "No image", string, stringArray, 3);
            gDialog.pack();
            gDialog.show();
            return;
        }
        JMOVExporter jMOVExporter = new JMOVExporter();
        if (!jMOVExporter.showOptionsDialogs(frame, "Batch conversion")) {
            return;
        }
        File file = new File(this.currentDirectory);
        if (!file.isDirectory()) {
            throw new RuntimeException("'currentDirectory' is no directory ???");
        }
        String[] stringArray = file.list();
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>(stringArray.length * 2);
        int n3 = 0;
        while (n3 < stringArray.length) {
            object = stringArray[n3].toLowerCase();
            if (((String)object).endsWith(".gif") || ((String)object).endsWith(".jpg") || ((String)object).endsWith(".jpeg") || ((String)object).endsWith(".bmp")) {
                n2 = 0;
                while (n2 < stringArray[n3].length() && (stringArray[n3].charAt(n2) < '0' || stringArray[n3].charAt(n2) > '9')) {
                    ++n2;
                }
                n = n2 + 1;
                while (n < stringArray[n3].length() && stringArray[n3].charAt(n) >= '0' && stringArray[n3].charAt(n) <= '9') {
                    ++n;
                }
                if (n2 < stringArray[n3].length()) {
                    int n4 = Integer.parseInt(stringArray[n3].substring(n2, n));
                    hashtable.put(new Integer(n4), stringArray[n3]);
                }
            }
            ++n3;
        }
        object = new String[hashtable.size()];
        n2 = 0;
        n = 0;
        while (n2 < ((Object)object).length) {
            Integer n5;
            if (!hashtable.containsKey(n5 = new Integer(n++))) continue;
            object[n2++] = this.currentDirectory + (String)hashtable.get(n5);
        }
        double d = this.slaShape.getDValue();
        boolean bl = this.cbNormalize.getState();
        boolean bl2 = this.cbNegative.getState();
        int n6 = this.slaHighlight.getValue();
        int n7 = this.slaShadow.getValue();
        double d2 = this.slaGamma.getDValue();
        double d3 = this.slaSharpen.getDValue();
        int n8 = this.ifWidth.getValue();
        int n9 = -1;
        if (this.chDithering.isEnabled()) {
            n9 = this.chDithering.getSelectedIndex();
        }
        int n10 = this.chRotate.getSelectedIndex();
        GProgressDialog gProgressDialog = new GProgressDialog(frame, "Batch Conversion", "Batch converting " + ((Object)object).length + " images", true);
        jMOVExporter.setEstimatedFileCount(((Object)object).length);
        BatchConversionThread batchConversionThread = new BatchConversionThread(frame, gProgressDialog, (String[])object, this.currentDirectory, n8, d, bl, bl2, n6, n7, d2, d3, n9, n10, this.algorithms[this.chAlgorithm.getSelectedIndex()], jMOVExporter);
        gProgressDialog.addCancelListener(batchConversionThread);
        gProgressDialog.show();
        batchConversionThread.start();
    }

    protected void load() {
        Frame frame = GuiTools.getParentFrame(this);
        if (frame == null) {
            throw new RuntimeException("No parent -> no filedialog!!");
        }
        FileDialog fileDialog = new FileDialog(frame, "Open image", 0);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        if (string == null) {
            return;
        }
        String string3 = string.toLowerCase();
        if (!(string3.endsWith(".gif") || string3.endsWith(".jpg") || string3.endsWith(".jpeg") || string3.endsWith(".bmp"))) {
            String string4 = "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).";
            new GDialog(frame, "Image2Ascii", "Error loading image", string4, 3).show();
            return;
        }
        this.open(string2, string);
    }

    public boolean open(String string, String string2) {
        String string3 = string + string2;
        try {
            this.setImage(string3);
        }
        catch (RuntimeException runtimeException) {
            Frame frame = GuiTools.getParentFrame(this);
            if (frame == null) {
                throw new RuntimeException("No parent -> no errordialog!!");
            }
            new GErrorDialog(frame, "Image2Ascii", "Unknown error loading image", "Wrong file format?\nSupported formats: GIF, JPG, BMP (experimental).", runtimeException).show();
            return false;
        }
        this.currentDirectory = string;
        this.convert2Text();
        return true;
    }

    public void done() {
        String string = this.taOutput.getText();
        System.out.println(string);
    }

    protected void setDefaults() {
        this.slaGamma.setDefault();
        this.slaHighlight.setDefault();
        this.slaShadow.setDefault();
        this.slaShape.setDefault();
        this.slaSharpen.setDefault();
    }

    public void numberChanged(NumberEvent numberEvent) {
        this.convertPreview();
        this.convert2Text();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Image2AsciiAlgorithm image2AsciiAlgorithm = this.algorithms[this.chAlgorithm.getSelectedIndex()];
        if (itemEvent.getSource() == this.chAlgorithm) {
            this.pAlgorithmOptions.removeAll();
            Component component = image2AsciiAlgorithm.getAdjustmentComponent();
            if (component != null) {
                this.pAlgorithmOptions.setEnabled(true);
                this.pAlgorithmOptions.add(component);
                component.invalidate();
                component.validate();
            } else {
                this.pAlgorithmOptions.setEnabled(false);
            }
            this.pAlgorithmOptions.invalidate();
            this.pAlgorithmOptions.validate();
            this.pAlgorithmOptions.repaint();
            Container container = this.pAlgorithmOptions.getParent();
            container.doLayout();
            container.validate();
        }
        this.chDithering.setEnabled(image2AsciiAlgorithm.requiresBWImage());
        if (image2AsciiAlgorithm instanceof Image2AsciiAlgorithmBraille) {
            if (this.brailleDisplay == null) {
                this.brailleDisplay = new BrailleDisplay(" ");
                ((Image2AsciiAlgorithmBraille)image2AsciiAlgorithm).setBrailleDisplay(this.brailleDisplay);
            }
            if (this.panelOutput.getComponentCount() == 1) {
                this.brailleComponent = new ScrollPane();
                ((ScrollPane)this.brailleComponent).add(this.brailleDisplay);
                this.panelOutput.add(this.brailleComponent);
                this.panelOutput.validate();
            }
        } else if (this.brailleDisplay != null && this.panelOutput.getComponentCount() > 1) {
            this.panelOutput.remove(this.brailleComponent);
            this.panelOutput.validate();
        }
        this.convertPreview();
        this.convert2Text();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.convertPreview();
        this.convert2Text();
    }
}

